/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.example.spring.boot;

import jakarta.annotation.PostConstruct;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication
public class SampleAuthenticationSpringBootService {
    private static final Logger LOG = LoggerFactory.getLogger(SampleAuthenticationSpringBootService.class);
    private static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";

    public static void main(String[] args) {
        SpringApplication.run(SampleAuthenticationSpringBootService.class, (String[])args);
    }

    @PostConstruct
    public void init() {
        Optional.ofNullable(this.getClass().getClassLoader().getResource("login.conf")).ifPresent(loginResource -> this.setSystemPropertyIfNotSet(JAVA_SECURITY_AUTH_LOGIN_CONFIG, loginResource.toExternalForm()));
        LOG.info("Using loginResource {} : {}", (Object)JAVA_SECURITY_AUTH_LOGIN_CONFIG, (Object)System.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG));
        Optional.ofNullable(this.getClass().getClassLoader().getResource("realm.properties")).ifPresent(loginFile -> this.setSystemPropertyIfNotSet("login.file", loginFile.toExternalForm()));
        LOG.info("Using login.file : {}", (Object)System.getProperty("login.file"));
        this.setSystemPropertyIfNotSet("hawtio.roles", "admin");
        this.setSystemPropertyIfNotSet("hawtio.realm", "hawtio");
        this.setSystemPropertyIfNotSet("hawtio.rolePrincipalClasses", "org.eclipse.jetty.security.jaas.JAASRole");
        System.setProperty("hawtio.authenticationEnabled", Boolean.getBoolean("debugMode") ? "false" : "true");
    }

    private void setSystemPropertyIfNotSet(String key, String value) {
        if (System.getProperty(key) == null) {
            System.setProperty(key, value);
        }
    }
}

