/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.s2a.internal.handshaker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.s2a.proto.v2.S2AServiceGrpc;
import com.google.s2a.proto.v2.SessionReq;
import com.google.s2a.proto.v2.SessionResp;
import io.grpc.s2a.internal.handshaker.ConnectionClosedException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class S2AStub
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(S2AStub.class.getName());
    private static final long HANDSHAKE_RPC_DEADLINE_SECS = 20L;
    private final StreamObserver<SessionResp> reader = new Reader();
    private final BlockingQueue<Result> responses = new ArrayBlockingQueue<Result>(10);
    private S2AServiceGrpc.S2AServiceStub serviceStub;
    private StreamObserver<SessionReq> writer;
    private boolean doneReading = false;
    private boolean doneWriting = false;
    private boolean isClosed = false;

    @VisibleForTesting
    public static S2AStub newInstance(S2AServiceGrpc.S2AServiceStub serviceStub) {
        Preconditions.checkNotNull((Object)serviceStub);
        return new S2AStub(serviceStub);
    }

    @VisibleForTesting
    static S2AStub newInstanceForTesting(StreamObserver<SessionReq> writer) {
        Preconditions.checkNotNull(writer);
        return new S2AStub(writer);
    }

    private S2AStub(S2AServiceGrpc.S2AServiceStub serviceStub) {
        this.serviceStub = serviceStub;
    }

    private S2AStub(StreamObserver<SessionReq> writer) {
        this.writer = writer;
    }

    @VisibleForTesting
    StreamObserver<SessionResp> getReader() {
        return this.reader;
    }

    @VisibleForTesting
    BlockingQueue<Result> getResponses() {
        return this.responses;
    }

    public SessionResp send(SessionReq req) throws IOException, InterruptedException {
        if (this.doneWriting && this.doneReading) {
            logger.log(Level.INFO, "Stream to the S2A is closed.");
            throw new ConnectionClosedException("Stream to the S2A is closed.");
        }
        this.createWriterIfNull();
        if (!this.responses.isEmpty()) {
            IOException exception = null;
            try {
                this.responses.take().getResultOrThrow();
            }
            catch (IOException e) {
                exception = e;
            }
            this.responses.clear();
            if (exception != null) {
                throw new IOException("Received an unexpected response from a host at the S2A's address. The S2A might be unavailable.", exception);
            }
            throw new IOException("Received an unexpected response from a host at the S2A's address.");
        }
        try {
            this.writer.onNext((Object)req);
        }
        catch (RuntimeException e) {
            this.writer.onError((Throwable)e);
            this.responses.add(Result.createWithThrowable(e));
        }
        try {
            return this.responses.take().getResultOrThrow();
        }
        catch (ConnectionClosedException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.doneWriting && this.doneReading) {
            return;
        }
        Verify.verify((!this.doneWriting ? 1 : 0) != 0);
        this.doneReading = true;
        this.doneWriting = true;
        if (this.writer != null) {
            this.writer.onCompleted();
        }
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private void createWriterIfNull() {
        if (this.writer == null) {
            this.writer = ((S2AServiceGrpc.S2AServiceStub)((S2AServiceGrpc.S2AServiceStub)this.serviceStub.withWaitForReady()).withDeadlineAfter(20L, TimeUnit.SECONDS)).setUpSession(this.reader);
        }
    }

    private static final class Result {
        private final Optional<SessionResp> response;
        private final Optional<Throwable> throwable;

        static Result createWithResponse(SessionResp response) {
            return new Result(Optional.of(response), Optional.empty());
        }

        static Result createWithThrowable(Throwable throwable) {
            return new Result(Optional.empty(), Optional.of(throwable));
        }

        private Result(Optional<SessionResp> response, Optional<Throwable> throwable) {
            Preconditions.checkArgument((response.isPresent() != throwable.isPresent() ? 1 : 0) != 0);
            this.response = response;
            this.throwable = throwable;
        }

        SessionResp getResultOrThrow() throws IOException {
            if (this.throwable.isPresent()) {
                if (this.throwable.get() instanceof ConnectionClosedException) {
                    ConnectionClosedException exception = (ConnectionClosedException)this.throwable.get();
                    throw exception;
                }
                throw new IOException(this.throwable.get());
            }
            Verify.verify((boolean)this.response.isPresent());
            return this.response.get();
        }
    }

    private class Reader
    implements StreamObserver<SessionResp> {
        private Reader() {
        }

        public void onNext(SessionResp resp) {
            Verify.verify((!S2AStub.this.doneReading ? 1 : 0) != 0);
            S2AStub.this.responses.add(Result.createWithResponse(resp));
        }

        public void onError(Throwable t) {
            S2AStub.this.responses.add(Result.createWithThrowable(t));
        }

        public void onCompleted() {
            logger.log(Level.INFO, "Reading from the S2A is complete.");
            S2AStub.this.doneReading = true;
            S2AStub.this.responses.add(Result.createWithThrowable(new ConnectionClosedException("Reading from the S2A is complete.")));
        }
    }
}

