/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.base.Function;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.alts.ComputeEngineChannelCredentials;
import io.grpc.testing.integration.SoakClient;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.junit.Assert;

public final class XdsFederationTestClient {
    private static final Logger logger = Logger.getLogger(XdsFederationTestClient.class.getName());
    private String serverUris = "";
    private String credentialsTypes = "";
    private int soakIterations = 10;
    private int soakMaxFailures = 0;
    private int soakPerIterationMaxAcceptableLatencyMs = 1000;
    private int soakOverallTimeoutSeconds = 10;
    private int soakMinTimeMsBetweenRpcs = 0;
    private int soakRequestSize = 271828;
    private int soakResponseSize = 314159;
    private String testCase = "rpc_soak";
    private final ArrayList<InnerClient> clients = new ArrayList();

    public static void main(String[] args) throws Exception {
        XdsFederationTestClient client = new XdsFederationTestClient();
        client.parseArgs(args);
        client.setUp();
        client.run();
        System.exit(0);
    }

    private void parseArgs(String[] args) {
        boolean usage = false;
        block24: for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if (key.equals("help")) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            switch (key) {
                case "server_uris": {
                    this.serverUris = value;
                    continue block24;
                }
                case "credentials_types": {
                    this.credentialsTypes = value;
                    continue block24;
                }
                case "test_case": {
                    this.testCase = value;
                    continue block24;
                }
                case "soak_iterations": {
                    this.soakIterations = Integer.parseInt(value);
                    continue block24;
                }
                case "soak_max_failures": {
                    this.soakMaxFailures = Integer.parseInt(value);
                    continue block24;
                }
                case "soak_per_iteration_max_acceptable_latency_ms": {
                    this.soakPerIterationMaxAcceptableLatencyMs = Integer.parseInt(value);
                    continue block24;
                }
                case "soak_overall_timeout_seconds": {
                    this.soakOverallTimeoutSeconds = Integer.parseInt(value);
                    continue block24;
                }
                case "soak_min_time_ms_between_rpcs": {
                    this.soakMinTimeMsBetweenRpcs = Integer.parseInt(value);
                    continue block24;
                }
                case "soak_request_size": {
                    this.soakRequestSize = Integer.parseInt(value);
                    continue block24;
                }
                case "soak_response_size": {
                    this.soakResponseSize = Integer.parseInt(value);
                    continue block24;
                }
                default: {
                    System.err.println("Unknown argument: " + key);
                    usage = true;
                }
            }
        }
        if (usage) {
            XdsFederationTestClient c = new XdsFederationTestClient();
            System.out.println("Usage: [ARGS...]\n\n  --server_uris                         Comma separated list of server URIs to make RPCs to. Default: " + c.serverUris + "\n  --credentials_types                   Comma-separated list of \n                                        credentials, each entry is used \n                                        for the server of the \n                                        corresponding index in server_uris. \n                                        Supported values: compute_engine_channel_creds,INSECURE_CREDENTIALS. Default: " + c.credentialsTypes + "\n  --soak_iterations                     The number of iterations to use \n                                        for the two tests: rpc_soak and \n                                        channel_soak. Default: " + c.soakIterations + "\n  --soak_max_failures                   The number of iterations in soak \n                                        tests that are allowed to fail \n                                        (either due to non-OK status code \n                                        or exceeding the per-iteration max \n                                        acceptable latency). Default: " + c.soakMaxFailures + "\n  --soak_per_iteration_max_acceptable_latency_ms\n                                        The number of milliseconds a \n                                        single iteration in the two soak \n                                        tests (rpc_soak and channel_soak) \n                                        should take. Default: " + c.soakPerIterationMaxAcceptableLatencyMs + "\n  --soak_overall_timeout_seconds        The overall number of seconds \n                                        after which a soak test should \n                                        stop and fail, if the desired \n                                        number of iterations have not yet \n                                        completed. Default: " + c.soakOverallTimeoutSeconds + "\n  --soak_min_time_ms_between_rpcs       The minimum time in milliseconds \n                                        between consecutive RPCs in a soak \n                                        test (rpc_soak or channel_soak), \n                                        useful for limiting QPS. Default: " + c.soakMinTimeMsBetweenRpcs + "\n  --test_case=TEST_CASE                 Test case to run. Valid options are:\n      rpc_soak: sends --soak_iterations large_unary RPCs\n      channel_soak: sends --soak_iterations RPCs, rebuilding the channel each time.\n      Default: " + c.testCase + "\n --soak_request_size \n                                        The request size in a soak RPC. Default " + c.soakRequestSize + "\n --soak_response_size \n                                          The response size in a soak RPC. Default " + c.soakResponseSize);
            System.exit(1);
        }
    }

    void setUp() {
        String[] uris = this.serverUris.split(",", -1);
        String[] creds = this.credentialsTypes.split(",", -1);
        if (uris.length == 0) {
            throw new IllegalArgumentException("--server_uris is empty");
        }
        if (uris.length != creds.length) {
            throw new IllegalArgumentException("Number of entries in --server_uris does not match number of entries in --credentials_types");
        }
        for (int i = 0; i < uris.length; ++i) {
            this.clients.add(new InnerClient(creds[i], uris[i]));
        }
    }

    private void run() throws InterruptedException {
        logger.info("Begin test case: " + this.testCase);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (InnerClient c : this.clients) {
            Thread t = new Thread(() -> {
                try {
                    c.run();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Thread was interrupted during execution", e);
                }
            });
            t.start();
            threads.add(t);
        }
        for (Thread t : threads) {
            t.join();
        }
        for (InnerClient c : this.clients) {
            Assert.assertTrue((boolean)c.runSucceeded());
        }
        logger.info("Test case: " + this.testCase + " done for all clients!");
    }

    class InnerClient {
        private final String credentialsType;
        private final String serverUri;
        private boolean runSucceeded = false;

        public InnerClient(String credentialsType, String serverUri) {
            this.credentialsType = credentialsType;
            this.serverUri = serverUri;
        }

        public boolean runSucceeded() {
            return this.runSucceeded;
        }

        public void run() throws InterruptedException {
            try {
                switch (XdsFederationTestClient.this.testCase) {
                    case "rpc_soak": {
                        SoakClient.performSoakTest(this.serverUri, XdsFederationTestClient.this.soakIterations, XdsFederationTestClient.this.soakMaxFailures, XdsFederationTestClient.this.soakPerIterationMaxAcceptableLatencyMs, XdsFederationTestClient.this.soakMinTimeMsBetweenRpcs, XdsFederationTestClient.this.soakOverallTimeoutSeconds, XdsFederationTestClient.this.soakRequestSize, XdsFederationTestClient.this.soakResponseSize, 1, this.createChannel(), (Function<ManagedChannel, ManagedChannel>)((Function)currentChannel -> currentChannel));
                        break;
                    }
                    case "channel_soak": {
                        SoakClient.performSoakTest(this.serverUri, XdsFederationTestClient.this.soakIterations, XdsFederationTestClient.this.soakMaxFailures, XdsFederationTestClient.this.soakPerIterationMaxAcceptableLatencyMs, XdsFederationTestClient.this.soakMinTimeMsBetweenRpcs, XdsFederationTestClient.this.soakOverallTimeoutSeconds, XdsFederationTestClient.this.soakRequestSize, XdsFederationTestClient.this.soakResponseSize, 1, this.createChannel(), (Function<ManagedChannel, ManagedChannel>)((Function)currentChannel -> this.createNewChannel((ManagedChannel)currentChannel)));
                        break;
                    }
                    default: {
                        throw new RuntimeException("invalid testcase: " + XdsFederationTestClient.this.testCase);
                    }
                }
                logger.info("Test case: " + XdsFederationTestClient.this.testCase + " done for server: " + this.serverUri);
                this.runSucceeded = true;
            }
            catch (Exception e) {
                logger.info("Test case: " + XdsFederationTestClient.this.testCase + " failed for server: " + this.serverUri);
                throw new RuntimeException(e);
            }
        }

        ManagedChannel createChannel() {
            ChannelCredentials channelCredentials;
            switch (this.credentialsType) {
                case "compute_engine_channel_creds": {
                    channelCredentials = ComputeEngineChannelCredentials.create();
                    break;
                }
                case "INSECURE_CREDENTIALS": {
                    channelCredentials = InsecureChannelCredentials.create();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown custom credentials: " + this.credentialsType);
                }
            }
            return Grpc.newChannelBuilder((String)this.serverUri, (ChannelCredentials)channelCredentials).keepAliveTime(3600L, TimeUnit.SECONDS).keepAliveTimeout(20L, TimeUnit.SECONDS).build();
        }

        ManagedChannel createNewChannel(ManagedChannel currentChannel) {
            currentChannel.shutdownNow();
            try {
                currentChannel.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while creating a new channel", e);
            }
            return this.createChannel();
        }
    }
}

