/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.ForwardingServerCall;
import io.grpc.Grpc;
import io.grpc.InsecureServerCredentials;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.Status;
import io.grpc.gcp.csm.observability.CsmObservability;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.protobuf.services.HealthStatusManager;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.grpc.services.AdminInterface;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.EmptyProtos;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import io.grpc.testing.integration.XdsUpdateHealthServiceGrpc;
import io.grpc.xds.XdsServerBuilder;
import io.grpc.xds.XdsServerCredentials;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class XdsTestServer {
    static final Metadata.Key<String> HOSTNAME_KEY = Metadata.Key.of((String)"hostname", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> CALL_BEHAVIOR_MD_KEY = Metadata.Key.of((String)"rpc-behavior", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> ATTEMPT_NUM = Metadata.Key.of((String)"grpc-previous-rpc-attempts", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final String CALL_BEHAVIOR_KEEP_OPEN_VALUE = "keep-open";
    private static final String CALL_BEHAVIOR_SLEEP_VALUE = "sleep-";
    private static final String CALL_BEHAVIOR_SUCCEED_ON_RETRY_ATTEMPT_VALUE = "succeed-on-retry-attempt-";
    private static final String CALL_BEHAVIOR_ERROR_CODE = "error-code-";
    private static final String CALL_BEHAVIOR_HOSTNAME = "hostname=";
    private static final Splitter HEADER_VALUE_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final Splitter HEADER_HOSTNAME_SPLITTER = Splitter.on((char)' ');
    private static Logger logger = Logger.getLogger(XdsTestServer.class.getName());
    private int port = 8080;
    private int maintenancePort = 8080;
    private boolean secureMode = false;
    private boolean enableCsmObservability;
    private String serverId = "java_server";
    private HealthStatusManager health;
    private Server server;
    private Server maintenanceServer;
    private String host;
    private CsmObservability csmObservability;

    public static void main(String[] args) throws Exception {
        final XdsTestServer server = new XdsTestServer();
        server.parseArgs(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("Shutting down");
                    server.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        server.start();
        System.out.println("Server started on port " + server.port);
        server.blockUntilShutdown();
    }

    private void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("port".equals(key)) {
                this.port = Integer.valueOf(value);
                continue;
            }
            if ("maintenance_port".equals(key)) {
                this.maintenancePort = Integer.valueOf(value);
                continue;
            }
            if ("secure_mode".equals(key)) {
                this.secureMode = Boolean.parseBoolean(value);
                continue;
            }
            if ("enable_csm_observability".equals(key)) {
                this.enableCsmObservability = Boolean.valueOf(value);
                continue;
            }
            if ("server_id".equals(key)) {
                this.serverId = value;
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (this.secureMode && this.port == this.maintenancePort) {
            System.err.println("port and maintenance_port should be different for secure mode: port=" + this.port + ", maintenance_port=" + this.maintenancePort);
            usage = true;
        }
        if (usage) {
            XdsTestServer s = new XdsTestServer();
            System.err.println("Usage: [ARGS...]\n\n  --port=INT          listening port for test server.\n                      Default: " + s.port + "\n  --maintenance_port=INT      listening port for other servers.\n                      Default: " + s.maintenancePort + "\n  --secure_mode=BOOLEAN Use true to enable XdsCredentials. port and maintenance_port should be different for secure mode.\n                      Default: " + s.secureMode + "\n  --enable_csm_observability=BOOL  Enable CSM observability reporting. Default: " + s.enableCsmObservability + "\n  --server_id=STRING  server ID for response.\n                      Default: " + s.serverId);
            System.exit(1);
        }
    }

    private void start() throws Exception {
        if (this.enableCsmObservability) {
            this.csmObservability = CsmObservability.newBuilder().sdk((OpenTelemetry)AutoConfiguredOpenTelemetrySdk.builder().addPropertiesSupplier(() -> ImmutableMap.of((Object)"otel.logs.exporter", (Object)"none", (Object)"otel.metrics.exporter", (Object)"prometheus", (Object)"otel.traces.exporter", (Object)"none")).build().getOpenTelemetrySdk()).build();
            this.csmObservability.registerGlobal();
        }
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Failed to get host", e);
            throw new RuntimeException(e);
        }
        this.health = new HealthStatusManager();
        if (this.secureMode) {
            this.maintenanceServer = Grpc.newServerBuilderForPort((int)this.maintenancePort, (ServerCredentials)InsecureServerCredentials.create()).addService((BindableService)new XdsUpdateHealthServiceImpl(this.health)).addService(this.health.getHealthService()).addService(ProtoReflectionService.newInstance()).addServices(AdminInterface.getStandardServices()).build();
            this.maintenanceServer.start();
            this.server = ((XdsServerBuilder)XdsServerBuilder.forPort((int)this.port, (ServerCredentials)XdsServerCredentials.create((ServerCredentials)InsecureServerCredentials.create())).addService(ServerInterceptors.intercept((BindableService)new TestServiceImpl(this.serverId, this.host), (ServerInterceptor[])new ServerInterceptor[]{new TestInfoInterceptor(this.host)}))).build();
            this.server.start();
        } else {
            this.server = Grpc.newServerBuilderForPort((int)this.port, (ServerCredentials)InsecureServerCredentials.create()).addService(ServerInterceptors.intercept((BindableService)new TestServiceImpl(this.serverId, this.host), (ServerInterceptor[])new ServerInterceptor[]{new TestInfoInterceptor(this.host)})).addService((BindableService)new XdsUpdateHealthServiceImpl(this.health)).addService(this.health.getHealthService()).addService(ProtoReflectionService.newInstance()).addServices(AdminInterface.getStandardServices()).build();
            this.server.start();
            this.maintenanceServer = null;
        }
        this.health.setStatus("", HealthCheckResponse.ServingStatus.SERVING);
    }

    private void stop() throws Exception {
        this.server.shutdownNow();
        if (this.maintenanceServer != null) {
            this.maintenanceServer.shutdownNow();
        }
        if (!this.server.awaitTermination(5L, TimeUnit.SECONDS)) {
            System.err.println("Timed out waiting for server shutdown");
        }
        if (this.maintenanceServer != null && !this.maintenanceServer.awaitTermination(5L, TimeUnit.SECONDS)) {
            System.err.println("Timed out waiting for maintenanceServer shutdown");
        }
        if (this.csmObservability != null) {
            this.csmObservability.close();
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
        if (this.maintenanceServer != null) {
            this.maintenanceServer.awaitTermination();
        }
    }

    private static List<String> getCallBehaviors(Metadata requestHeaders) {
        ArrayList<String> callBehaviors = new ArrayList<String>();
        Iterable values = requestHeaders.getAll(CALL_BEHAVIOR_MD_KEY);
        if (values == null) {
            return callBehaviors;
        }
        for (String value : values) {
            Iterables.addAll(callBehaviors, (Iterable)HEADER_VALUE_SPLITTER.split((CharSequence)value));
        }
        return callBehaviors;
    }

    private static class TestInfoInterceptor
    implements ServerInterceptor {
        private final String host;

        private TestInfoInterceptor(String host) {
            this.host = host;
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
            List callBehaviors = XdsTestServer.getCallBehaviors(requestHeaders);
            ForwardingServerCall.SimpleForwardingServerCall newCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                public void sendHeaders(Metadata responseHeaders) {
                    responseHeaders.put(HOSTNAME_KEY, (Object)host);
                    super.sendHeaders(responseHeaders);
                }
            };
            ServerCall.Listener noopListener = new ServerCall.Listener<ReqT>(){};
            int attemptNum = 0;
            String attemptNumHeader = (String)requestHeaders.get(ATTEMPT_NUM);
            if (attemptNumHeader != null) {
                try {
                    attemptNum = Integer.valueOf(attemptNumHeader);
                }
                catch (NumberFormatException e) {
                    newCall.close(Status.INVALID_ARGUMENT.withDescription("Invalid format for grpc-previous-rpc-attempts header: " + attemptNumHeader), new Metadata());
                    return noopListener;
                }
            }
            for (String callBehavior : callBehaviors) {
                if (callBehavior.startsWith(XdsTestServer.CALL_BEHAVIOR_HOSTNAME)) {
                    List splitHeader = HEADER_HOSTNAME_SPLITTER.splitToList((CharSequence)callBehavior);
                    if (splitHeader.size() > 1) {
                        if (!((String)splitHeader.get(0)).substring(XdsTestServer.CALL_BEHAVIOR_HOSTNAME.length()).equals(this.host)) continue;
                        callBehavior = (String)splitHeader.get(1);
                    } else {
                        newCall.close(Status.INVALID_ARGUMENT.withDescription("Invalid format for rpc-behavior header: " + callBehavior), new Metadata());
                        return noopListener;
                    }
                }
                if (callBehavior.startsWith(XdsTestServer.CALL_BEHAVIOR_SLEEP_VALUE)) {
                    try {
                        int timeout = Integer.parseInt(callBehavior.substring(XdsTestServer.CALL_BEHAVIOR_SLEEP_VALUE.length()));
                        Thread.sleep((long)timeout * 1000L);
                    }
                    catch (NumberFormatException e) {
                        newCall.close(Status.INVALID_ARGUMENT.withDescription("Invalid format for rpc-behavior header: " + callBehavior), new Metadata());
                        return noopListener;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        newCall.close(Status.ABORTED.withDescription("execution of server interrupted"), new Metadata());
                        return noopListener;
                    }
                }
                if (callBehavior.startsWith(XdsTestServer.CALL_BEHAVIOR_SUCCEED_ON_RETRY_ATTEMPT_VALUE)) {
                    int succeedOnAttemptNum = Integer.MAX_VALUE;
                    try {
                        succeedOnAttemptNum = Integer.parseInt(callBehavior.substring(XdsTestServer.CALL_BEHAVIOR_SUCCEED_ON_RETRY_ATTEMPT_VALUE.length()));
                    }
                    catch (NumberFormatException e) {
                        newCall.close(Status.INVALID_ARGUMENT.withDescription("Invalid format for rpc-behavior header: " + callBehavior), new Metadata());
                        return noopListener;
                    }
                    if (attemptNum == succeedOnAttemptNum) {
                        return next.startCall((ServerCall)newCall, requestHeaders);
                    }
                }
                if (callBehavior.equals(XdsTestServer.CALL_BEHAVIOR_KEEP_OPEN_VALUE)) {
                    return noopListener;
                }
                if (!callBehavior.startsWith(XdsTestServer.CALL_BEHAVIOR_ERROR_CODE)) continue;
                try {
                    int codeValue = Integer.valueOf(callBehavior.substring(XdsTestServer.CALL_BEHAVIOR_ERROR_CODE.length()));
                    newCall.close(Status.fromCodeValue((int)codeValue).withDescription("Rpc failed as per the rpc-behavior header value:" + callBehaviors), new Metadata());
                    return noopListener;
                }
                catch (NumberFormatException e) {
                    newCall.close(Status.INVALID_ARGUMENT.withDescription("Invalid format for rpc-behavior header: " + callBehavior), new Metadata());
                    return noopListener;
                }
            }
            return next.startCall((ServerCall)newCall, requestHeaders);
        }
    }

    private static class XdsUpdateHealthServiceImpl
    extends XdsUpdateHealthServiceGrpc.XdsUpdateHealthServiceImplBase {
        private HealthStatusManager health;

        private XdsUpdateHealthServiceImpl(HealthStatusManager health) {
            this.health = health;
        }

        @Override
        public void setServing(EmptyProtos.Empty req, StreamObserver<EmptyProtos.Empty> responseObserver) {
            this.health.setStatus("", HealthCheckResponse.ServingStatus.SERVING);
            responseObserver.onNext((Object)EmptyProtos.Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }

        @Override
        public void setNotServing(EmptyProtos.Empty req, StreamObserver<EmptyProtos.Empty> responseObserver) {
            this.health.setStatus("", HealthCheckResponse.ServingStatus.NOT_SERVING);
            responseObserver.onNext((Object)EmptyProtos.Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }
    }

    private static class TestServiceImpl
    extends TestServiceGrpc.TestServiceImplBase {
        private final String serverId;
        private final String host;

        private TestServiceImpl(String serverId, String host) {
            this.serverId = serverId;
            this.host = host;
        }

        @Override
        public void emptyCall(EmptyProtos.Empty req, StreamObserver<EmptyProtos.Empty> responseObserver) {
            responseObserver.onNext((Object)EmptyProtos.Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }

        @Override
        public void unaryCall(Messages.SimpleRequest req, StreamObserver<Messages.SimpleResponse> responseObserver) {
            responseObserver.onNext((Object)Messages.SimpleResponse.newBuilder().setServerId(this.serverId).setHostname(this.host).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[req.getResponseSize()])).build()).build());
            responseObserver.onCompleted();
        }
    }
}

