/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.Http2TestCases;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Http2Client {
    private static final Logger logger = Logger.getLogger(Http2Client.class.getName());
    private String serverHost = "localhost";
    private int serverPort = 8080;
    private String testCase = Http2TestCases.RST_AFTER_DATA.name();
    private Tester tester = new Tester();
    private ListeningExecutorService threadpool;
    ManagedChannel channel;
    TestServiceGrpc.TestServiceBlockingStub blockingStub;
    TestServiceGrpc.TestServiceStub asyncStub;

    public static void main(String[] args) throws Exception {
        final Http2Client client = new Http2Client();
        client.parseArgs(args);
        client.setUp();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    client.shutdown();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        });
        try {
            client.run();
        }
        finally {
            client.shutdown();
        }
    }

    private void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("server_host".equals(key)) {
                this.serverHost = value;
                continue;
            }
            if ("server_port".equals(key)) {
                this.serverPort = Integer.parseInt(value);
                continue;
            }
            if ("test_case".equals(key)) {
                this.testCase = value;
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (usage) {
            Http2Client c = new Http2Client();
            System.out.println("Usage: [ARGS...]\n\n  --server_host=HOST          Server to connect to. Default " + c.serverHost + "\n  --server_port=PORT          Port to connect to. Default " + c.serverPort + "\n  --test_case=TESTCASE        Test case to run. Default " + c.testCase + "\n    Valid options:" + Http2Client.validTestCasesHelpText());
            System.exit(1);
        }
    }

    private void setUp() {
        this.channel = this.createChannel();
        this.blockingStub = TestServiceGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = TestServiceGrpc.newStub((Channel)this.channel);
    }

    private void shutdown() {
        try {
            if (this.channel != null) {
                this.channel.shutdownNow();
                this.channel.awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            if (this.threadpool != null) {
                this.threadpool.shutdownNow();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void run() {
        logger.info("Running test " + this.testCase);
        try {
            this.runTest(Http2TestCases.fromString(this.testCase));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        logger.info("Test completed.");
    }

    private void runTest(Http2TestCases testCase) throws Exception {
        switch (testCase) {
            case RST_AFTER_HEADER: {
                this.tester.rstAfterHeader();
                break;
            }
            case RST_AFTER_DATA: {
                this.tester.rstAfterData();
                break;
            }
            case RST_DURING_DATA: {
                this.tester.rstDuringData();
                break;
            }
            case GOAWAY: {
                this.tester.goAway();
                break;
            }
            case PING: {
                this.tester.ping();
                break;
            }
            case MAX_STREAMS: {
                this.tester.maxStreams();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown test case: " + (Object)((Object)testCase));
            }
        }
    }

    private ManagedChannel createChannel() {
        ChannelCredentials creds = InsecureChannelCredentials.create();
        return NettyChannelBuilder.forAddress((String)this.serverHost, (int)this.serverPort, (ChannelCredentials)creds).build();
    }

    private static String validTestCasesHelpText() {
        StringBuilder builder = new StringBuilder();
        for (Http2TestCases testCase : Http2TestCases.values()) {
            String strTestcase = testCase.name().toLowerCase(Locale.ROOT);
            builder.append("\n      ").append(strTestcase).append(": ").append(testCase.description());
        }
        return builder.toString();
    }

    private class Tester {
        private final int timeoutSeconds = 180;
        private final int responseSize = 314159;
        private final int payloadSize = 271828;
        private final Messages.SimpleRequest simpleRequest = Messages.SimpleRequest.newBuilder().setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        final Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();

        private Tester() {
        }

        private void rstAfterHeader() throws Exception {
            try {
                Http2Client.this.blockingStub.unaryCall(this.simpleRequest);
                throw new AssertionError((Object)"Expected call to fail");
            }
            catch (StatusRuntimeException ex) {
                this.assertRstStreamReceived(ex.getStatus());
                return;
            }
        }

        private void rstAfterData() throws Exception {
            RstStreamObserver responseObserver = new RstStreamObserver();
            Http2Client.this.asyncStub.unaryCall(this.simpleRequest, responseObserver);
            if (!responseObserver.awaitCompletion(180L, TimeUnit.SECONDS)) {
                throw new AssertionError((Object)"Operation timed out");
            }
            if (responseObserver.getError() == null) {
                throw new AssertionError((Object)"Expected call to fail");
            }
            this.assertRstStreamReceived(Status.fromThrowable((Throwable)responseObserver.getError()));
            if (responseObserver.getResponses().size() != 1) {
                throw new AssertionError((Object)"Expected one response");
            }
        }

        private void rstDuringData() throws Exception {
            RstStreamObserver responseObserver = new RstStreamObserver();
            Http2Client.this.asyncStub.unaryCall(this.simpleRequest, responseObserver);
            if (!responseObserver.awaitCompletion(180L, TimeUnit.SECONDS)) {
                throw new AssertionError((Object)"Operation timed out");
            }
            if (responseObserver.getError() == null) {
                throw new AssertionError((Object)"Expected call to fail");
            }
            this.assertRstStreamReceived(Status.fromThrowable((Throwable)responseObserver.getError()));
            if (responseObserver.getResponses().size() != 0) {
                throw new AssertionError((Object)"Expected zero responses");
            }
        }

        private void goAway() throws Exception {
            this.assertResponseEquals(Http2Client.this.blockingStub.unaryCall(this.simpleRequest), this.goldenResponse);
            TimeUnit.SECONDS.sleep(1L);
            this.assertResponseEquals(Http2Client.this.blockingStub.unaryCall(this.simpleRequest), this.goldenResponse);
        }

        private void ping() throws Exception {
            this.assertResponseEquals(Http2Client.this.blockingStub.unaryCall(this.simpleRequest), this.goldenResponse);
        }

        private void maxStreams() throws Exception {
            int numThreads = 10;
            this.assertResponseEquals(Http2Client.this.blockingStub.unaryCall(this.simpleRequest), this.goldenResponse);
            Http2Client.this.threadpool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10));
            ArrayList<ListenableFuture> workerFutures = new ArrayList<ListenableFuture>();
            for (int i = 0; i < 10; ++i) {
                workerFutures.add(Http2Client.this.threadpool.submit((Runnable)new MaxStreamsWorker(i)));
            }
            ListenableFuture f = Futures.allAsList(workerFutures);
            f.get(180L, TimeUnit.SECONDS);
        }

        private void assertRstStreamReceived(Status status) {
            if (!status.getCode().equals((Object)Status.Code.UNAVAILABLE)) {
                throw new AssertionError((Object)("Wrong status code. Expected: " + Status.Code.UNAVAILABLE + " Received: " + status.getCode()));
            }
            String http2ErrorPrefix = "HTTP/2 error code: NO_ERROR";
            if (status.getDescription() == null || !status.getDescription().startsWith(http2ErrorPrefix)) {
                throw new AssertionError((Object)("Wrong HTTP/2 error code. Expected: " + http2ErrorPrefix + " Received: " + status.getDescription()));
            }
        }

        private void assertResponseEquals(Messages.SimpleResponse response, Messages.SimpleResponse goldenResponse) {
            if (!response.equals(goldenResponse)) {
                throw new AssertionError((Object)"Incorrect response received");
            }
        }

        private class MaxStreamsWorker
        implements Runnable {
            int threadNum;

            MaxStreamsWorker(int threadNum) {
                this.threadNum = threadNum;
            }

            @Override
            public void run() {
                Thread.currentThread().setName("thread:" + this.threadNum);
                try {
                    TestServiceGrpc.TestServiceBlockingStub blockingStub = TestServiceGrpc.newBlockingStub((Channel)Http2Client.this.channel);
                    Tester.this.assertResponseEquals(blockingStub.unaryCall(Tester.this.simpleRequest), Tester.this.goldenResponse);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private class RstStreamObserver
        implements StreamObserver<Messages.SimpleResponse> {
            private final CountDownLatch latch = new CountDownLatch(1);
            private final List<Messages.SimpleResponse> responses = new ArrayList<Messages.SimpleResponse>();
            private Throwable error;

            private RstStreamObserver() {
            }

            public void onNext(Messages.SimpleResponse value) {
                this.responses.add(value);
            }

            public void onError(Throwable t) {
                this.error = t;
                this.latch.countDown();
            }

            public void onCompleted() {
                this.latch.countDown();
            }

            public List<Messages.SimpleResponse> getResponses() {
                return this.responses;
            }

            public Throwable getError() {
                return this.error;
            }

            public boolean awaitCompletion(long timeout, TimeUnit unit) throws Exception {
                return this.latch.await(timeout, unit);
            }
        }
    }
}

