/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.BindableService;
import io.grpc.Grpc;
import io.grpc.InsecureServerCredentials;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.alts.AltsServerCredentials;
import io.grpc.internal.testing.TestUtils;
import io.grpc.services.MetricRecorder;
import io.grpc.testing.integration.TestServiceImpl;
import io.grpc.xds.orca.OrcaMetricReportingServerInterceptor;
import io.grpc.xds.orca.OrcaServiceImpl;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TestServiceServer {
    private int port = 8080;
    private boolean useTls = true;
    private boolean useAlts = false;
    private ScheduledExecutorService executor;
    private Server server;
    private int localHandshakerPort = -1;

    public static void main(String[] args) throws Exception {
        TestUtils.installConscryptIfAvailable();
        final TestServiceServer server = new TestServiceServer();
        server.parseArgs(args);
        if (server.useTls) {
            System.out.println("\nUsing fake CA for TLS certificate. Test clients should expect host\n*.test.google.fr and our test CA. For the Java test client binary, use:\n--server_host_override=foo.test.google.fr --use_test_ca=true\n");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("Shutting down");
                    server.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        server.start();
        System.out.println("Server started on port " + server.port);
        server.blockUntilShutdown();
    }

    @VisibleForTesting
    void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("port".equals(key)) {
                this.port = Integer.parseInt(value);
                continue;
            }
            if ("use_tls".equals(key)) {
                this.useTls = Boolean.parseBoolean(value);
                continue;
            }
            if ("use_alts".equals(key)) {
                this.useAlts = Boolean.parseBoolean(value);
                continue;
            }
            if ("local_handshaker_port".equals(key)) {
                this.localHandshakerPort = Integer.parseInt(value);
                continue;
            }
            if ("grpc_version".equals(key)) {
                if ("2".equals(value)) continue;
                System.err.println("Only grpc version 2 is supported");
                usage = true;
                break;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (this.useAlts) {
            this.useTls = false;
        }
        if (usage) {
            TestServiceServer s = new TestServiceServer();
            System.out.println("Usage: [ARGS...]\n\n  --port=PORT           Port to connect to. Default " + s.port + "\n  --use_tls=true|false  Whether to use TLS. Default " + s.useTls + "\n  --use_alts=true|false Whether to use ALTS. Enable ALTS will disable TLS.\n                        Default " + s.useAlts + "\n  --local_handshaker_port=PORT\n                        Use local ALTS handshaker service on the specified port \n                        for testing. Only effective when --use_alts=true.");
            System.exit(1);
        }
    }

    @VisibleForTesting
    void start() throws Exception {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        ServerCredentials serverCreds = this.useAlts ? (this.localHandshakerPort > -1 ? AltsServerCredentials.newBuilder().enableUntrustedAltsForTesting().setHandshakerAddressForTesting("localhost:" + this.localHandshakerPort).build() : AltsServerCredentials.create()) : (this.useTls ? TlsServerCredentials.create((File)TestUtils.loadCert((String)"server1.pem"), (File)TestUtils.loadCert((String)"server1.key")) : InsecureServerCredentials.create());
        MetricRecorder metricRecorder = MetricRecorder.newInstance();
        BindableService orcaOobService = OrcaServiceImpl.createService((ScheduledExecutorService)this.executor, (MetricRecorder)metricRecorder, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.server = Grpc.newServerBuilderForPort((int)this.port, (ServerCredentials)serverCreds).maxInboundMessageSize(0x1000000).addService(ServerInterceptors.intercept((BindableService)new TestServiceImpl(this.executor, metricRecorder), TestServiceImpl.interceptors())).addService(orcaOobService).intercept((ServerInterceptor)OrcaMetricReportingServerInterceptor.getInstance()).build().start();
    }

    @VisibleForTesting
    void stop() throws Exception {
        this.server.shutdownNow();
        if (!this.server.awaitTermination(5L, TimeUnit.SECONDS)) {
            System.err.println("Timed out waiting for server shutdown");
        }
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    @VisibleForTesting
    int getPort() {
        return this.server.getPort();
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }
}

