/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import io.grpc.BindableService;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.grpc.services.HealthStatusManager;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.EmptyProtos;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import io.grpc.testing.integration.XdsUpdateHealthServiceGrpc;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class XdsTestServer {
    static final Metadata.Key<String> HOSTNAME_KEY = Metadata.Key.of((String)"hostname", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static Logger logger = Logger.getLogger(XdsTestServer.class.getName());
    private int port = 8080;
    private String serverId = "java_server";
    private HealthStatusManager health;
    private Server server;
    private String host;

    public static void main(String[] args) throws Exception {
        XdsTestServer server = new XdsTestServer();
        server.parseArgs(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("Shutting down");
                    XdsTestServer.this.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        server.start();
        System.out.println("Server started on port " + server.port);
        server.blockUntilShutdown();
    }

    private void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("port".equals(key)) {
                this.port = Integer.valueOf(value);
                continue;
            }
            if ("server_id".equals(key)) {
                this.serverId = value;
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (usage) {
            XdsTestServer s = new XdsTestServer();
            System.err.println("Usage: [ARGS...]\n\n  --port=INT          listening port for server.\n                      Default: " + s.port + "\n  --server_id=STRING  server ID for response.\n                      Default: " + s.serverId);
            System.exit(1);
        }
    }

    private void start() throws Exception {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Failed to get host", e);
            throw new RuntimeException(e);
        }
        this.health = new HealthStatusManager();
        this.server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).addService(ServerInterceptors.intercept((BindableService)new TestServiceImpl(this.serverId, this.host), (ServerInterceptor[])new ServerInterceptor[]{new HostnameInterceptor(this.host)}))).addService((BindableService)new XdsUpdateHealthServiceImpl(this.health))).addService(this.health.getHealthService())).addService(ProtoReflectionService.newInstance())).build().start();
        this.health.setStatus("", HealthCheckResponse.ServingStatus.SERVING);
    }

    private void stop() throws Exception {
        this.server.shutdownNow();
        if (!this.server.awaitTermination(5L, TimeUnit.SECONDS)) {
            System.err.println("Timed out waiting for server shutdown");
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    private static class HostnameInterceptor
    implements ServerInterceptor {
        private final String host;

        private HostnameInterceptor(String host) {
            this.host = host;
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
            return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                public void sendHeaders(Metadata responseHeaders) {
                    responseHeaders.put(HOSTNAME_KEY, (Object)HostnameInterceptor.this.host);
                    super.sendHeaders(responseHeaders);
                }
            }, requestHeaders);
        }
    }

    private static class XdsUpdateHealthServiceImpl
    extends XdsUpdateHealthServiceGrpc.XdsUpdateHealthServiceImplBase {
        private HealthStatusManager health;

        private XdsUpdateHealthServiceImpl(HealthStatusManager health) {
            this.health = health;
        }

        @Override
        public void setServing(EmptyProtos.Empty req, StreamObserver<EmptyProtos.Empty> responseObserver) {
            this.health.setStatus("", HealthCheckResponse.ServingStatus.SERVING);
            responseObserver.onNext((Object)EmptyProtos.Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }

        @Override
        public void setNotServing(EmptyProtos.Empty req, StreamObserver<EmptyProtos.Empty> responseObserver) {
            this.health.setStatus("", HealthCheckResponse.ServingStatus.NOT_SERVING);
            responseObserver.onNext((Object)EmptyProtos.Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }
    }

    private static class TestServiceImpl
    extends TestServiceGrpc.TestServiceImplBase {
        private final String serverId;
        private final String host;

        private TestServiceImpl(String serverId, String host) {
            this.serverId = serverId;
            this.host = host;
        }

        @Override
        public void emptyCall(EmptyProtos.Empty req, StreamObserver<EmptyProtos.Empty> responseObserver) {
            responseObserver.onNext((Object)EmptyProtos.Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }

        @Override
        public void unaryCall(Messages.SimpleRequest req, StreamObserver<Messages.SimpleResponse> responseObserver) {
            responseObserver.onNext((Object)Messages.SimpleResponse.newBuilder().setServerId(this.serverId).setHostname(this.host).build());
            responseObserver.onCompleted();
        }
    }
}

