/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ClientStreamTracer;
import io.grpc.Context;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.internal.CensusStatsModule;
import io.grpc.internal.DeprecatedCensusConstants;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.TestingAccessor;
import io.grpc.internal.testing.StatsTestUtils;
import io.grpc.internal.testing.StreamRecorder;
import io.grpc.internal.testing.TestClientStreamTracer;
import io.grpc.internal.testing.TestServerStreamTracer;
import io.grpc.internal.testing.TestStreamTracer;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.TestUtils;
import io.grpc.testing.integration.EmptyProtos;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import io.grpc.testing.integration.TestServiceImpl;
import io.grpc.testing.integration.UnimplementedServiceGrpc;
import io.grpc.testing.integration.Util;
import io.opencensus.stats.Measure;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.propagation.TagContextBinarySerializer;
import io.opencensus.tags.unsafe.ContextUtils;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Tracing;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public abstract class AbstractInteropTest {
    private static Logger logger = Logger.getLogger(AbstractInteropTest.class.getName());
    @Rule
    public final Timeout globalTimeout = Timeout.seconds((long)30L);
    public static final int MAX_MESSAGE_SIZE = 0x1000000;
    private static final StatsTestUtils.FakeTagger tagger = new StatsTestUtils.FakeTagger();
    private static final StatsTestUtils.FakeTagContextBinarySerializer tagContextBinarySerializer = new StatsTestUtils.FakeTagContextBinarySerializer();
    private final AtomicReference<ServerCall<?, ?>> serverCallCapture = new AtomicReference();
    private final AtomicReference<Metadata> requestHeadersCapture = new AtomicReference();
    private final AtomicReference<Context> contextCapture = new AtomicReference();
    private final StatsTestUtils.FakeStatsRecorder clientStatsRecorder = new StatsTestUtils.FakeStatsRecorder();
    private final StatsTestUtils.FakeStatsRecorder serverStatsRecorder = new StatsTestUtils.FakeStatsRecorder();
    private ScheduledExecutorService testServiceExecutor;
    private Server server;
    private final LinkedBlockingQueue<ServerStreamTracerInfo> serverStreamTracers = new LinkedBlockingQueue();
    private final ServerStreamTracer.Factory serverStreamTracerFactory = new ServerStreamTracer.Factory(){

        public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
            ServerStreamTracerInfo.InteropServerStreamTracer tracer = new ServerStreamTracerInfo.InteropServerStreamTracer();
            AbstractInteropTest.this.serverStreamTracers.add(new ServerStreamTracerInfo(fullMethodName, tracer));
            return tracer;
        }
    };
    protected static final EmptyProtos.Empty EMPTY = EmptyProtos.Empty.getDefaultInstance();
    protected ManagedChannel channel;
    protected TestServiceGrpc.TestServiceBlockingStub blockingStub;
    protected TestServiceGrpc.TestServiceStub asyncStub;
    private final LinkedBlockingQueue<TestClientStreamTracer> clientStreamTracers = new LinkedBlockingQueue();
    private final ClientStreamTracer.Factory clientStreamTracerFactory = new ClientStreamTracer.Factory(){

        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            TestClientStreamTracer tracer = new TestClientStreamTracer();
            AbstractInteropTest.this.clientStreamTracers.add(tracer);
            return tracer;
        }
    };
    private final ClientInterceptor tracerSetupInterceptor = new ClientInterceptor(){

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return next.newCall(method, callOptions.withStreamTracerFactory(AbstractInteropTest.this.clientStreamTracerFactory));
        }
    };

    private void startServer() {
        AbstractServerImplBuilder<?> builder = this.getServerBuilder();
        if (builder == null) {
            this.server = null;
            return;
        }
        this.testServiceExecutor = Executors.newScheduledThreadPool(2);
        ImmutableList allInterceptors = ImmutableList.builder().add((Object)AbstractInteropTest.recordServerCallInterceptor(this.serverCallCapture)).add((Object)TestUtils.recordRequestHeadersInterceptor(this.requestHeadersCapture)).add((Object)AbstractInteropTest.recordContextInterceptor(this.contextCapture)).addAll(TestServiceImpl.interceptors()).build();
        builder.addService(ServerInterceptors.intercept((BindableService)new TestServiceImpl(this.testServiceExecutor), (List)allInterceptors)).addStreamTracerFactory(this.serverStreamTracerFactory);
        TestingAccessor.setStatsImplementation(builder, (CensusStatsModule)new CensusStatsModule((Tagger)tagger, (TagContextBinarySerializer)tagContextBinarySerializer, (StatsRecorder)this.serverStatsRecorder, GrpcUtil.STOPWATCH_SUPPLIER, true, true, true, false));
        try {
            this.server = builder.build().start();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void stopServer() {
        if (this.server != null) {
            this.server.shutdownNow();
        }
        if (this.testServiceExecutor != null) {
            this.testServiceExecutor.shutdown();
        }
    }

    @VisibleForTesting
    final SocketAddress getListenAddress() {
        return (SocketAddress)this.server.getListenSockets().iterator().next();
    }

    @Before
    public void setUp() {
        this.startServer();
        this.channel = this.createChannel();
        this.blockingStub = (TestServiceGrpc.TestServiceBlockingStub)TestServiceGrpc.newBlockingStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{this.tracerSetupInterceptor});
        this.asyncStub = (TestServiceGrpc.TestServiceStub)TestServiceGrpc.newStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{this.tracerSetupInterceptor});
        ClientInterceptor[] additionalInterceptors = this.getAdditionalInterceptors();
        if (additionalInterceptors != null) {
            this.blockingStub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withInterceptors(additionalInterceptors);
            this.asyncStub = (TestServiceGrpc.TestServiceStub)this.asyncStub.withInterceptors(additionalInterceptors);
        }
        this.requestHeadersCapture.set(null);
    }

    @After
    public void tearDown() {
        if (this.channel != null) {
            this.channel.shutdownNow();
            try {
                this.channel.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                logger.log(Level.FINE, "Interrupted while waiting for channel termination", ie);
                Thread.currentThread().interrupt();
            }
        }
        this.stopServer();
    }

    protected abstract ManagedChannel createChannel();

    @Nullable
    protected ClientInterceptor[] getAdditionalInterceptors() {
        return null;
    }

    @Nullable
    protected AbstractServerImplBuilder<?> getServerBuilder() {
        return null;
    }

    protected final CensusStatsModule createClientCensusStatsModule() {
        return new CensusStatsModule((Tagger)tagger, (TagContextBinarySerializer)tagContextBinarySerializer, (StatsRecorder)this.clientStatsRecorder, GrpcUtil.STOPWATCH_SUPPLIER, true, true, true, false);
    }

    protected boolean metricsExpected() {
        return true;
    }

    @Test
    public void emptyUnary() throws Exception {
        Assert.assertEquals((Object)EMPTY, (Object)this.blockingStub.emptyCall(EMPTY));
    }

    public void cacheableUnary() {
        MethodDescriptor safeCacheableUnaryCallMethod = TestServiceGrpc.getCacheableUnaryCallMethod().toBuilder().setSafe(true).build();
        Metadata.Key userIpKey = Metadata.Key.of((String)"x-user-ip", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        Metadata metadata = new Metadata();
        metadata.put(userIpKey, (Object)"1.2.3.4");
        Channel channelWithUserIpKey = ClientInterceptors.intercept((Channel)this.channel, (ClientInterceptor[])new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
        Messages.SimpleRequest requests1And2 = Messages.SimpleRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFromUtf8((String)String.valueOf(System.nanoTime())))).build();
        Messages.SimpleRequest request3 = Messages.SimpleRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFromUtf8((String)String.valueOf(System.nanoTime())))).build();
        Messages.SimpleResponse response1 = (Messages.SimpleResponse)ClientCalls.blockingUnaryCall((Channel)channelWithUserIpKey, (MethodDescriptor)safeCacheableUnaryCallMethod, (CallOptions)CallOptions.DEFAULT, (Object)requests1And2);
        Messages.SimpleResponse response2 = (Messages.SimpleResponse)ClientCalls.blockingUnaryCall((Channel)channelWithUserIpKey, (MethodDescriptor)safeCacheableUnaryCallMethod, (CallOptions)CallOptions.DEFAULT, (Object)requests1And2);
        Messages.SimpleResponse response3 = (Messages.SimpleResponse)ClientCalls.blockingUnaryCall((Channel)channelWithUserIpKey, (MethodDescriptor)safeCacheableUnaryCallMethod, (CallOptions)CallOptions.DEFAULT, (Object)request3);
        Assert.assertEquals((Object)response1, (Object)response2);
        Assert.assertNotEquals((Object)response1, (Object)response3);
    }

    @Test
    public void largeUnary() throws Exception {
        AbstractInteropTest.assumeEnoughMemory();
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        this.assertResponse(goldenResponse, this.blockingStub.unaryCall(request));
        this.assertStatsTrace("grpc.testing.TestService/UnaryCall", Status.Code.OK, Collections.singleton(request), Collections.singleton(goldenResponse));
    }

    public void clientCompressedUnary(boolean probe) throws Exception {
        AbstractInteropTest.assumeEnoughMemory();
        Messages.SimpleRequest expectCompressedRequest = Messages.SimpleRequest.newBuilder().setExpectCompressed(Messages.BoolValue.newBuilder().setValue(true)).setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleRequest expectUncompressedRequest = Messages.SimpleRequest.newBuilder().setExpectCompressed(Messages.BoolValue.newBuilder().setValue(false)).setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        if (probe) {
            try {
                this.blockingStub.unaryCall(expectCompressedRequest);
                Assert.fail((String)"expected INVALID_ARGUMENT");
            }
            catch (StatusRuntimeException e) {
                Assert.assertEquals((Object)Status.INVALID_ARGUMENT.getCode(), (Object)e.getStatus().getCode());
            }
            this.assertStatsTrace("grpc.testing.TestService/UnaryCall", Status.Code.INVALID_ARGUMENT);
        }
        this.assertResponse(goldenResponse, ((TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withCompression("gzip")).unaryCall(expectCompressedRequest));
        this.assertStatsTrace("grpc.testing.TestService/UnaryCall", Status.Code.OK, Collections.singleton(expectCompressedRequest), Collections.singleton(goldenResponse));
        this.assertResponse(goldenResponse, this.blockingStub.unaryCall(expectUncompressedRequest));
        this.assertStatsTrace("grpc.testing.TestService/UnaryCall", Status.Code.OK, Collections.singleton(expectUncompressedRequest), Collections.singleton(goldenResponse));
    }

    @Test
    public void serverCompressedUnary() throws Exception {
        AbstractInteropTest.assumeEnoughMemory();
        Messages.SimpleRequest responseShouldBeCompressed = Messages.SimpleRequest.newBuilder().setResponseCompressed(Messages.BoolValue.newBuilder().setValue(true)).setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleRequest responseShouldBeUncompressed = Messages.SimpleRequest.newBuilder().setResponseCompressed(Messages.BoolValue.newBuilder().setValue(false)).setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        this.assertResponse(goldenResponse, this.blockingStub.unaryCall(responseShouldBeCompressed));
        this.assertStatsTrace("grpc.testing.TestService/UnaryCall", Status.Code.OK, Collections.singleton(responseShouldBeCompressed), Collections.singleton(goldenResponse));
        this.assertResponse(goldenResponse, this.blockingStub.unaryCall(responseShouldBeUncompressed));
        this.assertStatsTrace("grpc.testing.TestService/UnaryCall", Status.Code.OK, Collections.singleton(responseShouldBeUncompressed), Collections.singleton(goldenResponse));
    }

    public void pickFirstUnary() throws Exception {
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setResponseSize(1).setFillServerId(true).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[1]))).build();
        Messages.SimpleResponse firstResponse = this.blockingStub.unaryCall(request);
        Thread.sleep(5000L);
        for (int i = 0; i < 100; ++i) {
            Messages.SimpleResponse response = this.blockingStub.unaryCall(request);
            Truth.assertThat((String)response.getServerId()).isEqualTo((Object)firstResponse.getServerId());
        }
    }

    @Test
    public void serverStreaming() throws Exception {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(31415)).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(9)).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(2653)).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(58979)).build();
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[31415]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[9]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[2653]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[58979]))).build());
        StreamRecorder recorder = StreamRecorder.create();
        this.asyncStub.streamingOutputCall(request, (StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        recorder.awaitCompletion();
        AbstractInteropTest.assertSuccess(recorder);
        this.assertResponses(goldenResponses, recorder.getValues());
    }

    @Test
    public void clientStreaming() throws Exception {
        List<Messages.StreamingInputCallRequest> requests = Arrays.asList(Messages.StreamingInputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[27182]))).build(), Messages.StreamingInputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[8]))).build(), Messages.StreamingInputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[1828]))).build(), Messages.StreamingInputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[45904]))).build());
        Messages.StreamingInputCallResponse goldenResponse = Messages.StreamingInputCallResponse.newBuilder().setAggregatedPayloadSize(74922).build();
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingInputCallRequest> requestObserver = this.asyncStub.streamingInputCall((StreamObserver<Messages.StreamingInputCallResponse>)responseObserver);
        for (Messages.StreamingInputCallRequest request : requests) {
            requestObserver.onNext((Object)request);
        }
        requestObserver.onCompleted();
        Assert.assertEquals((Object)goldenResponse, (Object)responseObserver.firstValue().get());
        responseObserver.awaitCompletion();
        Truth.assertThat((Iterable)responseObserver.getValues()).hasSize(1);
        Throwable t = responseObserver.getError();
        if (t != null) {
            throw new AssertionError((Object)t);
        }
    }

    public void clientCompressedStreaming(boolean probe) throws Exception {
        Messages.StreamingInputCallRequest expectCompressedRequest = Messages.StreamingInputCallRequest.newBuilder().setExpectCompressed(Messages.BoolValue.newBuilder().setValue(true)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[27182]))).build();
        Messages.StreamingInputCallRequest expectUncompressedRequest = Messages.StreamingInputCallRequest.newBuilder().setExpectCompressed(Messages.BoolValue.newBuilder().setValue(false)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[45904]))).build();
        Messages.StreamingInputCallResponse goldenResponse = Messages.StreamingInputCallResponse.newBuilder().setAggregatedPayloadSize(73086).build();
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingInputCallRequest> requestObserver = this.asyncStub.streamingInputCall((StreamObserver<Messages.StreamingInputCallResponse>)responseObserver);
        if (probe) {
            requestObserver.onNext((Object)expectCompressedRequest);
            responseObserver.awaitCompletion(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS);
            Throwable e = responseObserver.getError();
            Assert.assertNotNull((String)"expected INVALID_ARGUMENT", (Object)e);
            Assert.assertEquals((Object)Status.INVALID_ARGUMENT.getCode(), (Object)Status.fromThrowable((Throwable)e).getCode());
        }
        responseObserver = StreamRecorder.create();
        ClientCallStreamObserver clientCallStreamObserver = (ClientCallStreamObserver)((TestServiceGrpc.TestServiceStub)this.asyncStub.withCompression("gzip")).streamingInputCall((StreamObserver<Messages.StreamingInputCallResponse>)responseObserver);
        clientCallStreamObserver.setMessageCompression(true);
        clientCallStreamObserver.onNext((Object)expectCompressedRequest);
        clientCallStreamObserver.setMessageCompression(false);
        clientCallStreamObserver.onNext((Object)expectUncompressedRequest);
        clientCallStreamObserver.onCompleted();
        responseObserver.awaitCompletion();
        AbstractInteropTest.assertSuccess(responseObserver);
        Assert.assertEquals((Object)goldenResponse, (Object)responseObserver.firstValue().get());
    }

    public void serverCompressedStreaming() throws Exception {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setCompressed(Messages.BoolValue.newBuilder().setValue(true)).setSize(31415)).addResponseParameters(Messages.ResponseParameters.newBuilder().setCompressed(Messages.BoolValue.newBuilder().setValue(false)).setSize(92653)).build();
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[31415]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[92653]))).build());
        StreamRecorder recorder = StreamRecorder.create();
        this.asyncStub.streamingOutputCall(request, (StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        recorder.awaitCompletion();
        AbstractInteropTest.assertSuccess(recorder);
        this.assertResponses(goldenResponses, recorder.getValues());
    }

    @Test
    public void pingPong() throws Exception {
        List<Messages.StreamingOutputCallRequest> requests = Arrays.asList(Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(31415)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[27182]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(9)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[8]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(2653)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[1828]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(58979)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[45904]))).build());
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[31415]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[9]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[2653]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[58979]))).build());
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(5);
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall(new StreamObserver<Messages.StreamingOutputCallResponse>(){

            public void onNext(Messages.StreamingOutputCallResponse response) {
                queue.add(response);
            }

            public void onError(Throwable t) {
                queue.add(t);
            }

            public void onCompleted() {
                queue.add("Completed");
            }
        });
        for (int i = 0; i < requests.size(); ++i) {
            Assert.assertNull(queue.peek());
            requestObserver.onNext((Object)requests.get(i));
            Object actualResponse = queue.poll(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS);
            Assert.assertNotNull((String)"Timed out waiting for response", actualResponse);
            if (actualResponse instanceof Throwable) {
                throw new AssertionError(actualResponse);
            }
            this.assertResponse(goldenResponses.get(i), (Messages.StreamingOutputCallResponse)actualResponse);
        }
        requestObserver.onCompleted();
        Assert.assertEquals((Object)"Completed", queue.poll(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS));
    }

    @Test
    public void emptyStream() throws Exception {
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver);
        requestObserver.onCompleted();
        responseObserver.awaitCompletion(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Test
    public void cancelAfterBegin() throws Exception {
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingInputCallRequest> requestObserver = this.asyncStub.streamingInputCall((StreamObserver<Messages.StreamingInputCallResponse>)responseObserver);
        requestObserver.onError((Throwable)new RuntimeException());
        responseObserver.awaitCompletion();
        Assert.assertEquals(Arrays.asList(new Messages.StreamingInputCallResponse[0]), (Object)responseObserver.getValues());
        Assert.assertEquals((Object)Status.Code.CANCELLED, (Object)Status.fromThrowable((Throwable)responseObserver.getError()).getCode());
        if (this.metricsExpected()) {
            StatsTestUtils.MetricsRecord clientStartRecord = this.clientStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkStartTags(clientStartRecord, "grpc.testing.TestService/StreamingInputCall");
            StatsTestUtils.MetricsRecord clientEndRecord = this.clientStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkEndTags(clientEndRecord, "grpc.testing.TestService/StreamingInputCall", Status.CANCELLED.getCode());
        }
    }

    @Test
    public void cancelAfterFirstResponse() throws Exception {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(31415)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[27182]))).build();
        Messages.StreamingOutputCallResponse goldenResponse = Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[31415]))).build();
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver);
        requestObserver.onNext((Object)request);
        this.assertResponse(goldenResponse, (Messages.StreamingOutputCallResponse)responseObserver.firstValue().get());
        requestObserver.onError((Throwable)new RuntimeException());
        responseObserver.awaitCompletion(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)responseObserver.getValues().size());
        Assert.assertEquals((Object)Status.Code.CANCELLED, (Object)Status.fromThrowable((Throwable)responseObserver.getError()).getCode());
        this.assertStatsTrace("grpc.testing.TestService/FullDuplexCall", Status.Code.CANCELLED);
    }

    @Test
    public void fullDuplexCallShouldSucceed() throws Exception {
        int ix;
        List<Integer> responseSizes = Arrays.asList(50, 100, 150, 200);
        Messages.StreamingOutputCallRequest.Builder streamingOutputBuilder = Messages.StreamingOutputCallRequest.newBuilder();
        for (Integer size : responseSizes) {
            streamingOutputBuilder.addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(size).setIntervalUs(0));
        }
        Messages.StreamingOutputCallRequest request = streamingOutputBuilder.build();
        StreamRecorder recorder = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestStream = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        int numRequests = 10;
        ArrayList<Messages.StreamingOutputCallRequest> requests = new ArrayList<Messages.StreamingOutputCallRequest>(10);
        for (ix = 10; ix > 0; --ix) {
            requests.add(request);
            requestStream.onNext((Object)request);
        }
        requestStream.onCompleted();
        recorder.awaitCompletion();
        AbstractInteropTest.assertSuccess(recorder);
        Assert.assertEquals((long)(responseSizes.size() * 10), (long)recorder.getValues().size());
        for (ix = 0; ix < recorder.getValues().size(); ++ix) {
            Messages.StreamingOutputCallResponse response = (Messages.StreamingOutputCallResponse)recorder.getValues().get(ix);
            int length = response.getPayload().getBody().size();
            int expectedSize = responseSizes.get(ix % responseSizes.size());
            Assert.assertEquals((String)("comparison failed at index " + ix), (long)expectedSize, (long)length);
        }
        this.assertStatsTrace("grpc.testing.TestService/FullDuplexCall", Status.Code.OK, requests, recorder.getValues());
    }

    @Test
    public void halfDuplexCallShouldSucceed() throws Exception {
        int ix;
        List<Integer> responseSizes = Arrays.asList(50, 100, 150, 200);
        Messages.StreamingOutputCallRequest.Builder streamingOutputBuilder = Messages.StreamingOutputCallRequest.newBuilder();
        for (Integer size : responseSizes) {
            streamingOutputBuilder.addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(size).setIntervalUs(0));
        }
        Messages.StreamingOutputCallRequest request = streamingOutputBuilder.build();
        StreamRecorder recorder = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestStream = this.asyncStub.halfDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        int numRequests = 10;
        for (ix = 10; ix > 0; --ix) {
            requestStream.onNext((Object)request);
        }
        requestStream.onCompleted();
        recorder.awaitCompletion();
        AbstractInteropTest.assertSuccess(recorder);
        Assert.assertEquals((long)(responseSizes.size() * 10), (long)recorder.getValues().size());
        for (ix = 0; ix < recorder.getValues().size(); ++ix) {
            Messages.StreamingOutputCallResponse response = (Messages.StreamingOutputCallResponse)recorder.getValues().get(ix);
            int length = response.getPayload().getBody().size();
            int expectedSize = responseSizes.get(ix % responseSizes.size());
            Assert.assertEquals((String)("comparison failed at index " + ix), (long)expectedSize, (long)length);
        }
    }

    @Test
    public void serverStreamingShouldBeFlowControlled() throws Exception {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(100000)).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(100001)).build();
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[100000]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[100001]))).build());
        long start = System.nanoTime();
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(10);
        ClientCall call = this.channel.newCall(TestServiceGrpc.getStreamingOutputCallMethod(), CallOptions.DEFAULT);
        call.start((ClientCall.Listener)new ClientCall.Listener<Messages.StreamingOutputCallResponse>(){

            public void onHeaders(Metadata headers) {
            }

            public void onMessage(Messages.StreamingOutputCallResponse message) {
                queue.add(message);
            }

            public void onClose(Status status, Metadata trailers) {
                queue.add(status);
            }
        }, new Metadata());
        call.sendMessage((Object)request);
        call.halfClose();
        call.request(1);
        Object response = queue.poll(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)(response instanceof Messages.StreamingOutputCallResponse));
        this.assertResponse(goldenResponses.get(0), (Messages.StreamingOutputCallResponse)response);
        long firstCallDuration = System.nanoTime() - start;
        Assert.assertNull(queue.poll(Math.max(firstCallDuration * 4L, 1000000L), TimeUnit.NANOSECONDS));
        call.request(1);
        response = queue.poll(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)(response instanceof Messages.StreamingOutputCallResponse));
        this.assertResponse(goldenResponses.get(1), (Messages.StreamingOutputCallResponse)response);
        Assert.assertEquals((Object)Status.OK, queue.poll(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS));
    }

    @Test
    public void veryLargeRequest() throws Exception {
        AbstractInteropTest.assumeEnoughMemory();
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[this.unaryPayloadLength()]))).setResponseSize(10).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[10]))).build();
        this.assertResponse(goldenResponse, this.blockingStub.unaryCall(request));
    }

    @Test
    public void veryLargeResponse() throws Exception {
        AbstractInteropTest.assumeEnoughMemory();
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setResponseSize(this.unaryPayloadLength()).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[this.unaryPayloadLength()]))).build();
        this.assertResponse(goldenResponse, this.blockingStub.unaryCall(request));
    }

    @Test
    public void exchangeMetadataUnaryCall() throws Exception {
        TestServiceGrpc.TestServiceBlockingStub stub = this.blockingStub;
        Metadata fixedHeaders = new Metadata();
        Messages.SimpleContext contextValue = Messages.SimpleContext.newBuilder().setValue("dog").build();
        fixedHeaders.put(Util.METADATA_KEY, (Object)contextValue);
        stub = (TestServiceGrpc.TestServiceBlockingStub)MetadataUtils.attachHeaders((AbstractStub)stub, (Metadata)fixedHeaders);
        AtomicReference trailersCapture = new AtomicReference();
        AtomicReference headersCapture = new AtomicReference();
        stub = (TestServiceGrpc.TestServiceBlockingStub)MetadataUtils.captureMetadata((AbstractStub)stub, headersCapture, trailersCapture);
        Assert.assertNotNull((Object)stub.emptyCall(EMPTY));
        Assert.assertEquals((Object)contextValue, (Object)((Metadata)headersCapture.get()).get(Util.METADATA_KEY));
        Assert.assertEquals((Object)contextValue, (Object)((Metadata)trailersCapture.get()).get(Util.METADATA_KEY));
    }

    @Test
    public void exchangeMetadataStreamingCall() throws Exception {
        TestServiceGrpc.TestServiceStub stub = this.asyncStub;
        Metadata fixedHeaders = new Metadata();
        Messages.SimpleContext contextValue = Messages.SimpleContext.newBuilder().setValue("dog").build();
        fixedHeaders.put(Util.METADATA_KEY, (Object)contextValue);
        stub = (TestServiceGrpc.TestServiceStub)MetadataUtils.attachHeaders((AbstractStub)stub, (Metadata)fixedHeaders);
        AtomicReference trailersCapture = new AtomicReference();
        AtomicReference headersCapture = new AtomicReference();
        stub = (TestServiceGrpc.TestServiceStub)MetadataUtils.captureMetadata((AbstractStub)stub, headersCapture, trailersCapture);
        List<Integer> responseSizes = Arrays.asList(50, 100, 150, 200);
        Messages.StreamingOutputCallRequest.Builder streamingOutputBuilder = Messages.StreamingOutputCallRequest.newBuilder();
        for (Integer size : responseSizes) {
            streamingOutputBuilder.addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(size).setIntervalUs(0));
        }
        Messages.StreamingOutputCallRequest request = streamingOutputBuilder.build();
        StreamRecorder recorder = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestStream = stub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        int numRequests = 10;
        for (int ix = 10; ix > 0; --ix) {
            requestStream.onNext((Object)request);
        }
        requestStream.onCompleted();
        recorder.awaitCompletion();
        AbstractInteropTest.assertSuccess(recorder);
        Assert.assertEquals((long)(responseSizes.size() * 10), (long)recorder.getValues().size());
        Assert.assertEquals((Object)contextValue, (Object)((Metadata)headersCapture.get()).get(Util.METADATA_KEY));
        Assert.assertEquals((Object)contextValue, (Object)((Metadata)trailersCapture.get()).get(Util.METADATA_KEY));
    }

    @Test
    public void sendsTimeoutHeader() {
        Assume.assumeTrue((String)"can not capture request headers on server side", (this.server != null ? 1 : 0) != 0);
        long configuredTimeoutMinutes = 100L;
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(configuredTimeoutMinutes, TimeUnit.MINUTES);
        stub.emptyCall(EMPTY);
        long transferredTimeoutMinutes = TimeUnit.NANOSECONDS.toMinutes((Long)this.requestHeadersCapture.get().get(GrpcUtil.TIMEOUT_KEY));
        Assert.assertTrue((String)("configuredTimeoutMinutes=" + configuredTimeoutMinutes + ", transferredTimeoutMinutes=" + transferredTimeoutMinutes), (configuredTimeoutMinutes - transferredTimeoutMinutes >= 0L && configuredTimeoutMinutes - transferredTimeoutMinutes <= 1L ? 1 : 0) != 0);
    }

    @Test
    public void deadlineNotExceeded() {
        this.blockingStub.emptyCall(EmptyProtos.Empty.getDefaultInstance());
        ((TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(10L, TimeUnit.SECONDS)).streamingOutputCall(Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setIntervalUs(0)).build()).next();
    }

    @Test
    public void deadlineExceeded() throws Exception {
        this.blockingStub.emptyCall(EmptyProtos.Empty.getDefaultInstance());
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(10L, TimeUnit.MILLISECONDS);
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setIntervalUs((int)TimeUnit.SECONDS.toMicros(20L))).build();
        try {
            stub.streamingOutputCall(request).next();
            Assert.fail((String)"Expected deadline to be exceeded");
        }
        catch (StatusRuntimeException ex) {
            Assert.assertEquals((Object)Status.DEADLINE_EXCEEDED.getCode(), (Object)ex.getStatus().getCode());
        }
        this.assertStatsTrace("grpc.testing.TestService/EmptyCall", Status.Code.OK);
        if (this.metricsExpected()) {
            StatsTestUtils.MetricsRecord clientStartRecord = this.clientStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkStartTags(clientStartRecord, "grpc.testing.TestService/StreamingOutputCall");
            StatsTestUtils.MetricsRecord clientEndRecord = this.clientStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkEndTags(clientEndRecord, "grpc.testing.TestService/StreamingOutputCall", Status.Code.DEADLINE_EXCEEDED);
        }
    }

    @Test
    public void deadlineExceededServerStreaming() throws Exception {
        this.blockingStub.emptyCall(EmptyProtos.Empty.getDefaultInstance());
        Messages.ResponseParameters.Builder responseParameters = Messages.ResponseParameters.newBuilder().setSize(1).setIntervalUs(10000);
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(responseParameters).addResponseParameters(responseParameters).addResponseParameters(responseParameters).addResponseParameters(responseParameters).build();
        StreamRecorder recorder = StreamRecorder.create();
        ((TestServiceGrpc.TestServiceStub)this.asyncStub.withDeadlineAfter(30L, TimeUnit.MILLISECONDS)).streamingOutputCall(request, (StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        recorder.awaitCompletion();
        Assert.assertEquals((Object)Status.DEADLINE_EXCEEDED.getCode(), (Object)Status.fromThrowable((Throwable)recorder.getError()).getCode());
        this.assertStatsTrace("grpc.testing.TestService/EmptyCall", Status.Code.OK);
        if (this.metricsExpected()) {
            StatsTestUtils.MetricsRecord clientStartRecord = this.clientStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkStartTags(clientStartRecord, "grpc.testing.TestService/StreamingOutputCall");
            StatsTestUtils.MetricsRecord clientEndRecord = this.clientStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkEndTags(clientEndRecord, "grpc.testing.TestService/StreamingOutputCall", Status.Code.DEADLINE_EXCEEDED);
        }
    }

    @Test
    public void deadlineInPast() throws Exception {
        StatsTestUtils.MetricsRecord clientEndRecord;
        StatsTestUtils.MetricsRecord clientStartRecord;
        try {
            ((TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(-10L, TimeUnit.SECONDS)).emptyCall(EmptyProtos.Empty.getDefaultInstance());
            Assert.fail((String)"Should have thrown");
        }
        catch (StatusRuntimeException ex) {
            Assert.assertEquals((Object)Status.Code.DEADLINE_EXCEEDED, (Object)ex.getStatus().getCode());
        }
        if (this.metricsExpected()) {
            clientStartRecord = this.clientStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkStartTags(clientStartRecord, "grpc.testing.TestService/EmptyCall");
            clientEndRecord = this.clientStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkEndTags(clientEndRecord, "grpc.testing.TestService/EmptyCall", Status.DEADLINE_EXCEEDED.getCode());
        }
        this.blockingStub.emptyCall(EmptyProtos.Empty.getDefaultInstance());
        try {
            ((TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(-10L, TimeUnit.SECONDS)).emptyCall(EmptyProtos.Empty.getDefaultInstance());
            Assert.fail((String)"Should have thrown");
        }
        catch (StatusRuntimeException ex) {
            Assert.assertEquals((Object)Status.Code.DEADLINE_EXCEEDED, (Object)ex.getStatus().getCode());
        }
        this.assertStatsTrace("grpc.testing.TestService/EmptyCall", Status.Code.OK);
        if (this.metricsExpected()) {
            clientStartRecord = this.clientStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkStartTags(clientStartRecord, "grpc.testing.TestService/EmptyCall");
            clientEndRecord = this.clientStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkEndTags(clientEndRecord, "grpc.testing.TestService/EmptyCall", Status.DEADLINE_EXCEEDED.getCode());
        }
    }

    @Test
    public void maxInboundSize_exact() {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(1)).build();
        MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> md = TestServiceGrpc.getStreamingOutputCallMethod();
        ByteSizeMarshaller mar = new ByteSizeMarshaller(md.getResponseMarshaller());
        ClientCalls.blockingServerStreamingCall((Channel)this.blockingStub.getChannel(), (MethodDescriptor)md.toBuilder(md.getRequestMarshaller(), mar).build(), (CallOptions)this.blockingStub.getCallOptions(), (Object)request).next();
        int size = mar.lastInSize;
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withMaxInboundMessageSize(size);
        stub.streamingOutputCall(request).next();
    }

    @Test
    public void maxInboundSize_tooBig() {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(1)).build();
        MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> md = TestServiceGrpc.getStreamingOutputCallMethod();
        ByteSizeMarshaller mar = new ByteSizeMarshaller(md.getRequestMarshaller());
        ClientCalls.blockingServerStreamingCall((Channel)this.blockingStub.getChannel(), (MethodDescriptor)md.toBuilder(mar, md.getResponseMarshaller()).build(), (CallOptions)this.blockingStub.getCallOptions(), (Object)request).next();
        int size = mar.lastOutSize;
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withMaxInboundMessageSize(size - 1);
        try {
            stub.streamingOutputCall(request).next();
            Assert.fail();
        }
        catch (StatusRuntimeException ex) {
            Status s = ex.getStatus();
            Truth.assertWithMessage((String)s.toString()).that((Comparable)s.getCode()).isEqualTo((Object)Status.Code.RESOURCE_EXHAUSTED);
            Truth.assertThat((String)Throwables.getStackTraceAsString((Throwable)ex)).contains((CharSequence)"exceeds maximum");
        }
    }

    @Test
    public void maxOutboundSize_exact() {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(1)).build();
        MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> md = TestServiceGrpc.getStreamingOutputCallMethod();
        ByteSizeMarshaller mar = new ByteSizeMarshaller(md.getRequestMarshaller());
        ClientCalls.blockingServerStreamingCall((Channel)this.blockingStub.getChannel(), (MethodDescriptor)md.toBuilder(mar, md.getResponseMarshaller()).build(), (CallOptions)this.blockingStub.getCallOptions(), (Object)request).next();
        int size = mar.lastOutSize;
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withMaxOutboundMessageSize(size);
        stub.streamingOutputCall(request).next();
    }

    @Test
    public void maxOutboundSize_tooBig() {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(1)).build();
        MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> md = TestServiceGrpc.getStreamingOutputCallMethod();
        ByteSizeMarshaller mar = new ByteSizeMarshaller(md.getRequestMarshaller());
        ClientCalls.blockingServerStreamingCall((Channel)this.blockingStub.getChannel(), (MethodDescriptor)md.toBuilder(mar, md.getResponseMarshaller()).build(), (CallOptions)this.blockingStub.getCallOptions(), (Object)request).next();
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withMaxOutboundMessageSize(mar.lastOutSize - 1);
        try {
            stub.streamingOutputCall(request).next();
            Assert.fail();
        }
        catch (StatusRuntimeException ex) {
            Status s = ex.getStatus();
            Truth.assertWithMessage((String)s.toString()).that((Comparable)s.getCode()).isEqualTo((Object)Status.Code.CANCELLED);
            Truth.assertThat((String)Throwables.getStackTraceAsString((Throwable)ex)).contains((CharSequence)"message too large");
        }
    }

    protected int unaryPayloadLength() {
        return 0xA00000;
    }

    @Test
    public void gracefulShutdown() throws Exception {
        List<Messages.StreamingOutputCallRequest> requests = Arrays.asList(Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(3)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[2]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(1)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[7]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(4)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[1]))).build());
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[3]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[1]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[4]))).build());
        final ArrayBlockingQueue responses = new ArrayBlockingQueue(3);
        final SettableFuture completed = SettableFuture.create();
        final SettableFuture errorSeen = SettableFuture.create();
        StreamObserver<Messages.StreamingOutputCallResponse> responseObserver = new StreamObserver<Messages.StreamingOutputCallResponse>(){

            public void onNext(Messages.StreamingOutputCallResponse value) {
                responses.add(value);
            }

            public void onError(Throwable t) {
                errorSeen.set(null);
            }

            public void onCompleted() {
                completed.set(null);
            }
        };
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall(responseObserver);
        requestObserver.onNext((Object)requests.get(0));
        this.assertResponse(goldenResponses.get(0), (Messages.StreamingOutputCallResponse)responses.poll(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS));
        this.channel.shutdown();
        requestObserver.onNext((Object)requests.get(1));
        this.assertResponse(goldenResponses.get(1), (Messages.StreamingOutputCallResponse)responses.poll(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS));
        requestObserver.onNext((Object)requests.get(2));
        this.assertResponse(goldenResponses.get(2), (Messages.StreamingOutputCallResponse)responses.poll(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)completed.isDone());
        requestObserver.onCompleted();
        completed.get((long)this.operationTimeoutMillis(), TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)errorSeen.isDone());
    }

    @Test
    public void customMetadata() throws Exception {
        int responseSize = 314159;
        int requestSize = 271828;
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.StreamingOutputCallRequest streamingRequest = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(314159)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        Messages.StreamingOutputCallResponse goldenStreamingResponse = Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        byte[] trailingBytes = new byte[]{10, 11, 10, 11, 10, 11};
        Metadata metadata = new Metadata();
        metadata.put(Util.ECHO_INITIAL_METADATA_KEY, (Object)"test_initial_metadata_value");
        metadata.put(Util.ECHO_TRAILING_METADATA_KEY, (Object)trailingBytes);
        TestServiceGrpc.TestServiceBlockingStub blockingStub = this.blockingStub;
        blockingStub = (TestServiceGrpc.TestServiceBlockingStub)MetadataUtils.attachHeaders((AbstractStub)blockingStub, (Metadata)metadata);
        AtomicReference headersCapture = new AtomicReference();
        AtomicReference trailersCapture = new AtomicReference();
        blockingStub = (TestServiceGrpc.TestServiceBlockingStub)MetadataUtils.captureMetadata((AbstractStub)blockingStub, headersCapture, trailersCapture);
        Messages.SimpleResponse response = blockingStub.unaryCall(request);
        this.assertResponse(goldenResponse, response);
        Assert.assertEquals((Object)"test_initial_metadata_value", (Object)((Metadata)headersCapture.get()).get(Util.ECHO_INITIAL_METADATA_KEY));
        Assert.assertTrue((boolean)Arrays.equals(trailingBytes, (byte[])((Metadata)trailersCapture.get()).get(Util.ECHO_TRAILING_METADATA_KEY)));
        this.assertStatsTrace("grpc.testing.TestService/UnaryCall", Status.Code.OK, Collections.singleton(request), Collections.singleton(goldenResponse));
        metadata = new Metadata();
        metadata.put(Util.ECHO_INITIAL_METADATA_KEY, (Object)"test_initial_metadata_value");
        metadata.put(Util.ECHO_TRAILING_METADATA_KEY, (Object)trailingBytes);
        TestServiceGrpc.TestServiceStub stub = this.asyncStub;
        stub = (TestServiceGrpc.TestServiceStub)MetadataUtils.attachHeaders((AbstractStub)stub, (Metadata)metadata);
        headersCapture = new AtomicReference();
        trailersCapture = new AtomicReference();
        stub = (TestServiceGrpc.TestServiceStub)MetadataUtils.captureMetadata((AbstractStub)stub, headersCapture, trailersCapture);
        StreamRecorder recorder = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestStream = stub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        requestStream.onNext((Object)streamingRequest);
        requestStream.onCompleted();
        recorder.awaitCompletion();
        AbstractInteropTest.assertSuccess(recorder);
        this.assertResponse(goldenStreamingResponse, (Messages.StreamingOutputCallResponse)recorder.firstValue().get());
        Assert.assertEquals((Object)"test_initial_metadata_value", (Object)((Metadata)headersCapture.get()).get(Util.ECHO_INITIAL_METADATA_KEY));
        Assert.assertTrue((boolean)Arrays.equals(trailingBytes, (byte[])((Metadata)trailersCapture.get()).get(Util.ECHO_TRAILING_METADATA_KEY)));
        this.assertStatsTrace("grpc.testing.TestService/FullDuplexCall", Status.Code.OK, Collections.singleton(streamingRequest), Collections.singleton(goldenStreamingResponse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void censusContextsPropagated() {
        Assume.assumeTrue((String)"Skip the test because server is not in the same process.", (this.server != null ? 1 : 0) != 0);
        Span clientParentSpan = Tracing.getTracer().spanBuilder("Test.interopTest").startSpan();
        Assert.assertTrue((boolean)clientParentSpan.getContext().getTraceId().isValid());
        Context ctx = ContextUtils.withValue((Context)Context.ROOT, (TagContext)tagger.emptyBuilder().putPropagating(StatsTestUtils.EXTRA_TAG, TagValue.create((String)"extra value")).build());
        ctx = io.opencensus.trace.unsafe.ContextUtils.withValue((Context)ctx, (Span)clientParentSpan);
        Context origCtx = ctx.attach();
        try {
            this.blockingStub.unaryCall(Messages.SimpleRequest.getDefaultInstance());
            Context serverCtx = this.contextCapture.get();
            Assert.assertNotNull((Object)serverCtx);
            StatsTestUtils.FakeTagContext statsCtx = (StatsTestUtils.FakeTagContext)ContextUtils.getValue((Context)serverCtx);
            Assert.assertNotNull((Object)statsCtx);
            ImmutableMap tags = statsCtx.getTags();
            boolean tagFound = false;
            for (Map.Entry tag : tags.entrySet()) {
                if (!((TagKey)tag.getKey()).equals(StatsTestUtils.EXTRA_TAG)) continue;
                Assert.assertEquals((Object)TagValue.create((String)"extra value"), tag.getValue());
                tagFound = true;
            }
            Assert.assertTrue((String)"tag not found", (boolean)tagFound);
            Span span = io.opencensus.trace.unsafe.ContextUtils.getValue((Context)serverCtx);
            Assert.assertNotNull((Object)span);
            SpanContext spanContext = span.getContext();
            Assert.assertEquals((Object)clientParentSpan.getContext().getTraceId(), (Object)spanContext.getTraceId());
        }
        finally {
            ctx.detach(origCtx);
        }
    }

    @Test
    public void statusCodeAndMessage() throws Exception {
        int errorCode = 2;
        String errorMessage = "test status message";
        Messages.EchoStatus responseStatus = Messages.EchoStatus.newBuilder().setCode(errorCode).setMessage(errorMessage).build();
        Messages.SimpleRequest simpleRequest = Messages.SimpleRequest.newBuilder().setResponseStatus(responseStatus).build();
        Messages.StreamingOutputCallRequest streamingRequest = Messages.StreamingOutputCallRequest.newBuilder().setResponseStatus(responseStatus).build();
        try {
            this.blockingStub.unaryCall(simpleRequest);
            Assert.fail();
        }
        catch (StatusRuntimeException e) {
            Assert.assertEquals((Object)Status.UNKNOWN.getCode(), (Object)e.getStatus().getCode());
            Assert.assertEquals((Object)errorMessage, (Object)e.getStatus().getDescription());
        }
        this.assertStatsTrace("grpc.testing.TestService/UnaryCall", Status.Code.UNKNOWN);
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver);
        requestObserver.onNext((Object)streamingRequest);
        requestObserver.onCompleted();
        Truth.assertThat((Boolean)responseObserver.awaitCompletion(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS)).isTrue();
        Truth.assertThat((Throwable)responseObserver.getError()).isNotNull();
        Status status = Status.fromThrowable((Throwable)responseObserver.getError());
        Assert.assertEquals((Object)Status.UNKNOWN.getCode(), (Object)status.getCode());
        Assert.assertEquals((Object)errorMessage, (Object)status.getDescription());
        this.assertStatsTrace("grpc.testing.TestService/FullDuplexCall", Status.Code.UNKNOWN);
    }

    @Test
    public void specialStatusMessage() throws Exception {
        int errorCode = 2;
        String errorMessage = "\t\ntest with whitespace\r\nand Unicode BMP \u263a and non-BMP \ud83d\ude08\t\n";
        Messages.SimpleRequest simpleRequest = Messages.SimpleRequest.newBuilder().setResponseStatus(Messages.EchoStatus.newBuilder().setCode(errorCode).setMessage(errorMessage).build()).build();
        try {
            this.blockingStub.unaryCall(simpleRequest);
            Assert.fail();
        }
        catch (StatusRuntimeException e) {
            Assert.assertEquals((Object)Status.UNKNOWN.getCode(), (Object)e.getStatus().getCode());
            Assert.assertEquals((Object)errorMessage, (Object)e.getStatus().getDescription());
        }
        this.assertStatsTrace("grpc.testing.TestService/UnaryCall", Status.Code.UNKNOWN);
    }

    @Test
    public void unimplementedMethod() {
        try {
            this.blockingStub.unimplementedCall(EmptyProtos.Empty.getDefaultInstance());
            Assert.fail();
        }
        catch (StatusRuntimeException e) {
            Assert.assertEquals((Object)Status.UNIMPLEMENTED.getCode(), (Object)e.getStatus().getCode());
        }
        this.assertClientStatsTrace("grpc.testing.TestService/UnimplementedCall", Status.Code.UNIMPLEMENTED);
    }

    @Test
    public void unimplementedService() {
        UnimplementedServiceGrpc.UnimplementedServiceBlockingStub stub = (UnimplementedServiceGrpc.UnimplementedServiceBlockingStub)UnimplementedServiceGrpc.newBlockingStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{this.tracerSetupInterceptor});
        try {
            stub.unimplementedCall(EmptyProtos.Empty.getDefaultInstance());
            Assert.fail();
        }
        catch (StatusRuntimeException e) {
            Assert.assertEquals((Object)Status.UNIMPLEMENTED.getCode(), (Object)e.getStatus().getCode());
        }
        this.assertStatsTrace("grpc.testing.UnimplementedService/UnimplementedCall", Status.Code.UNIMPLEMENTED);
    }

    @Test
    public void timeoutOnSleepingServer() throws Exception {
        TestServiceGrpc.TestServiceStub stub = (TestServiceGrpc.TestServiceStub)this.asyncStub.withDeadlineAfter(1L, TimeUnit.MILLISECONDS);
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = stub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver);
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[27182]))).build();
        try {
            requestObserver.onNext((Object)request);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)responseObserver.awaitCompletion(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)0L, (long)responseObserver.getValues().size());
        Assert.assertEquals((Object)Status.DEADLINE_EXCEEDED.getCode(), (Object)Status.fromThrowable((Throwable)responseObserver.getError()).getCode());
        if (this.metricsExpected()) {
            StatsTestUtils.MetricsRecord clientStartRecord = this.clientStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkStartTags(clientStartRecord, "grpc.testing.TestService/FullDuplexCall");
            StatsTestUtils.MetricsRecord clientEndRecord = this.clientStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkEndTags(clientEndRecord, "grpc.testing.TestService/FullDuplexCall", Status.DEADLINE_EXCEEDED.getCode());
        }
    }

    public void serviceAccountCreds(String jsonKey, InputStream credentialsStream, String authScope) throws Exception {
        GoogleCredentials credentials = (GoogleCredentials)ServiceAccountCredentials.class.cast(GoogleCredentials.fromStream((InputStream)credentialsStream));
        credentials = credentials.createScoped(Arrays.asList(authScope));
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withCallCredentials(MoreCallCredentials.from((Credentials)credentials));
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setFillUsername(true).setFillOauthScope(true).setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse response = stub.unaryCall(request);
        Assert.assertFalse((boolean)response.getUsername().isEmpty());
        Assert.assertTrue((String)("Received username: " + response.getUsername()), (boolean)jsonKey.contains(response.getUsername()));
        Assert.assertFalse((boolean)response.getOauthScope().isEmpty());
        Assert.assertTrue((String)("Received oauth scope: " + response.getOauthScope()), (boolean)authScope.contains(response.getOauthScope()));
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setOauthScope(response.getOauthScope()).setUsername(response.getUsername()).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        this.assertResponse(goldenResponse, response);
    }

    public void computeEngineCreds(String serviceAccount, String oauthScope) throws Exception {
        ComputeEngineCredentials credentials = ComputeEngineCredentials.create();
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withCallCredentials(MoreCallCredentials.from((Credentials)credentials));
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setFillUsername(true).setFillOauthScope(true).setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse response = stub.unaryCall(request);
        Assert.assertEquals((Object)serviceAccount, (Object)response.getUsername());
        Assert.assertFalse((boolean)response.getOauthScope().isEmpty());
        Assert.assertTrue((String)("Received oauth scope: " + response.getOauthScope()), (boolean)oauthScope.contains(response.getOauthScope()));
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setOauthScope(response.getOauthScope()).setUsername(response.getUsername()).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        this.assertResponse(goldenResponse, response);
    }

    public void computeEngineChannelCredentials(String defaultServiceAccount, TestServiceGrpc.TestServiceBlockingStub computeEngineStub) throws Exception {
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setFillUsername(true).setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse response = computeEngineStub.unaryCall(request);
        Assert.assertEquals((Object)defaultServiceAccount, (Object)response.getUsername());
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setUsername(defaultServiceAccount).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        this.assertResponse(goldenResponse, response);
    }

    public void jwtTokenCreds(InputStream serviceAccountJson) throws Exception {
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).setFillUsername(true).build();
        ServiceAccountCredentials credentials = (ServiceAccountCredentials)GoogleCredentials.fromStream((InputStream)serviceAccountJson);
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withCallCredentials(MoreCallCredentials.from((Credentials)credentials));
        Messages.SimpleResponse response = stub.unaryCall(request);
        Assert.assertEquals((Object)credentials.getClientEmail(), (Object)response.getUsername());
        Assert.assertEquals((long)314159L, (long)response.getPayload().getBody().size());
    }

    public void oauth2AuthToken(String jsonKey, InputStream credentialsStream, String authScope) throws Exception {
        GoogleCredentials utilCredentials = GoogleCredentials.fromStream((InputStream)credentialsStream);
        utilCredentials = utilCredentials.createScoped(Arrays.asList(authScope));
        AccessToken accessToken = utilCredentials.refreshAccessToken();
        OAuth2Credentials credentials = OAuth2Credentials.create((AccessToken)accessToken);
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withCallCredentials(MoreCallCredentials.from((Credentials)credentials));
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setFillUsername(true).setFillOauthScope(true).build();
        Messages.SimpleResponse response = stub.unaryCall(request);
        Assert.assertFalse((boolean)response.getUsername().isEmpty());
        Assert.assertTrue((String)("Received username: " + response.getUsername()), (boolean)jsonKey.contains(response.getUsername()));
        Assert.assertFalse((boolean)response.getOauthScope().isEmpty());
        Assert.assertTrue((String)("Received oauth scope: " + response.getOauthScope()), (boolean)authScope.contains(response.getOauthScope()));
    }

    public void perRpcCreds(String jsonKey, InputStream credentialsStream, String oauthScope) throws Exception {
        this.oauth2AuthToken(jsonKey, credentialsStream, oauthScope);
    }

    public void googleDefaultCredentials(String defaultServiceAccount, TestServiceGrpc.TestServiceBlockingStub googleDefaultStub) throws Exception {
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setFillUsername(true).setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse response = googleDefaultStub.unaryCall(request);
        Assert.assertEquals((Object)defaultServiceAccount, (Object)response.getUsername());
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setUsername(defaultServiceAccount).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        this.assertResponse(goldenResponse, response);
    }

    protected static void assertSuccess(StreamRecorder<?> recorder) {
        if (recorder.getError() != null) {
            throw new AssertionError((Object)recorder.getError());
        }
    }

    protected SocketAddress obtainRemoteClientAddr() {
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(5L, TimeUnit.SECONDS);
        stub.unaryCall(Messages.SimpleRequest.getDefaultInstance());
        return (SocketAddress)this.serverCallCapture.get().getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
    }

    protected SocketAddress obtainLocalClientAddr() {
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(5L, TimeUnit.SECONDS);
        stub.unaryCall(Messages.SimpleRequest.getDefaultInstance());
        return (SocketAddress)this.serverCallCapture.get().getAttributes().get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR);
    }

    protected void assertX500SubjectDn(String tlsInfo) {
        List<Certificate> certificates;
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(5L, TimeUnit.SECONDS);
        stub.unaryCall(Messages.SimpleRequest.getDefaultInstance());
        SSLSession sslSession = (SSLSession)this.serverCallCapture.get().getAttributes().get(Grpc.TRANSPORT_ATTR_SSL_SESSION);
        try {
            certificates = Arrays.asList(sslSession.getPeerCertificates());
        }
        catch (SSLPeerUnverifiedException e) {
            throw new AssertionError((Object)e);
        }
        X509Certificate x509cert = (X509Certificate)certificates.get(0);
        Assert.assertEquals((long)1L, (long)certificates.size());
        Assert.assertEquals((Object)tlsInfo, (Object)x509cert.getSubjectDN().toString());
    }

    protected int operationTimeoutMillis() {
        return 5000;
    }

    private static void assumeEnoughMemory() {
        Runtime r = Runtime.getRuntime();
        long usedMem = r.totalMemory() - r.freeMemory();
        long actuallyFreeMemory = r.maxMemory() - usedMem;
        Assume.assumeTrue((String)(actuallyFreeMemory + " is not sufficient to run this test"), (actuallyFreeMemory >= 0x4000000L ? 1 : 0) != 0);
    }

    private void assertStatsTrace(String method, Status.Code status, Collection<? extends MessageLite> requests, Collection<? extends MessageLite> responses) {
        this.assertClientStatsTrace(method, status, requests, responses);
        this.assertServerStatsTrace(method, status, requests, responses);
    }

    private void assertStatsTrace(String method, Status.Code status) {
        this.assertStatsTrace(method, status, null, null);
    }

    private void assertClientStatsTrace(String method, Status.Code code, Collection<? extends MessageLite> requests, Collection<? extends MessageLite> responses) {
        TestClientStreamTracer tracer = this.clientStreamTracers.poll();
        Assert.assertNotNull((Object)tracer);
        Assert.assertTrue((boolean)tracer.getOutboundHeaders());
        try {
            Assert.assertTrue((boolean)tracer.await(5L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        Assert.assertEquals((Object)code, (Object)tracer.getStatus().getCode());
        if (requests != null && responses != null) {
            this.checkTracers((TestStreamTracer)tracer, requests, responses);
        }
        if (this.metricsExpected()) {
            StatsTestUtils.MetricsRecord clientStartRecord = this.clientStatsRecorder.pollRecord();
            AbstractInteropTest.checkStartTags(clientStartRecord, method);
            StatsTestUtils.MetricsRecord clientEndRecord = this.clientStatsRecorder.pollRecord();
            AbstractInteropTest.checkEndTags(clientEndRecord, method, code);
            if (requests != null && responses != null) {
                this.checkCensus(clientEndRecord, false, requests, responses);
            }
        }
    }

    private void assertClientStatsTrace(String method, Status.Code status) {
        this.assertClientStatsTrace(method, status, null, null);
    }

    private void assertServerStatsTrace(String method, Status.Code code, Collection<? extends MessageLite> requests, Collection<? extends MessageLite> responses) {
        if (this.server == null) {
            return;
        }
        if (this.metricsExpected()) {
            StatsTestUtils.MetricsRecord serverEndRecord;
            StatsTestUtils.MetricsRecord serverStartRecord;
            try {
                serverStartRecord = this.serverStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
                serverEndRecord = this.serverStatsRecorder.pollRecord(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Assert.assertNotNull((Object)serverStartRecord);
            Assert.assertNotNull((Object)serverEndRecord);
            AbstractInteropTest.checkStartTags(serverStartRecord, method);
            AbstractInteropTest.checkEndTags(serverEndRecord, method, code);
            if (requests != null && responses != null) {
                this.checkCensus(serverEndRecord, true, requests, responses);
            }
        }
        ServerStreamTracerInfo tracerInfo = this.serverStreamTracers.poll();
        Assert.assertNotNull((Object)tracerInfo);
        Assert.assertEquals((Object)method, (Object)tracerInfo.fullMethodName);
        Assert.assertNotNull((Object)tracerInfo.tracer.contextCapture);
        try {
            Assert.assertTrue((boolean)tracerInfo.tracer.await(1L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        Assert.assertEquals((Object)code, (Object)tracerInfo.tracer.getStatus().getCode());
        if (requests != null && responses != null) {
            this.checkTracers((TestStreamTracer)tracerInfo.tracer, responses, requests);
        }
    }

    private static void checkStartTags(StatsTestUtils.MetricsRecord record, String methodName) {
        Assert.assertNotNull((String)"record is not null", (Object)record);
        TagValue methodNameTagOld = (TagValue)record.tags.get((Object)DeprecatedCensusConstants.RPC_METHOD);
        Assert.assertNotNull((String)"method name tagged", (Object)methodNameTagOld);
        Assert.assertEquals((String)"method names match", (Object)methodName, (Object)methodNameTagOld.asString());
    }

    private static void checkEndTags(StatsTestUtils.MetricsRecord record, String methodName, Status.Code status) {
        Assert.assertNotNull((String)"record is not null", (Object)record);
        TagValue methodNameTagOld = (TagValue)record.tags.get((Object)DeprecatedCensusConstants.RPC_METHOD);
        Assert.assertNotNull((String)"method name tagged", (Object)methodNameTagOld);
        Assert.assertEquals((String)"method names match", (Object)methodName, (Object)methodNameTagOld.asString());
        TagValue statusTagOld = (TagValue)record.tags.get((Object)DeprecatedCensusConstants.RPC_STATUS);
        Assert.assertNotNull((String)"status tagged", (Object)statusTagOld);
        Assert.assertEquals((Object)status.toString(), (Object)statusTagOld.asString());
    }

    private void checkTracers(TestStreamTracer tracer, Collection<? extends MessageLite> sentMessages, Collection<? extends MessageLite> receivedMessages) {
        long uncompressedSentSize = 0L;
        int seqNo = 0;
        for (MessageLite messageLite : sentMessages) {
            Truth.assertThat((String)tracer.nextOutboundEvent()).isEqualTo((Object)String.format("outboundMessage(%d)", seqNo));
            Truth.assertThat((String)tracer.nextOutboundEvent()).matches(String.format("outboundMessageSent\\(%d, -?[0-9]+, -?[0-9]+\\)", seqNo));
            ++seqNo;
            uncompressedSentSize += (long)messageLite.getSerializedSize();
        }
        Assert.assertNull((Object)tracer.nextOutboundEvent());
        long uncompressedReceivedSize = 0L;
        seqNo = 0;
        for (MessageLite messageLite : receivedMessages) {
            Truth.assertThat((String)tracer.nextInboundEvent()).isEqualTo((Object)String.format("inboundMessage(%d)", seqNo));
            Truth.assertThat((String)tracer.nextInboundEvent()).matches(String.format("inboundMessageRead\\(%d, -?[0-9]+, -?[0-9]+\\)", seqNo));
            uncompressedReceivedSize += (long)messageLite.getSerializedSize();
            ++seqNo;
        }
        Assert.assertNull((Object)tracer.nextInboundEvent());
        if (this.metricsExpected()) {
            Assert.assertEquals((long)uncompressedSentSize, (long)tracer.getOutboundUncompressedSize());
            Assert.assertEquals((long)uncompressedReceivedSize, (long)tracer.getInboundUncompressedSize());
        }
    }

    private void checkCensus(StatsTestUtils.MetricsRecord record, boolean isServer, Collection<? extends MessageLite> requests, Collection<? extends MessageLite> responses) {
        int uncompressedRequestsSize = 0;
        for (MessageLite messageLite : requests) {
            uncompressedRequestsSize += messageLite.getSerializedSize();
        }
        int uncompressedResponsesSize = 0;
        for (MessageLite messageLite : responses) {
            uncompressedResponsesSize += messageLite.getSerializedSize();
        }
        if (isServer) {
            Assert.assertEquals((long)requests.size(), (long)record.getMetricAsLongOrFail((Measure)DeprecatedCensusConstants.RPC_SERVER_REQUEST_COUNT));
            Assert.assertEquals((long)responses.size(), (long)record.getMetricAsLongOrFail((Measure)DeprecatedCensusConstants.RPC_SERVER_RESPONSE_COUNT));
            Assert.assertEquals((long)uncompressedRequestsSize, (long)record.getMetricAsLongOrFail((Measure)DeprecatedCensusConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES));
            Assert.assertEquals((long)uncompressedResponsesSize, (long)record.getMetricAsLongOrFail((Measure)DeprecatedCensusConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES));
            Assert.assertNotNull((Object)record.getMetric((Measure)DeprecatedCensusConstants.RPC_SERVER_SERVER_LATENCY));
            Assert.assertNotNull((Object)record.getMetric((Measure)DeprecatedCensusConstants.RPC_SERVER_REQUEST_BYTES));
            Assert.assertNotNull((Object)record.getMetric((Measure)DeprecatedCensusConstants.RPC_SERVER_RESPONSE_BYTES));
        } else {
            Assert.assertEquals((long)requests.size(), (long)record.getMetricAsLongOrFail((Measure)DeprecatedCensusConstants.RPC_CLIENT_REQUEST_COUNT));
            Assert.assertEquals((long)responses.size(), (long)record.getMetricAsLongOrFail((Measure)DeprecatedCensusConstants.RPC_CLIENT_RESPONSE_COUNT));
            Assert.assertEquals((long)uncompressedRequestsSize, (long)record.getMetricAsLongOrFail((Measure)DeprecatedCensusConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES));
            Assert.assertEquals((long)uncompressedResponsesSize, (long)record.getMetricAsLongOrFail((Measure)DeprecatedCensusConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES));
            Assert.assertNotNull((Object)record.getMetric((Measure)DeprecatedCensusConstants.RPC_CLIENT_ROUNDTRIP_LATENCY));
            Assert.assertNotNull((Object)record.getMetric((Measure)DeprecatedCensusConstants.RPC_CLIENT_REQUEST_BYTES));
            Assert.assertNotNull((Object)record.getMetric((Measure)DeprecatedCensusConstants.RPC_CLIENT_RESPONSE_BYTES));
        }
    }

    private void assertResponses(Collection<Messages.StreamingOutputCallResponse> expected, Collection<Messages.StreamingOutputCallResponse> actual) {
        Assert.assertSame((Object)expected.size(), (Object)actual.size());
        Iterator<Messages.StreamingOutputCallResponse> expectedIter = expected.iterator();
        Iterator<Messages.StreamingOutputCallResponse> actualIter = actual.iterator();
        while (expectedIter.hasNext()) {
            this.assertResponse(expectedIter.next(), actualIter.next());
        }
    }

    private void assertResponse(Messages.StreamingOutputCallResponse expected, Messages.StreamingOutputCallResponse actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((Object)expected, (Object)actual);
        } else {
            this.assertPayload(expected.getPayload(), actual.getPayload());
        }
    }

    private void assertResponse(Messages.SimpleResponse expected, Messages.SimpleResponse actual) {
        this.assertPayload(expected.getPayload(), actual.getPayload());
        Assert.assertEquals((Object)expected.getUsername(), (Object)actual.getUsername());
        Assert.assertEquals((Object)expected.getOauthScope(), (Object)actual.getOauthScope());
    }

    private void assertPayload(Messages.Payload expected, Messages.Payload actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((Object)expected, (Object)actual);
        } else {
            Assert.assertEquals((Object)expected.getBody(), (Object)actual.getBody());
        }
    }

    private static ServerInterceptor recordServerCallInterceptor(final AtomicReference<ServerCall<?, ?>> serverCallCapture) {
        return new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
                serverCallCapture.set(call);
                return next.startCall(call, requestHeaders);
            }
        };
    }

    private static ServerInterceptor recordContextInterceptor(final AtomicReference<Context> contextCapture) {
        return new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
                contextCapture.set(Context.current());
                return next.startCall(call, requestHeaders);
            }
        };
    }

    private static final class ByteSizeMarshaller<T>
    implements MethodDescriptor.Marshaller<T> {
        private final MethodDescriptor.Marshaller<T> delegate;
        volatile int lastOutSize;
        volatile int lastInSize;

        ByteSizeMarshaller(MethodDescriptor.Marshaller<T> delegate) {
            this.delegate = delegate;
        }

        public InputStream stream(T value) {
            InputStream is = this.delegate.stream(value);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.lastOutSize = (int)ByteStreams.copy((InputStream)is, (OutputStream)baos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new ByteArrayInputStream(baos.toByteArray());
        }

        public T parse(InputStream stream) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.lastInSize = (int)ByteStreams.copy((InputStream)stream, (OutputStream)baos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return (T)this.delegate.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
    }

    private static final class ServerStreamTracerInfo {
        final String fullMethodName;
        final InteropServerStreamTracer tracer;

        ServerStreamTracerInfo(String fullMethodName, InteropServerStreamTracer tracer) {
            this.fullMethodName = fullMethodName;
            this.tracer = tracer;
        }

        private static final class InteropServerStreamTracer
        extends TestServerStreamTracer {
            private volatile Context contextCapture;

            private InteropServerStreamTracer() {
            }

            public Context filterContext(Context context) {
                this.contextCapture = context;
                return super.filterContext(context);
            }
        }
    }
}

