/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.google.protobuf.ByteString;
import com.google.protobuf.EmptyProtos;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.internal.LogExceptionRunnable;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import io.grpc.testing.integration.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

public class TestServiceImpl
extends TestServiceGrpc.TestServiceImplBase {
    private static final String UNCOMPRESSABLE_FILE = "/io/grpc/testing/integration/testdata/uncompressable.bin";
    private final Random random = new Random();
    private final ScheduledExecutorService executor;
    private final ByteString uncompressableBuffer;
    private final ByteString compressableBuffer;

    public TestServiceImpl(ScheduledExecutorService executor) {
        this.executor = executor;
        this.compressableBuffer = ByteString.copyFrom((byte[])new byte[1024]);
        this.uncompressableBuffer = this.createBufferFromFile(UNCOMPRESSABLE_FILE);
    }

    public void emptyCall(EmptyProtos.Empty empty, StreamObserver<EmptyProtos.Empty> responseObserver) {
        responseObserver.onNext((Object)EmptyProtos.Empty.getDefaultInstance());
        responseObserver.onCompleted();
    }

    public void unaryCall(Messages.SimpleRequest req, StreamObserver<Messages.SimpleResponse> responseObserver) {
        ServerCallStreamObserver obs = (ServerCallStreamObserver)responseObserver;
        Messages.SimpleResponse.Builder responseBuilder = Messages.SimpleResponse.newBuilder();
        try {
            switch (req.getResponseCompression()) {
                case DEFLATE: 
                case GZIP: {
                    obs.setCompression("gzip");
                    break;
                }
                case NONE: {
                    obs.setCompression("identity");
                    break;
                }
                default: {
                    obs.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Unknown: " + req.getResponseCompression()).asRuntimeException());
                    return;
                }
            }
        }
        catch (IllegalArgumentException e) {
            obs.onError((Throwable)Status.UNIMPLEMENTED.withDescription("compression not supported.").withCause((Throwable)e).asRuntimeException());
            return;
        }
        if (req.getResponseSize() != 0) {
            boolean compressable = this.compressableResponse(req.getResponseType());
            ByteString dataBuffer = compressable ? this.compressableBuffer : this.uncompressableBuffer;
            int offset = this.random.nextInt(compressable ? this.compressableBuffer.size() : this.uncompressableBuffer.size());
            ByteString payload = this.generatePayload(dataBuffer, offset, req.getResponseSize());
            responseBuilder.getPayloadBuilder().setType(compressable ? Messages.PayloadType.COMPRESSABLE : Messages.PayloadType.UNCOMPRESSABLE).setBody(payload);
        }
        if (req.hasResponseStatus()) {
            obs.onError((Throwable)Status.fromCodeValue((int)req.getResponseStatus().getCode()).withDescription(req.getResponseStatus().getMessage()).asRuntimeException());
            return;
        }
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    public void streamingOutputCall(Messages.StreamingOutputCallRequest request, StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
        new ResponseDispatcher(responseObserver).enqueue(this.toChunkQueue(request)).completeInput();
    }

    public StreamObserver<Messages.StreamingInputCallRequest> streamingInputCall(final StreamObserver<Messages.StreamingInputCallResponse> responseObserver) {
        return new StreamObserver<Messages.StreamingInputCallRequest>(){
            private int totalPayloadSize;

            public void onNext(Messages.StreamingInputCallRequest message) {
                this.totalPayloadSize += message.getPayload().getBody().size();
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Messages.StreamingInputCallResponse.newBuilder().setAggregatedPayloadSize(this.totalPayloadSize).build());
                responseObserver.onCompleted();
            }

            public void onError(Throwable cause) {
                responseObserver.onError(cause);
            }
        };
    }

    public StreamObserver<Messages.StreamingOutputCallRequest> fullDuplexCall(final StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
        final ResponseDispatcher dispatcher = new ResponseDispatcher(responseObserver);
        return new StreamObserver<Messages.StreamingOutputCallRequest>(){

            public void onNext(Messages.StreamingOutputCallRequest request) {
                if (request.hasResponseStatus()) {
                    dispatcher.cancel();
                    responseObserver.onError((Throwable)Status.fromCodeValue((int)request.getResponseStatus().getCode()).withDescription(request.getResponseStatus().getMessage()).asRuntimeException());
                    return;
                }
                dispatcher.enqueue(TestServiceImpl.this.toChunkQueue(request));
            }

            public void onCompleted() {
                if (!dispatcher.isCancelled()) {
                    dispatcher.completeInput();
                }
            }

            public void onError(Throwable cause) {
                responseObserver.onError(cause);
            }
        };
    }

    public StreamObserver<Messages.StreamingOutputCallRequest> halfDuplexCall(final StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
        final LinkedList chunks = new LinkedList();
        return new StreamObserver<Messages.StreamingOutputCallRequest>(){

            public void onNext(Messages.StreamingOutputCallRequest request) {
                chunks.addAll(TestServiceImpl.this.toChunkQueue(request));
            }

            public void onCompleted() {
                new ResponseDispatcher((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver).enqueue(chunks).completeInput();
            }

            public void onError(Throwable cause) {
                responseObserver.onError(cause);
            }
        };
    }

    public Queue<Chunk> toChunkQueue(Messages.StreamingOutputCallRequest request) {
        LinkedList<Chunk> chunkQueue = new LinkedList<Chunk>();
        int offset = 0;
        boolean compressable = this.compressableResponse(request.getResponseType());
        for (Messages.ResponseParameters params : request.getResponseParametersList()) {
            chunkQueue.add(new Chunk(params.getIntervalUs(), offset, params.getSize(), compressable));
            offset = (offset + params.getSize()) % (compressable ? this.compressableBuffer.size() : this.uncompressableBuffer.size());
        }
        return chunkQueue;
    }

    private ByteString createBufferFromFile(String fileClassPath) {
        ByteString buffer = ByteString.EMPTY;
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(fileClassPath);
        if (inputStream == null) {
            throw new IllegalArgumentException("Unable to locate file on classpath: " + fileClassPath);
        }
        try {
            buffer = ByteString.readFrom((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return buffer;
    }

    private boolean compressableResponse(Messages.PayloadType responseType) {
        switch (responseType) {
            case COMPRESSABLE: {
                return true;
            }
            case RANDOM: {
                return this.random.nextBoolean();
            }
        }
        return false;
    }

    private ByteString generatePayload(ByteString dataBuffer, int offset, int size) {
        ByteString payload = ByteString.EMPTY;
        int begin = offset;
        int end = 0;
        for (int bytesLeft = size; bytesLeft > 0; bytesLeft -= end - begin) {
            end = Math.min(begin + bytesLeft, dataBuffer.size());
            payload = payload.concat(dataBuffer.substring(begin, end));
            begin = end % dataBuffer.size();
        }
        return payload;
    }

    public static List<ServerInterceptor> interceptors() {
        return Arrays.asList(TestServiceImpl.echoRequestHeadersInterceptor(Util.METADATA_KEY), TestServiceImpl.echoRequestMetadataInHeaders(Util.ECHO_INITIAL_METADATA_KEY), TestServiceImpl.echoRequestMetadataInTrailers(Util.ECHO_TRAILING_METADATA_KEY));
    }

    private static ServerInterceptor echoRequestHeadersInterceptor(Metadata.Key<?> ... keys) {
        final HashSet keySet = new HashSet(Arrays.asList(keys));
        return new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, final Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                    public void sendHeaders(Metadata responseHeaders) {
                        responseHeaders.merge(requestHeaders, keySet);
                        super.sendHeaders(responseHeaders);
                    }

                    public void close(Status status, Metadata trailers) {
                        trailers.merge(requestHeaders, keySet);
                        super.close(status, trailers);
                    }
                }, requestHeaders);
            }
        };
    }

    private static ServerInterceptor echoRequestMetadataInHeaders(Metadata.Key<?> ... keys) {
        final HashSet keySet = new HashSet(Arrays.asList(keys));
        return new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, final Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                    public void sendHeaders(Metadata responseHeaders) {
                        responseHeaders.merge(requestHeaders, keySet);
                        super.sendHeaders(responseHeaders);
                    }

                    public void close(Status status, Metadata trailers) {
                        super.close(status, trailers);
                    }
                }, requestHeaders);
            }
        };
    }

    private static ServerInterceptor echoRequestMetadataInTrailers(Metadata.Key<?> ... keys) {
        final HashSet keySet = new HashSet(Arrays.asList(keys));
        return new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, final Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                    public void sendHeaders(Metadata responseHeaders) {
                        super.sendHeaders(responseHeaders);
                    }

                    public void close(Status status, Metadata trailers) {
                        trailers.merge(requestHeaders, keySet);
                        super.close(status, trailers);
                    }
                }, requestHeaders);
            }
        };
    }

    private class Chunk {
        private final int delayMicroseconds;
        private final int offset;
        private final int length;
        private final boolean compressable;

        public Chunk(int delayMicroseconds, int offset, int length, boolean compressable) {
            this.delayMicroseconds = delayMicroseconds;
            this.offset = offset;
            this.length = length;
            this.compressable = compressable;
        }

        private Messages.StreamingOutputCallResponse toResponse() {
            Messages.StreamingOutputCallResponse.Builder responseBuilder = Messages.StreamingOutputCallResponse.newBuilder();
            ByteString dataBuffer = this.compressable ? TestServiceImpl.this.compressableBuffer : TestServiceImpl.this.uncompressableBuffer;
            ByteString payload = TestServiceImpl.this.generatePayload(dataBuffer, this.offset, this.length);
            responseBuilder.getPayloadBuilder().setType(this.compressable ? Messages.PayloadType.COMPRESSABLE : Messages.PayloadType.UNCOMPRESSABLE).setBody(payload);
            return responseBuilder.build();
        }
    }

    private class ResponseDispatcher {
        private final Chunk completionChunk;
        private final Queue<Chunk> chunks;
        private final StreamObserver<Messages.StreamingOutputCallResponse> responseStream;
        private boolean scheduled;
        @GuardedBy(value="this")
        private boolean cancelled;
        private Throwable failure;
        private Runnable dispatchTask;

        public ResponseDispatcher(StreamObserver<Messages.StreamingOutputCallResponse> responseStream) {
            this.completionChunk = new Chunk(0, 0, 0, false);
            this.dispatchTask = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        try {
                            ResponseDispatcher.this.dispatchChunk();
                        }
                        catch (RuntimeException e) {
                            ResponseDispatcher responseDispatcher = ResponseDispatcher.this;
                            synchronized (responseDispatcher) {
                                ResponseDispatcher.this.scheduled = false;
                            }
                            throw e;
                        }
                        ResponseDispatcher e = ResponseDispatcher.this;
                        synchronized (e) {
                            ResponseDispatcher.this.scheduled = false;
                            ResponseDispatcher.this.scheduleNextChunk();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            };
            this.chunks = Queues.newLinkedBlockingQueue();
            this.responseStream = responseStream;
        }

        public synchronized ResponseDispatcher enqueue(Queue<Chunk> moreChunks) {
            this.assertNotFailed();
            this.chunks.addAll(moreChunks);
            this.scheduleNextChunk();
            return this;
        }

        public ResponseDispatcher completeInput() {
            this.assertNotFailed();
            this.chunks.add(this.completionChunk);
            this.scheduleNextChunk();
            return this;
        }

        public synchronized void cancel() {
            Preconditions.checkState((!this.cancelled ? 1 : 0) != 0, (Object)"Dispatcher already cancelled");
            this.chunks.clear();
            this.cancelled = true;
        }

        public synchronized boolean isCancelled() {
            return this.cancelled;
        }

        private synchronized void dispatchChunk() {
            if (this.cancelled) {
                return;
            }
            try {
                Chunk chunk = this.chunks.remove();
                if (chunk == this.completionChunk) {
                    this.responseStream.onCompleted();
                } else {
                    this.responseStream.onNext((Object)chunk.toResponse());
                }
            }
            catch (Throwable e) {
                this.failure = e;
                if (Status.fromThrowable((Throwable)e).getCode() == Status.CANCELLED.getCode()) {
                    this.chunks.clear();
                }
                this.responseStream.onError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleNextChunk() {
            ResponseDispatcher responseDispatcher = this;
            synchronized (responseDispatcher) {
                if (this.scheduled) {
                    return;
                }
                Chunk nextChunk = this.chunks.peek();
                if (nextChunk != null) {
                    this.scheduled = true;
                    ScheduledFuture<?> unused = TestServiceImpl.this.executor.schedule((Runnable)new LogExceptionRunnable(this.dispatchTask), (long)nextChunk.delayMicroseconds, TimeUnit.MICROSECONDS);
                    return;
                }
            }
        }

        private void assertNotFailed() {
            if (this.failure != null) {
                throw new IllegalStateException("Stream already failed", this.failure);
            }
        }
    }
}

