/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.EmptyProtos;
import io.grpc.Call;
import io.grpc.Channel;
import io.grpc.Marshaller;
import io.grpc.MethodDescriptor;
import io.grpc.MethodType;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractServiceDescriptor;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.Calls;
import io.grpc.stub.Method;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.Messages;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

public class TestServiceGrpc {
    private static final Method<EmptyProtos.Empty, EmptyProtos.Empty> METHOD_EMPTY_CALL = Method.create((MethodType)MethodType.UNARY, (String)"EmptyCall", (Marshaller)ProtoUtils.marshaller(EmptyProtos.Empty.PARSER), (Marshaller)ProtoUtils.marshaller(EmptyProtos.Empty.PARSER));
    private static final Method<Messages.SimpleRequest, Messages.SimpleResponse> METHOD_UNARY_CALL = Method.create((MethodType)MethodType.UNARY, (String)"UnaryCall", (Marshaller)ProtoUtils.marshaller(Messages.SimpleRequest.PARSER), (Marshaller)ProtoUtils.marshaller(Messages.SimpleResponse.PARSER));
    private static final Method<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> METHOD_STREAMING_OUTPUT_CALL = Method.create((MethodType)MethodType.SERVER_STREAMING, (String)"StreamingOutputCall", (Marshaller)ProtoUtils.marshaller(Messages.StreamingOutputCallRequest.PARSER), (Marshaller)ProtoUtils.marshaller(Messages.StreamingOutputCallResponse.PARSER));
    private static final Method<Messages.StreamingInputCallRequest, Messages.StreamingInputCallResponse> METHOD_STREAMING_INPUT_CALL = Method.create((MethodType)MethodType.CLIENT_STREAMING, (String)"StreamingInputCall", (Marshaller)ProtoUtils.marshaller(Messages.StreamingInputCallRequest.PARSER), (Marshaller)ProtoUtils.marshaller(Messages.StreamingInputCallResponse.PARSER));
    private static final Method<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> METHOD_FULL_DUPLEX_CALL = Method.create((MethodType)MethodType.DUPLEX_STREAMING, (String)"FullDuplexCall", (Marshaller)ProtoUtils.marshaller(Messages.StreamingOutputCallRequest.PARSER), (Marshaller)ProtoUtils.marshaller(Messages.StreamingOutputCallResponse.PARSER));
    private static final Method<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> METHOD_HALF_DUPLEX_CALL = Method.create((MethodType)MethodType.DUPLEX_STREAMING, (String)"HalfDuplexCall", (Marshaller)ProtoUtils.marshaller(Messages.StreamingOutputCallRequest.PARSER), (Marshaller)ProtoUtils.marshaller(Messages.StreamingOutputCallResponse.PARSER));
    public static final TestServiceServiceDescriptor CONFIG = new TestServiceServiceDescriptor();

    public static TestServiceStub newStub(Channel channel) {
        return new TestServiceStub(channel, CONFIG);
    }

    public static TestServiceBlockingStub newBlockingStub(Channel channel) {
        return new TestServiceBlockingStub(channel, CONFIG);
    }

    public static TestServiceFutureStub newFutureStub(Channel channel) {
        return new TestServiceFutureStub(channel, CONFIG);
    }

    public static ServerServiceDefinition bindService(final TestService serviceImpl) {
        return ServerServiceDefinition.builder((String)"grpc.testing.TestService").addMethod(ServerCalls.createMethodDefinition(METHOD_EMPTY_CALL, (ServerCallHandler)ServerCalls.asyncUnaryRequestCall((ServerCalls.UnaryRequestMethod)new ServerCalls.UnaryRequestMethod<EmptyProtos.Empty, EmptyProtos.Empty>(){

            public void invoke(EmptyProtos.Empty request, StreamObserver<EmptyProtos.Empty> responseObserver) {
                serviceImpl.emptyCall(request, responseObserver);
            }
        }))).addMethod(ServerCalls.createMethodDefinition(METHOD_UNARY_CALL, (ServerCallHandler)ServerCalls.asyncUnaryRequestCall((ServerCalls.UnaryRequestMethod)new ServerCalls.UnaryRequestMethod<Messages.SimpleRequest, Messages.SimpleResponse>(){

            public void invoke(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
                serviceImpl.unaryCall(request, responseObserver);
            }
        }))).addMethod(ServerCalls.createMethodDefinition(METHOD_STREAMING_OUTPUT_CALL, (ServerCallHandler)ServerCalls.asyncUnaryRequestCall((ServerCalls.UnaryRequestMethod)new ServerCalls.UnaryRequestMethod<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse>(){

            public void invoke(Messages.StreamingOutputCallRequest request, StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
                serviceImpl.streamingOutputCall(request, responseObserver);
            }
        }))).addMethod(ServerCalls.createMethodDefinition(METHOD_STREAMING_INPUT_CALL, (ServerCallHandler)ServerCalls.asyncStreamingRequestCall((ServerCalls.StreamingRequestMethod)new ServerCalls.StreamingRequestMethod<Messages.StreamingInputCallRequest, Messages.StreamingInputCallResponse>(){

            public StreamObserver<Messages.StreamingInputCallRequest> invoke(StreamObserver<Messages.StreamingInputCallResponse> responseObserver) {
                return serviceImpl.streamingInputCall(responseObserver);
            }
        }))).addMethod(ServerCalls.createMethodDefinition(METHOD_FULL_DUPLEX_CALL, (ServerCallHandler)ServerCalls.asyncStreamingRequestCall((ServerCalls.StreamingRequestMethod)new ServerCalls.StreamingRequestMethod<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse>(){

            public StreamObserver<Messages.StreamingOutputCallRequest> invoke(StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
                return serviceImpl.fullDuplexCall(responseObserver);
            }
        }))).addMethod(ServerCalls.createMethodDefinition(METHOD_HALF_DUPLEX_CALL, (ServerCallHandler)ServerCalls.asyncStreamingRequestCall((ServerCalls.StreamingRequestMethod)new ServerCalls.StreamingRequestMethod<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse>(){

            public StreamObserver<Messages.StreamingOutputCallRequest> invoke(StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
                return serviceImpl.halfDuplexCall(responseObserver);
            }
        }))).build();
    }

    public static class TestServiceFutureStub
    extends AbstractStub<TestServiceFutureStub, TestServiceServiceDescriptor>
    implements TestServiceFutureClient {
        private TestServiceFutureStub(Channel channel, TestServiceServiceDescriptor config) {
            super(channel, (AbstractServiceDescriptor)config);
        }

        protected TestServiceFutureStub build(Channel channel, TestServiceServiceDescriptor config) {
            return new TestServiceFutureStub(channel, config);
        }

        @Override
        public ListenableFuture<EmptyProtos.Empty> emptyCall(EmptyProtos.Empty request) {
            return Calls.unaryFutureCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).emptyCall), (Object)request);
        }

        @Override
        public ListenableFuture<Messages.SimpleResponse> unaryCall(Messages.SimpleRequest request) {
            return Calls.unaryFutureCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).unaryCall), (Object)request);
        }
    }

    public static class TestServiceBlockingStub
    extends AbstractStub<TestServiceBlockingStub, TestServiceServiceDescriptor>
    implements TestServiceBlockingClient {
        private TestServiceBlockingStub(Channel channel, TestServiceServiceDescriptor config) {
            super(channel, (AbstractServiceDescriptor)config);
        }

        protected TestServiceBlockingStub build(Channel channel, TestServiceServiceDescriptor config) {
            return new TestServiceBlockingStub(channel, config);
        }

        @Override
        public EmptyProtos.Empty emptyCall(EmptyProtos.Empty request) {
            return (EmptyProtos.Empty)Calls.blockingUnaryCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).emptyCall), (Object)request);
        }

        @Override
        public Messages.SimpleResponse unaryCall(Messages.SimpleRequest request) {
            return (Messages.SimpleResponse)Calls.blockingUnaryCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).unaryCall), (Object)request);
        }

        @Override
        public Iterator<Messages.StreamingOutputCallResponse> streamingOutputCall(Messages.StreamingOutputCallRequest request) {
            return Calls.blockingServerStreamingCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).streamingOutputCall), (Object)request);
        }
    }

    public static class TestServiceStub
    extends AbstractStub<TestServiceStub, TestServiceServiceDescriptor>
    implements TestService {
        private TestServiceStub(Channel channel, TestServiceServiceDescriptor config) {
            super(channel, (AbstractServiceDescriptor)config);
        }

        protected TestServiceStub build(Channel channel, TestServiceServiceDescriptor config) {
            return new TestServiceStub(channel, config);
        }

        @Override
        public void emptyCall(EmptyProtos.Empty request, StreamObserver<EmptyProtos.Empty> responseObserver) {
            Calls.asyncUnaryCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).emptyCall), (Object)request, responseObserver);
        }

        @Override
        public void unaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            Calls.asyncUnaryCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).unaryCall), (Object)request, responseObserver);
        }

        @Override
        public void streamingOutputCall(Messages.StreamingOutputCallRequest request, StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            Calls.asyncServerStreamingCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).streamingOutputCall), (Object)request, responseObserver);
        }

        @Override
        public StreamObserver<Messages.StreamingInputCallRequest> streamingInputCall(StreamObserver<Messages.StreamingInputCallResponse> responseObserver) {
            return Calls.asyncClientStreamingCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).streamingInputCall), responseObserver);
        }

        @Override
        public StreamObserver<Messages.StreamingOutputCallRequest> fullDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            return Calls.duplexStreamingCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).fullDuplexCall), responseObserver);
        }

        @Override
        public StreamObserver<Messages.StreamingOutputCallRequest> halfDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            return Calls.duplexStreamingCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).halfDuplexCall), responseObserver);
        }
    }

    public static interface TestServiceFutureClient {
        public ListenableFuture<EmptyProtos.Empty> emptyCall(EmptyProtos.Empty var1);

        public ListenableFuture<Messages.SimpleResponse> unaryCall(Messages.SimpleRequest var1);
    }

    public static interface TestServiceBlockingClient {
        public EmptyProtos.Empty emptyCall(EmptyProtos.Empty var1);

        public Messages.SimpleResponse unaryCall(Messages.SimpleRequest var1);

        public Iterator<Messages.StreamingOutputCallResponse> streamingOutputCall(Messages.StreamingOutputCallRequest var1);
    }

    public static interface TestService {
        public void emptyCall(EmptyProtos.Empty var1, StreamObserver<EmptyProtos.Empty> var2);

        public void unaryCall(Messages.SimpleRequest var1, StreamObserver<Messages.SimpleResponse> var2);

        public void streamingOutputCall(Messages.StreamingOutputCallRequest var1, StreamObserver<Messages.StreamingOutputCallResponse> var2);

        public StreamObserver<Messages.StreamingInputCallRequest> streamingInputCall(StreamObserver<Messages.StreamingInputCallResponse> var1);

        public StreamObserver<Messages.StreamingOutputCallRequest> fullDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> var1);

        public StreamObserver<Messages.StreamingOutputCallRequest> halfDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> var1);
    }

    @Immutable
    public static class TestServiceServiceDescriptor
    extends AbstractServiceDescriptor<TestServiceServiceDescriptor> {
        public final MethodDescriptor<EmptyProtos.Empty, EmptyProtos.Empty> emptyCall;
        public final MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> unaryCall;
        public final MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> streamingOutputCall;
        public final MethodDescriptor<Messages.StreamingInputCallRequest, Messages.StreamingInputCallResponse> streamingInputCall;
        public final MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> fullDuplexCall;
        public final MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> halfDuplexCall;

        private TestServiceServiceDescriptor() {
            this.emptyCall = Calls.createMethodDescriptor((String)"grpc.testing.TestService", (Method)METHOD_EMPTY_CALL);
            this.unaryCall = Calls.createMethodDescriptor((String)"grpc.testing.TestService", (Method)METHOD_UNARY_CALL);
            this.streamingOutputCall = Calls.createMethodDescriptor((String)"grpc.testing.TestService", (Method)METHOD_STREAMING_OUTPUT_CALL);
            this.streamingInputCall = Calls.createMethodDescriptor((String)"grpc.testing.TestService", (Method)METHOD_STREAMING_INPUT_CALL);
            this.fullDuplexCall = Calls.createMethodDescriptor((String)"grpc.testing.TestService", (Method)METHOD_FULL_DUPLEX_CALL);
            this.halfDuplexCall = Calls.createMethodDescriptor((String)"grpc.testing.TestService", (Method)METHOD_HALF_DUPLEX_CALL);
        }

        private TestServiceServiceDescriptor(Map<String, MethodDescriptor<?, ?>> methodMap) {
            this.emptyCall = methodMap.get(TestServiceGrpc.CONFIG.emptyCall.getName());
            this.unaryCall = methodMap.get(TestServiceGrpc.CONFIG.unaryCall.getName());
            this.streamingOutputCall = methodMap.get(TestServiceGrpc.CONFIG.streamingOutputCall.getName());
            this.streamingInputCall = methodMap.get(TestServiceGrpc.CONFIG.streamingInputCall.getName());
            this.fullDuplexCall = methodMap.get(TestServiceGrpc.CONFIG.fullDuplexCall.getName());
            this.halfDuplexCall = methodMap.get(TestServiceGrpc.CONFIG.halfDuplexCall.getName());
        }

        protected TestServiceServiceDescriptor build(Map<String, MethodDescriptor<?, ?>> methodMap) {
            return new TestServiceServiceDescriptor(methodMap);
        }

        public ImmutableList<MethodDescriptor<?, ?>> methods() {
            return ImmutableList.of(this.emptyCall, this.unaryCall, this.streamingOutputCall, this.streamingInputCall, this.fullDuplexCall, this.halfDuplexCall);
        }
    }
}

