/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.EmptyProtos;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.Messages;
import java.util.Iterator;

public class TestServiceGrpc {
    public static final String SERVICE_NAME = "grpc.testing.TestService";
    public static final MethodDescriptor<EmptyProtos.Empty, EmptyProtos.Empty> METHOD_EMPTY_CALL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.TestService", (String)"EmptyCall"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)EmptyProtos.Empty.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)EmptyProtos.Empty.getDefaultInstance()));
    public static final MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> METHOD_UNARY_CALL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.TestService", (String)"UnaryCall"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.SimpleRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.SimpleResponse.getDefaultInstance()));
    public static final MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> METHOD_STREAMING_OUTPUT_CALL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.SERVER_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.TestService", (String)"StreamingOutputCall"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.StreamingOutputCallRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.StreamingOutputCallResponse.getDefaultInstance()));
    public static final MethodDescriptor<Messages.StreamingInputCallRequest, Messages.StreamingInputCallResponse> METHOD_STREAMING_INPUT_CALL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.CLIENT_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.TestService", (String)"StreamingInputCall"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.StreamingInputCallRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.StreamingInputCallResponse.getDefaultInstance()));
    public static final MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> METHOD_FULL_DUPLEX_CALL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.TestService", (String)"FullDuplexCall"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.StreamingOutputCallRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.StreamingOutputCallResponse.getDefaultInstance()));
    public static final MethodDescriptor<Messages.StreamingOutputCallRequest, Messages.StreamingOutputCallResponse> METHOD_HALF_DUPLEX_CALL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.TestService", (String)"HalfDuplexCall"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.StreamingOutputCallRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.StreamingOutputCallResponse.getDefaultInstance()));
    private static final int METHODID_EMPTY_CALL = 0;
    private static final int METHODID_UNARY_CALL = 1;
    private static final int METHODID_STREAMING_OUTPUT_CALL = 2;
    private static final int METHODID_STREAMING_INPUT_CALL = 3;
    private static final int METHODID_FULL_DUPLEX_CALL = 4;
    private static final int METHODID_HALF_DUPLEX_CALL = 5;

    private TestServiceGrpc() {
    }

    public static TestServiceStub newStub(Channel channel) {
        return new TestServiceStub(channel);
    }

    public static TestServiceBlockingStub newBlockingStub(Channel channel) {
        return new TestServiceBlockingStub(channel);
    }

    public static TestServiceFutureStub newFutureStub(Channel channel) {
        return new TestServiceFutureStub(channel);
    }

    public static ServerServiceDefinition bindService(TestService serviceImpl) {
        return ServerServiceDefinition.builder((String)SERVICE_NAME).addMethod(METHOD_EMPTY_CALL, ServerCalls.asyncUnaryCall(new MethodHandlers(serviceImpl, 0))).addMethod(METHOD_UNARY_CALL, ServerCalls.asyncUnaryCall(new MethodHandlers(serviceImpl, 1))).addMethod(METHOD_STREAMING_OUTPUT_CALL, ServerCalls.asyncServerStreamingCall(new MethodHandlers(serviceImpl, 2))).addMethod(METHOD_STREAMING_INPUT_CALL, ServerCalls.asyncClientStreamingCall(new MethodHandlers(serviceImpl, 3))).addMethod(METHOD_FULL_DUPLEX_CALL, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(serviceImpl, 4))).addMethod(METHOD_HALF_DUPLEX_CALL, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(serviceImpl, 5))).build();
    }

    private static class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final TestService serviceImpl;
        private final int methodId;

        public MethodHandlers(TestService serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.emptyCall((EmptyProtos.Empty)request, responseObserver);
                    break;
                }
                case 1: {
                    this.serviceImpl.unaryCall((Messages.SimpleRequest)request, responseObserver);
                    break;
                }
                case 2: {
                    this.serviceImpl.streamingOutputCall((Messages.StreamingOutputCallRequest)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 3: {
                    return this.serviceImpl.streamingInputCall(responseObserver);
                }
                case 4: {
                    return this.serviceImpl.fullDuplexCall(responseObserver);
                }
                case 5: {
                    return this.serviceImpl.halfDuplexCall(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    public static class TestServiceFutureStub
    extends AbstractStub<TestServiceFutureStub>
    implements TestServiceFutureClient {
        private TestServiceFutureStub(Channel channel) {
            super(channel);
        }

        private TestServiceFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected TestServiceFutureStub build(Channel channel, CallOptions callOptions) {
            return new TestServiceFutureStub(channel, callOptions);
        }

        @Override
        public ListenableFuture<EmptyProtos.Empty> emptyCall(EmptyProtos.Empty request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_EMPTY_CALL, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<Messages.SimpleResponse> unaryCall(Messages.SimpleRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_UNARY_CALL, this.getCallOptions()), (Object)request);
        }
    }

    public static class TestServiceBlockingStub
    extends AbstractStub<TestServiceBlockingStub>
    implements TestServiceBlockingClient {
        private TestServiceBlockingStub(Channel channel) {
            super(channel);
        }

        private TestServiceBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected TestServiceBlockingStub build(Channel channel, CallOptions callOptions) {
            return new TestServiceBlockingStub(channel, callOptions);
        }

        @Override
        public EmptyProtos.Empty emptyCall(EmptyProtos.Empty request) {
            return (EmptyProtos.Empty)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_EMPTY_CALL, (CallOptions)this.getCallOptions(), (Object)request);
        }

        @Override
        public Messages.SimpleResponse unaryCall(Messages.SimpleRequest request) {
            return (Messages.SimpleResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_UNARY_CALL, (CallOptions)this.getCallOptions(), (Object)request);
        }

        @Override
        public Iterator<Messages.StreamingOutputCallResponse> streamingOutputCall(Messages.StreamingOutputCallRequest request) {
            return ClientCalls.blockingServerStreamingCall((Channel)this.getChannel(), METHOD_STREAMING_OUTPUT_CALL, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static class TestServiceStub
    extends AbstractStub<TestServiceStub>
    implements TestService {
        private TestServiceStub(Channel channel) {
            super(channel);
        }

        private TestServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected TestServiceStub build(Channel channel, CallOptions callOptions) {
            return new TestServiceStub(channel, callOptions);
        }

        @Override
        public void emptyCall(EmptyProtos.Empty request, StreamObserver<EmptyProtos.Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_EMPTY_CALL, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void unaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_UNARY_CALL, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void streamingOutputCall(Messages.StreamingOutputCallRequest request, StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            ClientCalls.asyncServerStreamingCall((ClientCall)this.getChannel().newCall(METHOD_STREAMING_OUTPUT_CALL, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public StreamObserver<Messages.StreamingInputCallRequest> streamingInputCall(StreamObserver<Messages.StreamingInputCallResponse> responseObserver) {
            return ClientCalls.asyncClientStreamingCall((ClientCall)this.getChannel().newCall(METHOD_STREAMING_INPUT_CALL, this.getCallOptions()), responseObserver);
        }

        @Override
        public StreamObserver<Messages.StreamingOutputCallRequest> fullDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(METHOD_FULL_DUPLEX_CALL, this.getCallOptions()), responseObserver);
        }

        @Override
        public StreamObserver<Messages.StreamingOutputCallRequest> halfDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(METHOD_HALF_DUPLEX_CALL, this.getCallOptions()), responseObserver);
        }
    }

    public static interface TestServiceFutureClient {
        public ListenableFuture<EmptyProtos.Empty> emptyCall(EmptyProtos.Empty var1);

        public ListenableFuture<Messages.SimpleResponse> unaryCall(Messages.SimpleRequest var1);
    }

    public static interface TestServiceBlockingClient {
        public EmptyProtos.Empty emptyCall(EmptyProtos.Empty var1);

        public Messages.SimpleResponse unaryCall(Messages.SimpleRequest var1);

        public Iterator<Messages.StreamingOutputCallResponse> streamingOutputCall(Messages.StreamingOutputCallRequest var1);
    }

    public static abstract class AbstractTestService
    implements TestService,
    BindableService {
        @Override
        public void emptyCall(EmptyProtos.Empty request, StreamObserver<EmptyProtos.Empty> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_EMPTY_CALL, responseObserver);
        }

        @Override
        public void unaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_UNARY_CALL, responseObserver);
        }

        @Override
        public void streamingOutputCall(Messages.StreamingOutputCallRequest request, StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_STREAMING_OUTPUT_CALL, responseObserver);
        }

        @Override
        public StreamObserver<Messages.StreamingInputCallRequest> streamingInputCall(StreamObserver<Messages.StreamingInputCallResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_STREAMING_INPUT_CALL, responseObserver);
        }

        @Override
        public StreamObserver<Messages.StreamingOutputCallRequest> fullDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_FULL_DUPLEX_CALL, responseObserver);
        }

        @Override
        public StreamObserver<Messages.StreamingOutputCallRequest> halfDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_HALF_DUPLEX_CALL, responseObserver);
        }

        public ServerServiceDefinition bindService() {
            return TestServiceGrpc.bindService(this);
        }
    }

    public static interface TestService {
        public void emptyCall(EmptyProtos.Empty var1, StreamObserver<EmptyProtos.Empty> var2);

        public void unaryCall(Messages.SimpleRequest var1, StreamObserver<Messages.SimpleResponse> var2);

        public void streamingOutputCall(Messages.StreamingOutputCallRequest var1, StreamObserver<Messages.StreamingOutputCallResponse> var2);

        public StreamObserver<Messages.StreamingInputCallRequest> streamingInputCall(StreamObserver<Messages.StreamingInputCallResponse> var1);

        public StreamObserver<Messages.StreamingOutputCallRequest> fullDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> var1);

        public StreamObserver<Messages.StreamingOutputCallRequest> halfDuplexCall(StreamObserver<Messages.StreamingOutputCallResponse> var1);
    }
}

