/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.Metrics;
import java.util.Iterator;

public class MetricsServiceGrpc {
    public static final String SERVICE_NAME = "grpc.testing.MetricsService";
    public static final MethodDescriptor<Metrics.EmptyMessage, Metrics.GaugeResponse> METHOD_GET_ALL_GAUGES = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.SERVER_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.MetricsService", (String)"GetAllGauges"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Metrics.EmptyMessage.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Metrics.GaugeResponse.getDefaultInstance()));
    public static final MethodDescriptor<Metrics.GaugeRequest, Metrics.GaugeResponse> METHOD_GET_GAUGE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.MetricsService", (String)"GetGauge"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Metrics.GaugeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Metrics.GaugeResponse.getDefaultInstance()));
    private static final int METHODID_GET_ALL_GAUGES = 0;
    private static final int METHODID_GET_GAUGE = 1;

    private MetricsServiceGrpc() {
    }

    public static MetricsServiceStub newStub(Channel channel) {
        return new MetricsServiceStub(channel);
    }

    public static MetricsServiceBlockingStub newBlockingStub(Channel channel) {
        return new MetricsServiceBlockingStub(channel);
    }

    public static MetricsServiceFutureStub newFutureStub(Channel channel) {
        return new MetricsServiceFutureStub(channel);
    }

    public static ServerServiceDefinition bindService(MetricsService serviceImpl) {
        return ServerServiceDefinition.builder((String)SERVICE_NAME).addMethod(METHOD_GET_ALL_GAUGES, ServerCalls.asyncServerStreamingCall(new MethodHandlers(serviceImpl, 0))).addMethod(METHOD_GET_GAUGE, ServerCalls.asyncUnaryCall(new MethodHandlers(serviceImpl, 1))).build();
    }

    private static class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final MetricsService serviceImpl;
        private final int methodId;

        public MethodHandlers(MetricsService serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.getAllGauges((Metrics.EmptyMessage)request, responseObserver);
                    break;
                }
                case 1: {
                    this.serviceImpl.getGauge((Metrics.GaugeRequest)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static class MetricsServiceFutureStub
    extends AbstractStub<MetricsServiceFutureStub>
    implements MetricsServiceFutureClient {
        private MetricsServiceFutureStub(Channel channel) {
            super(channel);
        }

        private MetricsServiceFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected MetricsServiceFutureStub build(Channel channel, CallOptions callOptions) {
            return new MetricsServiceFutureStub(channel, callOptions);
        }

        @Override
        public ListenableFuture<Metrics.GaugeResponse> getGauge(Metrics.GaugeRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_GET_GAUGE, this.getCallOptions()), (Object)request);
        }
    }

    public static class MetricsServiceBlockingStub
    extends AbstractStub<MetricsServiceBlockingStub>
    implements MetricsServiceBlockingClient {
        private MetricsServiceBlockingStub(Channel channel) {
            super(channel);
        }

        private MetricsServiceBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected MetricsServiceBlockingStub build(Channel channel, CallOptions callOptions) {
            return new MetricsServiceBlockingStub(channel, callOptions);
        }

        @Override
        public Iterator<Metrics.GaugeResponse> getAllGauges(Metrics.EmptyMessage request) {
            return ClientCalls.blockingServerStreamingCall((Channel)this.getChannel(), METHOD_GET_ALL_GAUGES, (CallOptions)this.getCallOptions(), (Object)request);
        }

        @Override
        public Metrics.GaugeResponse getGauge(Metrics.GaugeRequest request) {
            return (Metrics.GaugeResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_GET_GAUGE, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static class MetricsServiceStub
    extends AbstractStub<MetricsServiceStub>
    implements MetricsService {
        private MetricsServiceStub(Channel channel) {
            super(channel);
        }

        private MetricsServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected MetricsServiceStub build(Channel channel, CallOptions callOptions) {
            return new MetricsServiceStub(channel, callOptions);
        }

        @Override
        public void getAllGauges(Metrics.EmptyMessage request, StreamObserver<Metrics.GaugeResponse> responseObserver) {
            ClientCalls.asyncServerStreamingCall((ClientCall)this.getChannel().newCall(METHOD_GET_ALL_GAUGES, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void getGauge(Metrics.GaugeRequest request, StreamObserver<Metrics.GaugeResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_GET_GAUGE, this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static interface MetricsServiceFutureClient {
        public ListenableFuture<Metrics.GaugeResponse> getGauge(Metrics.GaugeRequest var1);
    }

    public static interface MetricsServiceBlockingClient {
        public Iterator<Metrics.GaugeResponse> getAllGauges(Metrics.EmptyMessage var1);

        public Metrics.GaugeResponse getGauge(Metrics.GaugeRequest var1);
    }

    public static abstract class AbstractMetricsService
    implements MetricsService,
    BindableService {
        @Override
        public void getAllGauges(Metrics.EmptyMessage request, StreamObserver<Metrics.GaugeResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_GET_ALL_GAUGES, responseObserver);
        }

        @Override
        public void getGauge(Metrics.GaugeRequest request, StreamObserver<Metrics.GaugeResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_GET_GAUGE, responseObserver);
        }

        public ServerServiceDefinition bindService() {
            return MetricsServiceGrpc.bindService(this);
        }
    }

    public static interface MetricsService {
        public void getAllGauges(Metrics.EmptyMessage var1, StreamObserver<Metrics.GaugeResponse> var2);

        public void getGauge(Metrics.GaugeRequest var1, StreamObserver<Metrics.GaugeResponse> var2);
    }
}

