/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.routeguide;

import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.grpc.examples.routeguide.Feature;
import io.grpc.examples.routeguide.FeatureDatabase;
import io.grpc.examples.routeguide.Point;
import io.grpc.examples.routeguide.RouteGuideServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;

public class RouteGuideUtil {
    private static final double COORD_FACTOR = 1.0E7;

    public static double getLatitude(Point location) {
        return (double)location.getLatitude() / 1.0E7;
    }

    public static double getLongitude(Point location) {
        return (double)location.getLongitude() / 1.0E7;
    }

    public static URL getDefaultFeaturesFile() {
        return RouteGuideServer.class.getResource("route_guide_db.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Feature> parseFeatures(URL file) throws IOException {
        InputStream input = file.openStream();
        try {
            List<Feature> list;
            InputStreamReader reader = new InputStreamReader(input);
            try {
                FeatureDatabase.Builder database = FeatureDatabase.newBuilder();
                JsonFormat.parser().merge((Reader)reader, (Message.Builder)database);
                list = database.getFeatureList();
            }
            catch (Throwable throwable) {
                ((Reader)reader).close();
                throw throwable;
            }
            ((Reader)reader).close();
            return list;
        }
        finally {
            input.close();
        }
    }

    public static boolean exists(Feature feature) {
        return feature != null && !feature.getName().isEmpty();
    }
}

