/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.errorhandling;

import com.google.common.base.Verify;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.Status;
import io.grpc.examples.helloworld.GreeterGrpc;
import io.grpc.examples.helloworld.HelloReply;
import io.grpc.examples.helloworld.HelloRequest;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ErrorHandlingClient {
    private Server server;
    private ManagedChannel channel;

    public static void main(String[] args) throws Exception {
        new ErrorHandlingClient().run();
    }

    void run() throws Exception {
        this.server = ServerBuilder.forPort((int)0).addService((BindableService)new GreeterGrpc.GreeterImplBase(){

            @Override
            public void sayHello(HelloRequest request, StreamObserver<HelloReply> responseObserver) {
                responseObserver.onError((Throwable)Status.INTERNAL.withDescription("Eggplant Xerxes Crybaby Overbite Narwhal").asRuntimeException());
            }
        }).build().start();
        this.channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)this.server.getPort()).usePlaintext(true).build();
        this.blockingCall();
        this.futureCallDirect();
        this.futureCallCallback();
        this.asyncCall();
        this.advancedAsyncCall();
        this.channel.shutdown();
        this.server.shutdown();
        this.channel.awaitTermination(1L, TimeUnit.SECONDS);
        this.server.awaitTermination();
    }

    void blockingCall() {
        GreeterGrpc.GreeterBlockingStub stub = GreeterGrpc.newBlockingStub((Channel)this.channel);
        try {
            stub.sayHello(HelloRequest.newBuilder().setName("Bart").build());
        }
        catch (Exception e) {
            Status status = Status.fromThrowable((Throwable)e);
            Verify.verify((status.getCode() == Status.Code.INTERNAL ? 1 : 0) != 0);
            Verify.verify((boolean)status.getDescription().contains("Eggplant"));
        }
    }

    void futureCallDirect() {
        GreeterGrpc.GreeterFutureStub stub = GreeterGrpc.newFutureStub((Channel)this.channel);
        ListenableFuture<HelloReply> response = stub.sayHello(HelloRequest.newBuilder().setName("Lisa").build());
        try {
            response.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Status status = Status.fromThrowable((Throwable)e.getCause());
            Verify.verify((status.getCode() == Status.Code.INTERNAL ? 1 : 0) != 0);
            Verify.verify((boolean)status.getDescription().contains("Xerxes"));
        }
    }

    void futureCallCallback() {
        GreeterGrpc.GreeterFutureStub stub = GreeterGrpc.newFutureStub((Channel)this.channel);
        ListenableFuture<HelloReply> response = stub.sayHello(HelloRequest.newBuilder().setName("Maggie").build());
        final CountDownLatch latch = new CountDownLatch(1);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<HelloReply>(){

            public void onSuccess(@Nullable HelloReply result) {
            }

            public void onFailure(Throwable t) {
                Status status = Status.fromThrowable((Throwable)t);
                Verify.verify((status.getCode() == Status.Code.INTERNAL ? 1 : 0) != 0);
                Verify.verify((boolean)status.getDescription().contains("Crybaby"));
                latch.countDown();
            }
        });
        if (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)1L, (TimeUnit)TimeUnit.SECONDS)) {
            throw new RuntimeException("timeout!");
        }
    }

    void asyncCall() {
        GreeterGrpc.GreeterStub stub = GreeterGrpc.newStub((Channel)this.channel);
        HelloRequest request = HelloRequest.newBuilder().setName("Homer").build();
        final CountDownLatch latch = new CountDownLatch(1);
        StreamObserver<HelloReply> responseObserver = new StreamObserver<HelloReply>(){

            public void onNext(HelloReply value) {
            }

            public void onError(Throwable t) {
                Status status = Status.fromThrowable((Throwable)t);
                Verify.verify((status.getCode() == Status.Code.INTERNAL ? 1 : 0) != 0);
                Verify.verify((boolean)status.getDescription().contains("Overbite"));
                latch.countDown();
            }

            public void onCompleted() {
            }
        };
        stub.sayHello(request, responseObserver);
        if (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)1L, (TimeUnit)TimeUnit.SECONDS)) {
            throw new RuntimeException("timeout!");
        }
    }

    void advancedAsyncCall() {
        ClientCall call = this.channel.newCall(GreeterGrpc.METHOD_SAY_HELLO, CallOptions.DEFAULT);
        final CountDownLatch latch = new CountDownLatch(1);
        call.start((ClientCall.Listener)new ClientCall.Listener<HelloReply>(){

            public void onClose(Status status, Metadata trailers) {
                Verify.verify((status.getCode() == Status.Code.INTERNAL ? 1 : 0) != 0);
                Verify.verify((boolean)status.getDescription().contains("Narwhal"));
                latch.countDown();
            }
        }, new Metadata());
        call.sendMessage((Object)HelloRequest.newBuilder().setName("Marge").build());
        call.halfClose();
        if (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)1L, (TimeUnit)TimeUnit.SECONDS)) {
            throw new RuntimeException("timeout!");
        }
    }
}

