/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.advanced;

import com.google.protobuf.Message;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import io.grpc.examples.helloworld.GreeterGrpc;
import io.grpc.examples.helloworld.HelloReply;
import io.grpc.examples.helloworld.HelloRequest;
import io.grpc.examples.helloworld.HelloWorldClient;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HelloJsonClient {
    private static final Logger logger = Logger.getLogger(HelloWorldClient.class.getName());
    private final ManagedChannel channel;
    private final HelloJsonStub blockingStub;

    public HelloJsonClient(String host, int port) {
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext(true).build();
        this.blockingStub = new HelloJsonStub((Channel)this.channel);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public void greet(String name) {
        HelloReply response;
        logger.info("Will try to greet " + name + " ...");
        HelloRequest request = HelloRequest.newBuilder().setName(name).build();
        try {
            response = this.blockingStub.sayHello(request);
        }
        catch (StatusRuntimeException e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e.getStatus());
            return;
        }
        logger.info("Greeting: " + response.getMessage());
    }

    public static void main(String[] args) throws Exception {
        HelloJsonClient client = new HelloJsonClient("localhost", 50051);
        try {
            String user = "world";
            if (args.length > 0) {
                user = args[0];
            }
            client.greet(user);
        }
        finally {
            client.shutdown();
        }
    }

    static final class HelloJsonStub
    extends AbstractStub<HelloJsonStub> {
        static final MethodDescriptor<HelloRequest, HelloReply> METHOD_SAY_HELLO = MethodDescriptor.create((MethodDescriptor.MethodType)GreeterGrpc.METHOD_SAY_HELLO.getType(), (String)GreeterGrpc.METHOD_SAY_HELLO.getFullMethodName(), (MethodDescriptor.Marshaller)ProtoUtils.jsonMarshaller((Message)HelloRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.jsonMarshaller((Message)HelloReply.getDefaultInstance()));

        protected HelloJsonStub(Channel channel) {
            super(channel);
        }

        protected HelloJsonStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected HelloJsonStub build(Channel channel, CallOptions callOptions) {
            return new HelloJsonStub(channel, callOptions);
        }

        public HelloReply sayHello(HelloRequest request) {
            return (HelloReply)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_SAY_HELLO, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }
}

