/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.Status;
import java.util.Objects;

final class FixedPickerLoadBalancerProvider
extends LoadBalancerProvider {
    private final ConnectivityState state;
    private final LoadBalancer.SubchannelPicker picker;
    private final Status acceptAddressesStatus;

    public FixedPickerLoadBalancerProvider(ConnectivityState state, LoadBalancer.SubchannelPicker picker, Status acceptAddressesStatus) {
        this.state = Objects.requireNonNull(state, "state");
        this.picker = Objects.requireNonNull(picker, "picker");
        this.acceptAddressesStatus = Objects.requireNonNull(acceptAddressesStatus, "acceptAddressesStatus");
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "fixed_picker_lb_internal";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new FixedPickerLoadBalancer(helper);
    }

    private final class FixedPickerLoadBalancer
    extends LoadBalancer {
        private final LoadBalancer.Helper helper;

        public FixedPickerLoadBalancer(LoadBalancer.Helper helper) {
            this.helper = Objects.requireNonNull(helper, "helper");
        }

        public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            this.helper.updateBalancingState(FixedPickerLoadBalancerProvider.this.state, FixedPickerLoadBalancerProvider.this.picker);
            return FixedPickerLoadBalancerProvider.this.acceptAddressesStatus;
        }

        public void handleNameResolutionError(Status error) {
            this.helper.updateBalancingState(FixedPickerLoadBalancerProvider.this.state, FixedPickerLoadBalancerProvider.this.picker);
        }

        public void shutdown() {
        }
    }
}

