/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.EquivalentAddressGroup;
import io.grpc.Status;
import io.grpc.TransportManager;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RoundRobinServerList<T> {
    private final TransportManager<T> tm;
    private final List<EquivalentAddressGroup> list;
    private final Iterator<EquivalentAddressGroup> cyclingIter;
    private final T requestDroppingTransport;

    private RoundRobinServerList(TransportManager<T> tm, List<EquivalentAddressGroup> list) {
        this.tm = tm;
        this.list = list;
        this.cyclingIter = new CycleIterator<EquivalentAddressGroup>(list);
        this.requestDroppingTransport = tm.createFailingTransport(Status.UNAVAILABLE.withDescription("Throttled by LB"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getTransportForNextServer() {
        EquivalentAddressGroup currentServer;
        Iterator<EquivalentAddressGroup> iterator = this.cyclingIter;
        synchronized (iterator) {
            currentServer = this.cyclingIter.next();
        }
        if (currentServer == null) {
            return this.requestDroppingTransport;
        }
        return this.tm.getTransport(currentServer);
    }

    @VisibleForTesting
    public List<EquivalentAddressGroup> getList() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    private static final class CycleIterator<T>
    implements Iterator<T> {
        private final List<T> list;
        private int index;

        public CycleIterator(List<T> list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return !this.list.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T val = this.list.get(this.index);
            ++this.index;
            if (this.index >= this.list.size()) {
                this.index -= this.list.size();
            }
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @NotThreadSafe
    public static class Builder<T> {
        private final List<EquivalentAddressGroup> list = new ArrayList<EquivalentAddressGroup>();
        private final TransportManager<T> tm;

        public Builder(TransportManager<T> tm) {
            this.tm = tm;
        }

        public Builder<T> addSocketAddress(@Nullable SocketAddress address) {
            this.list.add(new EquivalentAddressGroup(address));
            return this;
        }

        public Builder<T> add(EquivalentAddressGroup addresses) {
            this.list.add(addresses);
            return this;
        }

        public Builder<T> addAll(Collection<EquivalentAddressGroup> addresses) {
            this.list.addAll(addresses);
            return this;
        }

        public RoundRobinServerList<T> build() {
            return new RoundRobinServerList(this.tm, Collections.unmodifiableList(new ArrayList<EquivalentAddressGroup>(this.list)));
        }
    }
}

