/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.CallOptions;
import io.grpc.Context;
import io.grpc.LoadBalancer2;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ChannelExecutor;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.DelayedStream;
import io.grpc.internal.FailingClientStream;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.LogId;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.StatsTraceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class DelayedClientTransport2
implements ManagedClientTransport {
    private final LogId lodId = LogId.allocate(this.getClass().getName());
    private final Object lock = new Object();
    private final Executor defaultAppExecutor;
    private final ChannelExecutor channelExecutor;
    private Runnable reportTransportInUse;
    private Runnable reportTransportNotInUse;
    private Runnable reportTransportShutdown;
    private Runnable reportTransportTerminated;
    @GuardedBy(value="lock")
    private Collection<PendingStream> pendingStreams = new LinkedHashSet<PendingStream>();
    @GuardedBy(value="lock")
    private boolean shutdown;
    @Nullable
    @GuardedBy(value="lock")
    private LoadBalancer2.SubchannelPicker lastPicker;
    @GuardedBy(value="lock")
    private long lastPickerVersion;

    DelayedClientTransport2(Executor defaultAppExecutor, ChannelExecutor channelExecutor) {
        this.defaultAppExecutor = defaultAppExecutor;
        this.channelExecutor = channelExecutor;
    }

    @Override
    public final Runnable start(final ManagedClientTransport.Listener listener) {
        this.reportTransportInUse = new Runnable(){

            @Override
            public void run() {
                listener.transportInUse(true);
            }
        };
        this.reportTransportNotInUse = new Runnable(){

            @Override
            public void run() {
                listener.transportInUse(false);
            }
        };
        this.reportTransportShutdown = new Runnable(){

            @Override
            public void run() {
                listener.transportShutdown(Status.UNAVAILABLE.withDescription("Channel requested transport to shut down"));
            }
        };
        this.reportTransportTerminated = new Runnable(){

            @Override
            public void run() {
                listener.transportTerminated();
            }
        };
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, StatsTraceContext statsTraceCtx) {
        try {
            LoadBalancer2.SubchannelPicker picker = null;
            long pickerVersion = -1L;
            Object object = this.lock;
            // MONITORENTER : object
            if (!this.shutdown) {
                if (this.lastPicker == null) {
                    PendingStream pendingStream = this.createPendingStream(method, headers, callOptions, statsTraceCtx);
                    // MONITOREXIT : object
                    return pendingStream;
                }
                picker = this.lastPicker;
                pickerVersion = this.lastPickerVersion;
            }
            // MONITOREXIT : object
            if (picker != null) {
                while (true) {
                    Object object2;
                    LoadBalancer2.PickResult pickResult;
                    ClientTransport transport;
                    if ((transport = GrpcUtil.getTransportFromPickResult(pickResult = picker.pickSubchannel(callOptions.getAffinity(), headers), callOptions.isWaitForReady())) != null) {
                        object2 = transport.newStream(method, headers, callOptions, statsTraceCtx);
                        return object2;
                    }
                    object2 = this.lock;
                    // MONITORENTER : object2
                    if (this.shutdown) {
                        // MONITOREXIT : object2
                        break;
                    }
                    if (pickerVersion == this.lastPickerVersion) {
                        PendingStream pendingStream = this.createPendingStream(method, headers, callOptions, statsTraceCtx);
                        // MONITOREXIT : object2
                        return pendingStream;
                    }
                    picker = this.lastPicker;
                    pickerVersion = this.lastPickerVersion;
                    // MONITOREXIT : object2
                }
            }
            object = new FailingClientStream(Status.UNAVAILABLE.withDescription("Channel has shutdown (reported by delayed transport)"));
            return object;
        }
        finally {
            this.channelExecutor.drain();
        }
    }

    @Override
    public final ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        return this.newStream(method, headers, CallOptions.DEFAULT, StatsTraceContext.NOOP);
    }

    @GuardedBy(value="lock")
    private PendingStream createPendingStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, StatsTraceContext statsTraceCtx) {
        PendingStream pendingStream = new PendingStream(method, headers, callOptions, statsTraceCtx);
        this.pendingStreams.add(pendingStream);
        if (this.pendingStreams.size() == 1) {
            this.channelExecutor.executeLater(this.reportTransportInUse);
        }
        return pendingStream;
    }

    @Override
    public final void ping(ClientTransport.PingCallback callback, Executor executor) {
        throw new UnsupportedOperationException("This method is not expected to be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            this.channelExecutor.executeLater(this.reportTransportShutdown);
            if (this.pendingStreams == null || this.pendingStreams.isEmpty()) {
                this.pendingStreams = null;
                this.channelExecutor.executeLater(this.reportTransportTerminated);
            }
        }
        this.channelExecutor.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdownNow(Status status) {
        this.shutdown();
        Collection<PendingStream> savedPendingStreams = null;
        Iterator<PendingStream> iterator = this.lock;
        synchronized (iterator) {
            if (this.pendingStreams != null) {
                savedPendingStreams = this.pendingStreams;
                this.pendingStreams = null;
            }
        }
        if (savedPendingStreams != null) {
            for (PendingStream stream : savedPendingStreams) {
                stream.cancel(status);
            }
            this.channelExecutor.executeLater(this.reportTransportTerminated).drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasPendingStreams() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams != null && !this.pendingStreams.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final int getPendingStreamsCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams == null ? 0 : this.pendingStreams.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void reprocess(LoadBalancer2.SubchannelPicker picker) {
        ArrayList<PendingStream> toProcess;
        ArrayList<PendingStream> toRemove = new ArrayList<PendingStream>();
        Object object = this.lock;
        synchronized (object) {
            this.lastPicker = picker;
            ++this.lastPickerVersion;
            if (this.pendingStreams == null || this.pendingStreams.isEmpty()) {
                return;
            }
            toProcess = new ArrayList<PendingStream>(this.pendingStreams);
        }
        for (final PendingStream stream : toProcess) {
            LoadBalancer2.PickResult pickResult = picker.pickSubchannel(stream.callOptions.getAffinity(), stream.headers);
            final ClientTransport transport = GrpcUtil.getTransportFromPickResult(pickResult, stream.callOptions.isWaitForReady());
            if (transport == null) continue;
            Executor executor = this.defaultAppExecutor;
            if (stream.callOptions.getExecutor() != null) {
                executor = stream.callOptions.getExecutor();
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    stream.createRealStream(transport);
                }
            });
            toRemove.add(stream);
        }
        object = this.lock;
        synchronized (object) {
            if (this.pendingStreams == null || this.pendingStreams.isEmpty()) {
                return;
            }
            this.pendingStreams.removeAll(toRemove);
            if (this.pendingStreams.isEmpty()) {
                this.channelExecutor.executeLater(this.reportTransportNotInUse);
                if (this.shutdown) {
                    this.pendingStreams = null;
                    this.channelExecutor.executeLater(this.reportTransportTerminated);
                } else {
                    this.pendingStreams = new LinkedHashSet<PendingStream>();
                }
            }
        }
        this.channelExecutor.drain();
    }

    @Override
    public LogId getLogId() {
        return this.lodId;
    }

    private class PendingStream
    extends DelayedStream {
        private final MethodDescriptor<?, ?> method;
        private final Metadata headers;
        private final CallOptions callOptions;
        private final Context context;
        private final StatsTraceContext statsTraceCtx;

        private PendingStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, StatsTraceContext statsTraceCtx) {
            this.method = method;
            this.headers = headers;
            this.callOptions = callOptions;
            this.context = Context.current();
            this.statsTraceCtx = statsTraceCtx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createRealStream(ClientTransport transport) {
            ClientStream realStream;
            Context origContext = this.context.attach();
            try {
                realStream = transport.newStream(this.method, this.headers, this.callOptions, this.statsTraceCtx);
            }
            finally {
                this.context.detach(origContext);
            }
            this.setStream(realStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(Status reason) {
            super.cancel(reason);
            Object object = DelayedClientTransport2.this.lock;
            synchronized (object) {
                if (DelayedClientTransport2.this.pendingStreams != null) {
                    boolean justRemovedAnElement = DelayedClientTransport2.this.pendingStreams.remove(this);
                    if (DelayedClientTransport2.this.pendingStreams.isEmpty() && justRemovedAnElement) {
                        DelayedClientTransport2.this.channelExecutor.executeLater(DelayedClientTransport2.this.reportTransportNotInUse);
                        if (DelayedClientTransport2.this.shutdown) {
                            DelayedClientTransport2.this.pendingStreams = null;
                            DelayedClientTransport2.this.channelExecutor.executeLater(DelayedClientTransport2.this.reportTransportTerminated);
                        }
                    }
                }
            }
            DelayedClientTransport2.this.channelExecutor.drain();
        }
    }
}

