/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import io.grpc.CallOptions;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.DelayedStream;
import io.grpc.internal.FailingClientStream;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ManagedClientTransport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class DelayedClientTransport
implements ManagedClientTransport {
    private final Object lock = new Object();
    private final Executor streamCreationExecutor;
    private ManagedClientTransport.Listener listener;
    private volatile Supplier<ClientTransport> transportSupplier;
    @GuardedBy(value="lock")
    private Collection<PendingStream> pendingStreams = new LinkedHashSet<PendingStream>();
    @GuardedBy(value="lock")
    private Collection<PendingPing> pendingPings = new ArrayList<PendingPing>();
    @GuardedBy(value="lock")
    private boolean shutdown;
    @Nullable
    @GuardedBy(value="lock")
    private Status backoffStatus;

    DelayedClientTransport(Executor streamCreationExecutor) {
        this.streamCreationExecutor = streamCreationExecutor;
    }

    @Override
    public Runnable start(ManagedClientTransport.Listener listener) {
        this.listener = (ManagedClientTransport.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions) {
        Supplier<ClientTransport> supplier = this.transportSupplier;
        if (supplier == null) {
            Object object = this.lock;
            synchronized (object) {
                supplier = this.transportSupplier;
                if (supplier == null && !this.shutdown) {
                    if (this.backoffStatus != null && !callOptions.isWaitForReady()) {
                        return new FailingClientStream(this.backoffStatus);
                    }
                    PendingStream pendingStream = new PendingStream(method, headers, callOptions);
                    this.pendingStreams.add(pendingStream);
                    if (this.pendingStreams.size() == 1) {
                        this.listener.transportInUse(true);
                    }
                    return pendingStream;
                }
            }
        }
        if (supplier != null) {
            return ((ClientTransport)supplier.get()).newStream(method, headers, callOptions);
        }
        return new FailingClientStream(Status.UNAVAILABLE.withDescription("transport shutdown"));
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        return this.newStream(method, headers, CallOptions.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        Supplier<ClientTransport> supplier = this.transportSupplier;
        if (supplier == null) {
            Object object = this.lock;
            synchronized (object) {
                supplier = this.transportSupplier;
                if (supplier == null && !this.shutdown) {
                    PendingPing pendingPing = new PendingPing(callback, executor);
                    this.pendingPings.add(pendingPing);
                    return;
                }
            }
        }
        if (supplier != null) {
            ((ClientTransport)supplier.get()).ping(callback, executor);
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(Status.UNAVAILABLE.withDescription("transport shutdown").asException());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            this.listener.transportShutdown(Status.UNAVAILABLE.withDescription("Channel requested transport to shut down"));
            if (this.pendingStreams == null || this.pendingStreams.isEmpty()) {
                this.pendingStreams = null;
                this.listener.transportTerminated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNow(Status status) {
        this.shutdown();
        Collection<PendingStream> savedPendingStreams = null;
        Iterator<PendingStream> iterator = this.lock;
        synchronized (iterator) {
            if (this.pendingStreams != null) {
                savedPendingStreams = this.pendingStreams;
                this.pendingStreams = null;
            }
        }
        if (savedPendingStreams != null) {
            for (PendingStream stream : savedPendingStreams) {
                stream.cancel(status);
            }
            this.listener.transportTerminated();
        }
    }

    public void setTransport(ClientTransport transport) {
        Preconditions.checkArgument((this != transport ? 1 : 0) != 0, (Object)"delayed transport calling setTransport on itself");
        this.setTransportSupplier((Supplier<ClientTransport>)Suppliers.ofInstance((Object)transport));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransportSupplier(final Supplier<ClientTransport> supplier) {
        Object object = this.lock;
        synchronized (object) {
            if (this.transportSupplier != null) {
                return;
            }
            Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"start() not called");
            this.transportSupplier = (Supplier)Preconditions.checkNotNull(supplier, (Object)"supplier");
            for (PendingPing ping : this.pendingPings) {
                ping.createRealPing((ClientTransport)supplier.get());
            }
            this.pendingPings = null;
            if (this.shutdown && this.pendingStreams != null) {
                this.listener.transportTerminated();
            }
            if (this.pendingStreams != null && !this.pendingStreams.isEmpty()) {
                final Collection<PendingStream> savedPendingStreams = this.pendingStreams;
                this.streamCreationExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        for (PendingStream stream : savedPendingStreams) {
                            stream.createRealStream((ClientTransport)supplier.get());
                        }
                        Object object = DelayedClientTransport.this.lock;
                        synchronized (object) {
                            DelayedClientTransport.this.listener.transportInUse(false);
                        }
                    }
                });
            }
            this.pendingStreams = null;
            if (!this.shutdown) {
                this.listener.transportReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingStreams() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams != null && !this.pendingStreams.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getPendingStreamsCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams == null ? 0 : this.pendingStreams.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isInBackoffPeriod() {
        Object object = this.lock;
        synchronized (object) {
            return this.backoffStatus != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startBackoff(final Status status) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            Preconditions.checkState((this.backoffStatus == null ? 1 : 0) != 0, (Object)"Error when calling startBackoff: transport is already in backoff period");
            this.backoffStatus = Status.UNAVAILABLE.withDescription("Channel in TRANSIENT_FAILURE state").withCause(status.asRuntimeException());
            final ArrayList<PendingStream> failFastPendingStreams = new ArrayList<PendingStream>();
            if (this.pendingStreams != null && !this.pendingStreams.isEmpty()) {
                Iterator<PendingStream> it = this.pendingStreams.iterator();
                while (it.hasNext()) {
                    PendingStream stream = it.next();
                    if (stream.callOptions.isWaitForReady()) continue;
                    failFastPendingStreams.add(stream);
                    it.remove();
                }
                class FailTheFailFastPendingStreams
                implements Runnable {
                    FailTheFailFastPendingStreams() {
                    }

                    @Override
                    public void run() {
                        for (PendingStream stream : failFastPendingStreams) {
                            stream.setStream(new FailingClientStream(status));
                        }
                    }
                }
                this.streamCreationExecutor.execute(new FailTheFailFastPendingStreams());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endBackoff() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.backoffStatus != null ? 1 : 0) != 0, (Object)"Error when calling endBackoff: transport is not in backoff period");
            this.backoffStatus = null;
        }
    }

    @Override
    public String getLogId() {
        return GrpcUtil.getLogId(this);
    }

    @Nullable
    @VisibleForTesting
    Supplier<ClientTransport> getTransportSupplier() {
        return this.transportSupplier;
    }

    private static class PendingPing {
        private final ClientTransport.PingCallback callback;
        private final Executor executor;

        public PendingPing(ClientTransport.PingCallback callback, Executor executor) {
            this.callback = callback;
            this.executor = executor;
        }

        public void createRealPing(ClientTransport transport) {
            try {
                transport.ping(this.callback, this.executor);
            }
            catch (UnsupportedOperationException ex) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        PendingPing.this.callback.onFailure(ex);
                    }
                });
            }
        }
    }

    private class PendingStream
    extends DelayedStream {
        private final MethodDescriptor<?, ?> method;
        private final Metadata headers;
        private final CallOptions callOptions;

        private PendingStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions) {
            this.method = method;
            this.headers = headers;
            this.callOptions = callOptions;
        }

        private void createRealStream(ClientTransport transport) {
            this.setStream(transport.newStream(this.method, this.headers, this.callOptions));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(Status reason) {
            super.cancel(reason);
            Object object = DelayedClientTransport.this.lock;
            synchronized (object) {
                if (DelayedClientTransport.this.pendingStreams != null) {
                    boolean justRemovedAnElement = DelayedClientTransport.this.pendingStreams.remove(this);
                    if (DelayedClientTransport.this.pendingStreams.isEmpty() && justRemovedAnElement) {
                        DelayedClientTransport.this.listener.transportInUse(false);
                        if (DelayedClientTransport.this.shutdown) {
                            DelayedClientTransport.this.pendingStreams = null;
                            DelayedClientTransport.this.listener.transportTerminated();
                        }
                    }
                }
            }
        }
    }
}

