/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.Decompressor;
import io.grpc.internal.MessageDeframer;
import io.grpc.internal.MessageFramer;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.Stream;
import io.grpc.internal.StreamListener;
import java.io.InputStream;
import javax.annotation.concurrent.GuardedBy;

public abstract class AbstractStream2
implements Stream {
    protected abstract MessageFramer framer();

    protected abstract TransportState transportState();

    @Override
    public final void setMessageCompression(boolean enable) {
        this.framer().setMessageCompression(enable);
    }

    @Override
    public final void writeMessage(InputStream message) {
        Preconditions.checkNotNull((Object)message);
        if (!this.framer().isClosed()) {
            this.framer().writePayload(message);
        }
    }

    @Override
    public final void flush() {
        if (!this.framer().isClosed()) {
            this.framer().flush();
        }
    }

    protected final void endOfMessages() {
        this.framer().close();
    }

    @Override
    public final void setCompressor(Compressor compressor) {
        this.framer().setCompressor((Compressor)Preconditions.checkNotNull((Object)compressor, (Object)"compressor"));
    }

    @Override
    public final void setDecompressor(Decompressor decompressor) {
        this.transportState().setDecompressor((Decompressor)Preconditions.checkNotNull((Object)decompressor, (Object)"decompressor"));
    }

    @Override
    public final boolean isReady() {
        if (this.framer().isClosed()) {
            return false;
        }
        return this.transportState().isReady();
    }

    protected final void onSendingBytes(int numBytes) {
        this.transportState().onSendingBytes(numBytes);
    }

    public static abstract class TransportState
    implements MessageDeframer.Listener {
        private static final int DEFAULT_ONREADY_THRESHOLD = 32768;
        private final MessageDeframer deframer;
        private final Object onReadyLock = new Object();
        @GuardedBy(value="onReadyLock")
        private int numSentBytesQueued;
        @GuardedBy(value="onReadyLock")
        private boolean allocated;

        protected TransportState(int maxMessageSize) {
            this.deframer = new MessageDeframer(this, Codec.Identity.NONE, maxMessageSize);
        }

        @VisibleForTesting
        TransportState(MessageDeframer deframer) {
            this.deframer = deframer;
        }

        protected abstract StreamListener listener();

        @Override
        public void messageRead(InputStream is) {
            this.listener().messageRead(is);
        }

        protected abstract void deframeFailed(Throwable var1);

        protected final void closeDeframer() {
            this.deframer.close();
        }

        protected final void deframe(ReadableBuffer frame, boolean endOfStream) {
            if (this.deframer.isClosed()) {
                frame.close();
                return;
            }
            try {
                this.deframer.deframe(frame, endOfStream);
            }
            catch (Throwable t) {
                this.deframeFailed(t);
            }
        }

        public final void requestMessagesFromDeframer(int numMessages) {
            if (this.deframer.isClosed()) {
                return;
            }
            try {
                this.deframer.request(numMessages);
            }
            catch (Throwable t) {
                this.deframeFailed(t);
            }
        }

        private void setDecompressor(Decompressor decompressor) {
            if (this.deframer.isClosed()) {
                return;
            }
            this.deframer.setDecompressor(decompressor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isReady() {
            Object object = this.onReadyLock;
            synchronized (object) {
                return this.allocated && this.numSentBytesQueued < 32768;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onStreamAllocated() {
            Preconditions.checkState((this.listener() != null ? 1 : 0) != 0);
            Object object = this.onReadyLock;
            synchronized (object) {
                Preconditions.checkState((!this.allocated ? 1 : 0) != 0, (Object)"Already allocated");
                this.allocated = true;
            }
            this.notifyIfReady();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onSendingBytes(int numBytes) {
            Object object = this.onReadyLock;
            synchronized (object) {
                this.numSentBytesQueued += numBytes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onSentBytes(int numBytes) {
            boolean doNotify;
            Object object = this.onReadyLock;
            synchronized (object) {
                boolean belowThresholdBefore = this.numSentBytesQueued < 32768;
                this.numSentBytesQueued -= numBytes;
                boolean belowThresholdAfter = this.numSentBytesQueued < 32768;
                doNotify = !belowThresholdBefore && belowThresholdAfter;
            }
            if (doNotify) {
                this.notifyIfReady();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyIfReady() {
            boolean doNotify;
            Object object = this.onReadyLock;
            synchronized (object) {
                doNotify = this.isReady();
            }
            if (doNotify) {
                this.listener().onReady();
            }
        }
    }
}

