/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import com.google.common.base.Preconditions;
import io.grpc.inprocess.InProcessSocketAddress;
import io.grpc.inprocess.InProcessTransport;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import java.net.SocketAddress;

public class InProcessChannelBuilder
extends AbstractManagedChannelImplBuilder<InProcessChannelBuilder> {
    private final String name;

    public static InProcessChannelBuilder forName(String name) {
        return new InProcessChannelBuilder(name);
    }

    private InProcessChannelBuilder(String name) {
        super(new InProcessSocketAddress(name), "localhost");
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @Override
    public InProcessChannelBuilder usePlaintext(boolean skipNegotiation) {
        return this;
    }

    @Override
    protected ClientTransportFactory buildTransportFactory() {
        return new InProcessClientTransportFactory(this.name);
    }

    static final class InProcessClientTransportFactory
    implements ClientTransportFactory {
        private final String name;
        private boolean closed;

        private InProcessClientTransportFactory(String name) {
            this.name = name;
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress addr, String authority, String userAgent) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            return new InProcessTransport(this.name);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

