/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Status {
    private static final List<Status> STATUS_LIST = Status.buildStatusList();
    public static final Status OK = Code.OK.toStatus();
    public static final Status CANCELLED = Code.CANCELLED.toStatus();
    public static final Status UNKNOWN = Code.UNKNOWN.toStatus();
    public static final Status INVALID_ARGUMENT = Code.INVALID_ARGUMENT.toStatus();
    public static final Status DEADLINE_EXCEEDED = Code.DEADLINE_EXCEEDED.toStatus();
    public static final Status NOT_FOUND = Code.NOT_FOUND.toStatus();
    public static final Status ALREADY_EXISTS = Code.ALREADY_EXISTS.toStatus();
    public static final Status PERMISSION_DENIED = Code.PERMISSION_DENIED.toStatus();
    public static final Status UNAUTHENTICATED = Code.UNAUTHENTICATED.toStatus();
    public static final Status RESOURCE_EXHAUSTED = Code.RESOURCE_EXHAUSTED.toStatus();
    public static final Status FAILED_PRECONDITION = Code.FAILED_PRECONDITION.toStatus();
    public static final Status ABORTED = Code.ABORTED.toStatus();
    public static final Status OUT_OF_RANGE = Code.OUT_OF_RANGE.toStatus();
    public static final Status UNIMPLEMENTED = Code.UNIMPLEMENTED.toStatus();
    public static final Status INTERNAL = Code.INTERNAL.toStatus();
    public static final Status UNAVAILABLE = Code.UNAVAILABLE.toStatus();
    public static final Status DATA_LOSS = Code.DATA_LOSS.toStatus();
    public static final Metadata.Key<Status> CODE_KEY = Metadata.Key.of("grpc-status", new StatusCodeMarshaller());
    private static final Metadata.AsciiMarshaller<String> STATUS_MESSAGE_MARSHALLER = new Metadata.AsciiMarshaller<String>(){

        @Override
        public String toAsciiString(String value) {
            StringBuilder sb = new StringBuilder(value.length());
            for (byte b : value.getBytes(Charset.forName("UTF-8"))) {
                if (b >= 32 && b < 37 || b > 37 && b < 126) {
                    sb.append((char)b);
                    continue;
                }
                sb.append(String.format("%%%02X", b));
            }
            return sb.toString();
        }

        @Override
        public String parseAsciiString(String value) {
            Charset transerEncoding = Charset.forName("US-ASCII");
            byte[] source = value.getBytes(transerEncoding);
            ByteBuffer buf = ByteBuffer.allocate(source.length);
            int i = 0;
            while (i < source.length) {
                if (source[i] == 37 && i + 2 < source.length) {
                    try {
                        buf.put((byte)Integer.parseInt(new String(source, i + 1, 2, transerEncoding), 16));
                        i += 3;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                buf.put(source[i]);
                ++i;
            }
            return new String(buf.array(), 0, buf.position(), Charset.forName("UTF-8"));
        }
    };
    public static final Metadata.Key<String> MESSAGE_KEY = Metadata.Key.of("grpc-message", STATUS_MESSAGE_MARSHALLER);
    private final Code code;
    private final String description;
    private final Throwable cause;

    private static List<Status> buildStatusList() {
        TreeMap<Integer, Status> canonicalizer = new TreeMap<Integer, Status>();
        for (Code code : Code.values()) {
            Status replaced = canonicalizer.put(code.value(), new Status(code));
            if (replaced == null) continue;
            throw new IllegalStateException("Code value duplication between " + replaced.getCode().name() + " & " + code.name());
        }
        return Collections.unmodifiableList(new ArrayList(canonicalizer.values()));
    }

    public static Status fromCodeValue(int codeValue) {
        if (codeValue < 0 || codeValue > STATUS_LIST.size()) {
            return UNKNOWN.withDescription("Unknown code " + codeValue);
        }
        return STATUS_LIST.get(codeValue);
    }

    public static Status fromCode(Code code) {
        return code.toStatus();
    }

    public static Status fromThrowable(Throwable t) {
        for (Throwable cause = (Throwable)Preconditions.checkNotNull((Object)t); cause != null; cause = cause.getCause()) {
            if (cause instanceof StatusException) {
                return ((StatusException)cause).getStatus();
            }
            if (!(cause instanceof StatusRuntimeException)) continue;
            return ((StatusRuntimeException)cause).getStatus();
        }
        return UNKNOWN.withCause(t);
    }

    public static Metadata trailersFromThrowable(Throwable t) {
        for (Throwable cause = (Throwable)Preconditions.checkNotNull((Object)t); cause != null; cause = cause.getCause()) {
            if (cause instanceof StatusException) {
                return ((StatusException)cause).getTrailers();
            }
            if (!(cause instanceof StatusRuntimeException)) continue;
            return ((StatusRuntimeException)cause).getTrailers();
        }
        return null;
    }

    static String formatThrowableMessage(Status status) {
        if (status.description == null) {
            return status.code.toString();
        }
        return (Object)((Object)status.code) + ": " + status.description;
    }

    private Status(Code code) {
        this(code, null, null);
    }

    private Status(Code code, @Nullable String description, @Nullable Throwable cause) {
        this.code = (Code)((Object)Preconditions.checkNotNull((Object)((Object)code)));
        this.description = description;
        this.cause = cause;
    }

    public Status withCause(Throwable cause) {
        if (Objects.equal((Object)this.cause, (Object)cause)) {
            return this;
        }
        return new Status(this.code, this.description, cause);
    }

    public Status withDescription(String description) {
        if (Objects.equal((Object)this.description, (Object)description)) {
            return this;
        }
        return new Status(this.code, description, this.cause);
    }

    public Status augmentDescription(String additionalDetail) {
        if (additionalDetail == null) {
            return this;
        }
        if (this.description == null) {
            return new Status(this.code, additionalDetail, this.cause);
        }
        return new Status(this.code, this.description + "\n" + additionalDetail, this.cause);
    }

    public Code getCode() {
        return this.code;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Throwable getCause() {
        return this.cause;
    }

    public boolean isOk() {
        return Code.OK == this.code;
    }

    public StatusRuntimeException asRuntimeException() {
        return new StatusRuntimeException(this);
    }

    public StatusRuntimeException asRuntimeException(Metadata trailers) {
        return new StatusRuntimeException(this, trailers);
    }

    public StatusException asException() {
        return new StatusException(this);
    }

    public StatusException asException(Metadata trailers) {
        return new StatusException(this, trailers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("code", (Object)this.code.name()).add("description", (Object)this.description).add("cause", (Object)this.cause).toString();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static class StatusCodeMarshaller
    implements Metadata.AsciiMarshaller<Status> {
        private StatusCodeMarshaller() {
        }

        @Override
        public String toAsciiString(Status status) {
            return status.getCode().valueAscii();
        }

        @Override
        public Status parseAsciiString(String serialized) {
            return Status.fromCodeValue(Integer.valueOf(serialized));
        }
    }

    public static enum Code {
        OK(0),
        CANCELLED(1),
        UNKNOWN(2),
        INVALID_ARGUMENT(3),
        DEADLINE_EXCEEDED(4),
        NOT_FOUND(5),
        ALREADY_EXISTS(6),
        PERMISSION_DENIED(7),
        RESOURCE_EXHAUSTED(8),
        FAILED_PRECONDITION(9),
        ABORTED(10),
        OUT_OF_RANGE(11),
        UNIMPLEMENTED(12),
        INTERNAL(13),
        UNAVAILABLE(14),
        DATA_LOSS(15),
        UNAUTHENTICATED(16);

        private final int value;
        private final String valueAscii;

        private Code(int value) {
            this.value = value;
            this.valueAscii = Integer.toString(value);
        }

        public int value() {
            return this.value;
        }

        public Status toStatus() {
            return (Status)STATUS_LIST.get(this.value);
        }

        private String valueAscii() {
            return this.valueAscii;
        }
    }
}

