/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.internal.SharedResourceHolder;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class Context {
    private static final Logger LOG = Logger.getLogger(Context.class.getName());
    static final SharedResourceHolder.Resource<ScheduledExecutorService> SCHEDULER = new SharedResourceHolder.Resource<ScheduledExecutorService>(){
        private static final String name = "context-scheduler";

        @Override
        public ScheduledExecutorService create() {
            return Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("context-scheduler-%d").setDaemon(true).build());
        }

        @Override
        public void close(ScheduledExecutorService instance) {
            instance.shutdown();
        }

        public String toString() {
            return name;
        }
    };
    private static final ThreadLocal<ArrayDeque<Context>> contextStack = new ThreadLocal<ArrayDeque<Context>>(){

        @Override
        protected ArrayDeque<Context> initialValue() {
            return new ArrayDeque<Context>();
        }
    };
    private static final Object[][] EMPTY_ENTRIES = new Object[0][2];
    public static final Context ROOT = new Context(null);
    private final Context parent;
    private final Object[][] keyValueEntries;
    private final boolean cascadesCancellation;
    private ArrayList<ExecutableListener> listeners;
    private CancellationListener parentListener = new CancellationListener(){

        @Override
        public void cancelled(Context context) {
            if (Context.this instanceof CancellableContext) {
                ((CancellableContext)Context.this).cancel(context.cause());
            } else {
                Context.this.notifyAndClearListeners();
            }
        }
    };

    public static <T> Key<T> key(String name) {
        return new Key(name);
    }

    public static <T> Key<T> keyWithDefault(String name, T defaultValue) {
        return new Key<T>(name, defaultValue);
    }

    public static Context current() {
        ArrayDeque<Context> stack = contextStack.get();
        if (stack.isEmpty()) {
            return ROOT;
        }
        return stack.peekLast();
    }

    private Context(Context parent) {
        this.parent = parent;
        this.keyValueEntries = EMPTY_ENTRIES;
        this.cascadesCancellation = false;
    }

    private Context(Context parent, Object[][] keyValueEntries) {
        this.parent = parent;
        this.keyValueEntries = keyValueEntries;
        this.cascadesCancellation = true;
    }

    public CancellableContext withCancellation() {
        return new CancellableContext(this);
    }

    public CancellableContext withDeadlineNanoTime(long deadlineNanoTime) {
        return this.withDeadlineAfter(deadlineNanoTime - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    public CancellableContext withDeadlineAfter(long duration, TimeUnit unit) {
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (Object)"duration must be greater than or equal to 0");
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit");
        return new CancellableContext(this, unit.toNanos(duration));
    }

    public <V> Context withValue(Key<V> k1, V v1) {
        return new Context(this, new Object[][]{{k1, v1}});
    }

    public <V1, V2> Context withValues(Key<V1> k1, V1 v1, Key<V2> k2, V2 v2) {
        return new Context(this, new Object[][]{{k1, v1}, {k2, v2}});
    }

    public <V1, V2, V3> Context withValues(Key<V1> k1, V1 v1, Key<V2> k2, V2 v2, Key<V3> k3, V3 v3) {
        return new Context(this, new Object[][]{{k1, v1}, {k2, v2}, {k3, v3}});
    }

    public CancellableContext fork() {
        return new Context(this).withCancellation();
    }

    boolean canBeCancelled() {
        return this.cascadesCancellation && this.parent != null && this.parent.canBeCancelled();
    }

    public void attach() {
        contextStack.get().addLast(this);
    }

    boolean isCurrent() {
        return Context.current() == this;
    }

    public void detach() {
        ArrayDeque<Context> stack = contextStack.get();
        if (stack.isEmpty()) {
            if (this == ROOT) {
                throw new IllegalStateException("Cannot detach root");
            }
            throw new IllegalStateException("Cannot detach non-root context when root is current");
        }
        if (stack.peekLast() != this) {
            throw new IllegalStateException("Cannot detach a context that is not current");
        }
        stack.removeLast();
    }

    public boolean isCancelled() {
        if (this.parent == null || !this.cascadesCancellation) {
            return false;
        }
        return this.parent.isCancelled();
    }

    @Nullable
    public Throwable cause() {
        if (this.parent == null || !this.cascadesCancellation) {
            return null;
        }
        return this.parent.cause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(CancellationListener cancellationListener, Executor executor) {
        Preconditions.checkNotNull((Object)cancellationListener);
        Preconditions.checkNotNull((Object)executor);
        if (this.canBeCancelled()) {
            ExecutableListener executableListener = new ExecutableListener(executor, cancellationListener);
            Context context = this;
            synchronized (context) {
                if (this.isCancelled()) {
                    executableListener.deliver();
                } else if (this.listeners == null) {
                    this.listeners = new ArrayList();
                    this.listeners.add(executableListener);
                    this.parent.addListener(this.parentListener, MoreExecutors.directExecutor());
                } else {
                    this.listeners.add(executableListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(CancellationListener cancellationListener) {
        Context context = this;
        synchronized (context) {
            if (this.listeners != null) {
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    if (this.listeners.get(i).listener != cancellationListener) continue;
                    this.listeners.remove(i);
                    break;
                }
                if (this.listeners.isEmpty()) {
                    this.parent.removeListener(this.parentListener);
                    this.listeners = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAndClearListeners() {
        ArrayList<ExecutableListener> tmpListeners;
        Context context = this;
        synchronized (context) {
            if (this.listeners == null) {
                return;
            }
            tmpListeners = this.listeners;
            this.listeners = null;
        }
        for (int i = 0; i < tmpListeners.size(); ++i) {
            try {
                tmpListeners.get(i).deliver();
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.INFO, "Exception notifying context listener", t);
            }
        }
        this.parent.removeListener(this.parentListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int listenerCount() {
        Context context = this;
        synchronized (context) {
            return this.listeners == null ? 0 : this.listeners.size();
        }
    }

    public Runnable wrap(final Runnable r) {
        return new Runnable(){

            @Override
            public void run() {
                Context.this.attach();
                try {
                    r.run();
                }
                finally {
                    Context.this.detach();
                }
            }
        };
    }

    public <C> Callable<C> wrap(final Callable<C> c) {
        return new Callable<C>(){

            @Override
            public C call() throws Exception {
                Context.this.attach();
                try {
                    Object v = c.call();
                    return v;
                }
                finally {
                    Context.this.detach();
                }
            }
        };
    }

    private Object lookup(Key<?> key) {
        for (int i = 0; i < this.keyValueEntries.length; ++i) {
            if (!key.equals(this.keyValueEntries[i][0])) continue;
            return this.keyValueEntries[i][1];
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.lookup(key);
    }

    private class ExecutableListener
    implements Runnable {
        private final Executor executor;
        private final CancellationListener listener;

        private ExecutableListener(Executor executor, CancellationListener listener) {
            this.executor = executor;
            this.listener = listener;
        }

        private void deliver() {
            this.executor.execute(this);
        }

        @Override
        public void run() {
            this.listener.cancelled(Context.this);
        }
    }

    public static class Key<T> {
        private final String name;
        private final T defaultValue;

        Key(String name) {
            this(name, null);
        }

        Key(String name, T defaultValue) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.defaultValue = defaultValue;
        }

        public T get() {
            return this.get(Context.current());
        }

        public T get(Context context) {
            Object value = context.lookup(this);
            return (T)(value == null ? this.defaultValue : value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return key.name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static interface CancellationListener {
        public void cancelled(Context var1);
    }

    public static final class CancellableContext
    extends Context {
        private boolean cancelled;
        private Throwable cause;
        private final Context dummy = new Context(this, Context.access$500());
        private ScheduledFuture<?> scheduledFuture;

        private CancellableContext(Context parent) {
            super(parent, EMPTY_ENTRIES);
        }

        private CancellableContext(Context parent, long delayNanos) {
            this(parent);
            final ScheduledExecutorService scheduler = (ScheduledExecutorService)SharedResourceHolder.get(SCHEDULER);
            scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        CancellableContext.this.cancel(new TimeoutException("context timed out"));
                    }
                    finally {
                        SharedResourceHolder.release(SCHEDULER, scheduler);
                    }
                }
            }, delayNanos, TimeUnit.NANOSECONDS);
        }

        @Override
        public void attach() {
            this.dummy.attach();
        }

        @Override
        public void detach() {
            this.dummy.detach();
        }

        @Override
        public boolean isCurrent() {
            return this.dummy.isCurrent();
        }

        public Closeable attachAsCloseable() {
            this.attach();
            return new Closeable(){

                @Override
                public void close() throws IOException {
                    CancellableContext.this.detachAndCancel(null);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(@Nullable Throwable cause) {
            boolean triggeredCancel = false;
            CancellableContext cancellableContext = this;
            synchronized (cancellableContext) {
                if (!this.cancelled) {
                    this.cancelled = true;
                    if (this.scheduledFuture != null) {
                        this.scheduledFuture.cancel(false);
                        this.scheduledFuture = null;
                    }
                    this.cause = cause;
                    triggeredCancel = true;
                }
            }
            if (triggeredCancel) {
                this.notifyAndClearListeners();
            }
            return triggeredCancel;
        }

        public void detachAndCancel(@Nullable Throwable cause) {
            try {
                this.detach();
            }
            finally {
                this.cancel(cause);
            }
        }

        @Override
        protected boolean canBeCancelled() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            CancellableContext cancellableContext = this;
            synchronized (cancellableContext) {
                if (this.cancelled) {
                    return true;
                }
            }
            if (super.isCancelled()) {
                this.cancel(super.cause());
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Throwable cause() {
            if (this.isCancelled()) {
                return this.cause;
            }
            return null;
        }
    }
}

