/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import java.util.Arrays;
import java.util.List;

public class ServerInterceptors {
    private ServerInterceptors() {
    }

    public static ServerServiceDefinition intercept(ServerServiceDefinition serviceDef, ServerInterceptor ... interceptors) {
        return ServerInterceptors.intercept(serviceDef, Arrays.asList(interceptors));
    }

    public static ServerServiceDefinition intercept(ServerServiceDefinition serviceDef, List<? extends ServerInterceptor> interceptors) {
        Preconditions.checkNotNull((Object)serviceDef);
        if (interceptors.isEmpty()) {
            return serviceDef;
        }
        ServerServiceDefinition.Builder serviceDefBuilder = ServerServiceDefinition.builder(serviceDef.getName());
        for (ServerMethodDefinition<?, ?> method : serviceDef.getMethods()) {
            ServerInterceptors.wrapAndAddMethod(serviceDefBuilder, method, interceptors);
        }
        return serviceDefBuilder.build();
    }

    private static <ReqT, RespT> void wrapAndAddMethod(ServerServiceDefinition.Builder serviceDefBuilder, ServerMethodDefinition<ReqT, RespT> method, List<? extends ServerInterceptor> interceptors) {
        ServerCallHandler<ReqT, RespT> callHandler = method.getServerCallHandler();
        for (ServerInterceptor serverInterceptor : interceptors) {
            callHandler = InterceptCallHandler.create(serverInterceptor, callHandler);
        }
        serviceDefBuilder.addMethod(method.withServerCallHandler(callHandler));
    }

    private static class InterceptCallHandler<ReqT, RespT>
    implements ServerCallHandler<ReqT, RespT> {
        private final ServerInterceptor interceptor;
        private final ServerCallHandler<ReqT, RespT> callHandler;

        public static <ReqT, RespT> InterceptCallHandler<ReqT, RespT> create(ServerInterceptor interceptor, ServerCallHandler<ReqT, RespT> callHandler) {
            return new InterceptCallHandler<ReqT, RespT>(interceptor, callHandler);
        }

        private InterceptCallHandler(ServerInterceptor interceptor, ServerCallHandler<ReqT, RespT> callHandler) {
            this.interceptor = (ServerInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"interceptor");
            this.callHandler = callHandler;
        }

        @Override
        public ServerCall.Listener<ReqT> startCall(MethodDescriptor<ReqT, RespT> method, ServerCall<RespT> call, Metadata.Headers headers) {
            return this.interceptor.interceptCall(method, call, headers, this.callHandler);
        }
    }
}

