/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import io.grpc.ChannelImpl;
import io.grpc.HandlerRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerMethodDefinition;
import io.grpc.Status;
import io.grpc.internal.SerializingExecutor;
import io.grpc.internal.Server;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.SharedResourceHolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ServerImpl
extends io.grpc.Server {
    private static final ServerStreamListener NOOP_LISTENER = new NoopListener();
    private static final Future<?> DEFAULT_TIMEOUT_FUTURE = Futures.immediateCancelledFuture();
    private final Executor executor;
    private final HandlerRegistry registry;
    private boolean started;
    private boolean shutdown;
    private boolean terminated;
    private Runnable terminationRunnable;
    private final Server transportServer;
    private final Object lock = new Object();
    private boolean transportServerTerminated;
    private final Collection<ServerTransport> transports = new HashSet<ServerTransport>();
    private final ScheduledExecutorService timeoutService = SharedResourceHolder.get(ChannelImpl.TIMER_SERVICE);

    public ServerImpl(Executor executor, HandlerRegistry registry, Server transportServer) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.registry = (HandlerRegistry)Preconditions.checkNotNull((Object)registry, (Object)"registry");
        this.transportServer = (Server)Preconditions.checkNotNull((Object)transportServer, (Object)"transportServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTerminationRunnable(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            this.terminationRunnable = runnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerImpl start() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            this.transportServer.start(new ServerListenerImpl());
            this.started = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerImpl shutdown() {
        boolean shutdownTransportServer;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return this;
            }
            this.shutdown = true;
            shutdownTransportServer = this.started;
            if (!shutdownTransportServer) {
                this.transportServerTerminated = true;
                this.checkForTermination();
            }
        }
        if (shutdownTransportServer) {
            this.transportServer.shutdown();
        }
        SharedResourceHolder.release(ChannelImpl.TIMER_SERVICE, this.timeoutService);
        return this;
    }

    public ServerImpl shutdownNow() {
        this.shutdown();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            long timeoutNanos = unit.toNanos(timeout);
            long endTimeNanos = System.nanoTime() + timeoutNanos;
            while (!this.terminated && (timeoutNanos = endTimeNanos - System.nanoTime()) > 0L) {
                TimeUnit.NANOSECONDS.timedWait(this.lock, timeoutNanos);
            }
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitTermination() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.terminated) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.lock;
        synchronized (object) {
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transportClosed(ServerTransport transport) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.transports.remove(transport)) {
                throw new AssertionError((Object)"Transport already removed");
            }
            this.checkForTermination();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForTermination() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown && this.transports.isEmpty() && this.transportServerTerminated) {
                if (this.terminated) {
                    throw new AssertionError((Object)"Server already terminated");
                }
                this.terminated = true;
                this.lock.notifyAll();
                if (this.terminationRunnable != null) {
                    this.terminationRunnable.run();
                }
            }
        }
    }

    private static class ServerCallImpl<ReqT, RespT>
    extends ServerCall<RespT> {
        private final ServerStream stream;
        private final MethodDescriptor<ReqT, RespT> method;
        private volatile boolean cancelled;
        private boolean sendHeadersCalled;
        private boolean closeCalled;
        private boolean sendMessageCalled;

        public ServerCallImpl(ServerStream stream, MethodDescriptor<ReqT, RespT> method) {
            this.stream = stream;
            this.method = method;
        }

        @Override
        public void request(int numMessages) {
            this.stream.request(numMessages);
        }

        @Override
        public void sendHeaders(Metadata.Headers headers) {
            Preconditions.checkState((!this.sendHeadersCalled ? 1 : 0) != 0, (Object)"sendHeaders has already been called");
            Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call is closed");
            Preconditions.checkState((!this.sendMessageCalled ? 1 : 0) != 0, (Object)"sendMessage has already been called");
            this.sendHeadersCalled = true;
            this.stream.writeHeaders(headers);
        }

        @Override
        public void sendMessage(RespT message) {
            Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call is closed");
            this.sendMessageCalled = true;
            try {
                InputStream resp = this.method.streamResponse(message);
                this.stream.writeMessage(resp);
                this.stream.flush();
            }
            catch (Throwable t) {
                this.close(Status.fromThrowable(t), new Metadata.Trailers());
                throw Throwables.propagate((Throwable)t);
            }
        }

        @Override
        public boolean isReady() {
            return this.stream.isReady();
        }

        @Override
        public void close(Status status, Metadata.Trailers trailers) {
            Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call already closed");
            this.closeCalled = true;
            this.stream.close(status, trailers);
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        private ServerStreamListenerImpl newServerStreamListener(ServerCall.Listener<ReqT> listener, Future<?> timeout) {
            return new ServerStreamListenerImpl(listener, timeout);
        }

        private class ServerStreamListenerImpl
        implements ServerStreamListener {
            private final ServerCall.Listener<ReqT> listener;
            private final Future<?> timeout;

            public ServerStreamListenerImpl(ServerCall.Listener<ReqT> listener, Future<?> timeout) {
                this.listener = (ServerCall.Listener)Preconditions.checkNotNull(listener, (Object)"listener must not be null");
                this.timeout = timeout;
            }

            @Override
            public void messageRead(InputStream message) {
                try {
                    if (ServerCallImpl.this.cancelled) {
                        return;
                    }
                    this.listener.onMessage(ServerCallImpl.this.method.parseRequest(message));
                }
                finally {
                    try {
                        message.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            @Override
            public void halfClosed() {
                if (ServerCallImpl.this.cancelled) {
                    return;
                }
                this.listener.onHalfClose();
            }

            @Override
            public void closed(Status status) {
                this.timeout.cancel(true);
                if (status.isOk()) {
                    this.listener.onComplete();
                } else {
                    ServerCallImpl.this.cancelled = true;
                    this.listener.onCancel();
                }
            }

            @Override
            public void onReady() {
                if (ServerCallImpl.this.cancelled) {
                    return;
                }
                this.listener.onReady();
            }
        }
    }

    private static class JumpToApplicationThreadServerStreamListener
    implements ServerStreamListener {
        private final SerializingExecutor callExecutor;
        private final ServerStream stream;
        private ServerStreamListener listener;

        public JumpToApplicationThreadServerStreamListener(SerializingExecutor executor, ServerStream stream) {
            this.callExecutor = executor;
            this.stream = stream;
        }

        private ServerStreamListener getListener() {
            if (this.listener == null) {
                throw new IllegalStateException("listener unset");
            }
            return this.listener;
        }

        private void setListener(ServerStreamListener listener) {
            Preconditions.checkNotNull((Object)listener, (Object)"listener must not be null");
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"Listener already set");
            this.listener = listener;
        }

        private void internalClose(Status status, Metadata.Trailers trailers) {
            this.stream.close(status, trailers);
        }

        @Override
        public void messageRead(final InputStream message) {
            this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().messageRead(message);
                    }
                    catch (Throwable t) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(Status.fromThrowable(t), new Metadata.Trailers());
                        throw Throwables.propagate((Throwable)t);
                    }
                }
            });
        }

        @Override
        public void halfClosed() {
            this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().halfClosed();
                    }
                    catch (Throwable t) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(Status.fromThrowable(t), new Metadata.Trailers());
                        throw Throwables.propagate((Throwable)t);
                    }
                }
            });
        }

        @Override
        public void closed(final Status status) {
            this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    JumpToApplicationThreadServerStreamListener.this.getListener().closed(status);
                }
            });
        }

        @Override
        public void onReady() {
            this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    JumpToApplicationThreadServerStreamListener.this.getListener().onReady();
                }
            });
        }
    }

    private static class NoopListener
    implements ServerStreamListener {
        private NoopListener() {
        }

        @Override
        public void messageRead(InputStream value) {
            try {
                value.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void halfClosed() {
        }

        @Override
        public void closed(Status status) {
        }

        @Override
        public void onReady() {
        }
    }

    private class ServerTransportListenerImpl
    implements ServerTransportListener {
        private final ServerTransport transport;

        public ServerTransportListenerImpl(ServerTransport transport) {
            this.transport = transport;
        }

        @Override
        public void transportTerminated() {
            ServerImpl.this.transportClosed(this.transport);
        }

        @Override
        public ServerStreamListener streamCreated(final ServerStream stream, final String methodName, final Metadata.Headers headers) {
            final Future<?> timeout = this.scheduleTimeout(stream, headers);
            SerializingExecutor serializingExecutor = new SerializingExecutor(ServerImpl.this.executor);
            final JumpToApplicationThreadServerStreamListener jumpListener = new JumpToApplicationThreadServerStreamListener(serializingExecutor, stream);
            serializingExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ServerStreamListener listener = NOOP_LISTENER;
                    try {
                        HandlerRegistry.Method method = ServerImpl.this.registry.lookupMethod(methodName);
                        if (method == null) {
                            stream.close(Status.UNIMPLEMENTED.withDescription("Method not found: " + methodName), new Metadata.Trailers());
                            timeout.cancel(true);
                            return;
                        }
                        listener = ServerTransportListenerImpl.this.startCall(stream, methodName, method.getMethodDefinition(), timeout, headers);
                    }
                    catch (Throwable t) {
                        stream.close(Status.fromThrowable(t), new Metadata.Trailers());
                        timeout.cancel(true);
                        throw Throwables.propagate((Throwable)t);
                    }
                    finally {
                        jumpListener.setListener(listener);
                    }
                }
            });
            return jumpListener;
        }

        private Future<?> scheduleTimeout(final ServerStream stream, Metadata.Headers headers) {
            Long timeoutMicros = headers.get(ChannelImpl.TIMEOUT_KEY);
            if (timeoutMicros == null) {
                return DEFAULT_TIMEOUT_FUTURE;
            }
            return ServerImpl.this.timeoutService.schedule(new Runnable(){

                @Override
                public void run() {
                    stream.cancel(Status.DEADLINE_EXCEEDED);
                }
            }, (long)timeoutMicros, TimeUnit.MICROSECONDS);
        }

        private <ReqT, RespT> ServerStreamListener startCall(ServerStream stream, String fullMethodName, ServerMethodDefinition<ReqT, RespT> methodDef, Future<?> timeout, Metadata.Headers headers) {
            ServerCallImpl<ReqT, RespT> call = new ServerCallImpl<ReqT, RespT>(stream, methodDef.getMethodDescriptor());
            ServerCall.Listener<ReqT> listener = methodDef.getServerCallHandler().startCall(methodDef.getMethodDescriptor(), call, headers);
            if (listener == null) {
                throw new NullPointerException("startCall() returned a null listener for method " + fullMethodName);
            }
            return ((ServerCallImpl)call).newServerStreamListener(listener, timeout);
        }
    }

    private class ServerListenerImpl
    implements ServerListener {
        private ServerListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServerTransportListener transportCreated(ServerTransport transport) {
            Object object = ServerImpl.this.lock;
            synchronized (object) {
                ServerImpl.this.transports.add(transport);
            }
            return new ServerTransportListenerImpl(transport);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serverShutdown() {
            ArrayList copiedTransports;
            Object object = ServerImpl.this.lock;
            synchronized (object) {
                copiedTransports = new ArrayList(ServerImpl.this.transports);
            }
            for (ServerTransport transport : copiedTransports) {
                transport.shutdown();
            }
            object = ServerImpl.this.lock;
            synchronized (object) {
                ServerImpl.this.transportServerTerminated = true;
                ServerImpl.this.checkForTermination();
            }
        }
    }
}

