/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Deadline;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class Context {
    private static final Logger LOG = Logger.getLogger(Context.class.getName());
    private static final Object[][] EMPTY_ENTRIES = new Object[0][2];
    private static final Key<Deadline> DEADLINE_KEY = new Key("deadline");
    public static final Context ROOT = new Context(null);
    private static final ThreadLocal<Context> localContext = new ThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            return ROOT;
        }
    };
    private final Context parent;
    private final Object[][] keyValueEntries;
    private final boolean cascadesCancellation;
    private ArrayList<ExecutableListener> listeners;
    private CancellationListener parentListener = new ParentListener();
    private final boolean canBeCancelled;

    public static <T> Key<T> key(String name) {
        return new Key(name);
    }

    public static <T> Key<T> keyWithDefault(String name, T defaultValue) {
        return new Key<T>(name, defaultValue);
    }

    public static Context current() {
        Context current = localContext.get();
        if (current == null) {
            return ROOT;
        }
        return current;
    }

    private Context(Context parent) {
        this.parent = parent;
        this.keyValueEntries = new Object[][]{{DEADLINE_KEY, null}};
        this.cascadesCancellation = false;
        this.canBeCancelled = false;
    }

    private Context(Context parent, Object[][] keyValueEntries) {
        this.parent = parent;
        this.keyValueEntries = keyValueEntries;
        this.cascadesCancellation = true;
        this.canBeCancelled = this.parent != null && this.parent.canBeCancelled;
    }

    private Context(Context parent, Object[][] keyValueEntries, boolean isCancellable) {
        this.parent = parent;
        this.keyValueEntries = keyValueEntries;
        this.cascadesCancellation = true;
        this.canBeCancelled = isCancellable;
    }

    public CancellableContext withCancellation() {
        return new CancellableContext(this);
    }

    public CancellableContext withDeadlineAfter(long duration, TimeUnit unit, ScheduledExecutorService scheduler) {
        return this.withDeadline(Deadline.after(duration, unit), scheduler);
    }

    public CancellableContext withDeadline(Deadline deadline, ScheduledExecutorService scheduler) {
        Preconditions.checkNotNull((Object)deadline, (Object)"deadline");
        Preconditions.checkNotNull((Object)scheduler, (Object)"scheduler");
        return new CancellableContext(this, deadline, scheduler);
    }

    public <V> Context withValue(Key<V> k1, V v1) {
        return new Context(this, new Object[][]{{k1, v1}});
    }

    public <V1, V2> Context withValues(Key<V1> k1, V1 v1, Key<V2> k2, V2 v2) {
        return new Context(this, new Object[][]{{k1, v1}, {k2, v2}});
    }

    public <V1, V2, V3> Context withValues(Key<V1> k1, V1 v1, Key<V2> k2, V2 v2, Key<V3> k3, V3 v3) {
        return new Context(this, new Object[][]{{k1, v1}, {k2, v2}, {k3, v3}});
    }

    public CancellableContext fork() {
        return new Context(this).withCancellation();
    }

    boolean canBeCancelled() {
        return this.canBeCancelled;
    }

    public Context attach() {
        Context previous = Context.current();
        localContext.set(this);
        return previous;
    }

    public void detach(Context toAttach) {
        Preconditions.checkNotNull((Object)toAttach);
        if (toAttach.attach() != this) {
            LOG.log(Level.SEVERE, "Context was not attached when detaching", new Throwable().fillInStackTrace());
        }
    }

    boolean isCurrent() {
        return Context.current() == this;
    }

    public boolean isCancelled() {
        if (this.parent == null || !this.cascadesCancellation) {
            return false;
        }
        return this.parent.isCancelled();
    }

    @Nullable
    public Throwable cancellationCause() {
        if (this.parent == null || !this.cascadesCancellation) {
            return null;
        }
        return this.parent.cancellationCause();
    }

    @Nullable
    public Deadline getDeadline() {
        return DEADLINE_KEY.get(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(CancellationListener cancellationListener, Executor executor) {
        Preconditions.checkNotNull((Object)cancellationListener);
        Preconditions.checkNotNull((Object)executor);
        if (this.canBeCancelled) {
            ExecutableListener executableListener = new ExecutableListener(executor, cancellationListener);
            Context context = this;
            synchronized (context) {
                if (this.isCancelled()) {
                    executableListener.deliver();
                } else if (this.listeners == null) {
                    this.listeners = new ArrayList();
                    this.listeners.add(executableListener);
                    this.parent.addListener(this.parentListener, MoreExecutors.directExecutor());
                } else {
                    this.listeners.add(executableListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(CancellationListener cancellationListener) {
        if (!this.canBeCancelled) {
            return;
        }
        Context context = this;
        synchronized (context) {
            if (this.listeners != null) {
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    if (this.listeners.get(i).listener != cancellationListener) continue;
                    this.listeners.remove(i);
                    break;
                }
                if (this.listeners.isEmpty()) {
                    this.parent.removeListener(this.parentListener);
                    this.listeners = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAndClearListeners() {
        int i;
        ArrayList<ExecutableListener> tmpListeners;
        if (!this.canBeCancelled) {
            return;
        }
        Context context = this;
        synchronized (context) {
            if (this.listeners == null) {
                return;
            }
            tmpListeners = this.listeners;
            this.listeners = null;
        }
        for (i = 0; i < tmpListeners.size(); ++i) {
            if (tmpListeners.get(i).listener instanceof ParentListener) continue;
            tmpListeners.get(i).deliver();
        }
        for (i = 0; i < tmpListeners.size(); ++i) {
            if (!(tmpListeners.get(i).listener instanceof ParentListener)) continue;
            tmpListeners.get(i).deliver();
        }
        this.parent.removeListener(this.parentListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int listenerCount() {
        Context context = this;
        synchronized (context) {
            return this.listeners == null ? 0 : this.listeners.size();
        }
    }

    public void run(Runnable r) {
        Context previous = this.attach();
        try {
            r.run();
        }
        finally {
            this.detach(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V call(Callable<V> c) throws Exception {
        Context previous = this.attach();
        try {
            V v = c.call();
            return v;
        }
        finally {
            this.detach(previous);
        }
    }

    public Runnable wrap(final Runnable r) {
        return new Runnable(){

            @Override
            public void run() {
                Context previous = Context.this.attach();
                try {
                    r.run();
                }
                finally {
                    Context.this.detach(previous);
                }
            }
        };
    }

    public <C> Callable<C> wrap(final Callable<C> c) {
        return new Callable<C>(){

            @Override
            public C call() throws Exception {
                Context previous = Context.this.attach();
                try {
                    Object v = c.call();
                    return v;
                }
                finally {
                    Context.this.detach(previous);
                }
            }
        };
    }

    public Executor fixedContextExecutor(final Executor e) {
        class FixedContextExecutor
        implements Executor {
            FixedContextExecutor() {
            }

            @Override
            public void execute(Runnable r) {
                e.execute(Context.this.wrap(r));
            }
        }
        return new FixedContextExecutor();
    }

    public static Executor currentContextExecutor(Executor e) {
        class CurrentContextExecutor
        implements Executor {
            final /* synthetic */ Executor val$e;

            CurrentContextExecutor(Executor executor) {
                this.val$e = executor;
            }

            @Override
            public void execute(Runnable r) {
                this.val$e.execute(Context.current().wrap(r));
            }
        }
        return new CurrentContextExecutor(e);
    }

    private Object lookup(Key<?> key) {
        for (int i = 0; i < this.keyValueEntries.length; ++i) {
            if (!key.equals(this.keyValueEntries[i][0])) continue;
            return this.keyValueEntries[i][1];
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.lookup(key);
    }

    private class ParentListener
    implements CancellationListener {
        private ParentListener() {
        }

        @Override
        public void cancelled(Context context) {
            if (Context.this instanceof CancellableContext) {
                ((CancellableContext)Context.this).cancel(context.cancellationCause());
            } else {
                Context.this.notifyAndClearListeners();
            }
        }
    }

    private class ExecutableListener
    implements Runnable {
        private final Executor executor;
        private final CancellationListener listener;

        private ExecutableListener(Executor executor, CancellationListener listener) {
            this.executor = executor;
            this.listener = listener;
        }

        private void deliver() {
            try {
                this.executor.execute(this);
            }
            catch (Throwable t) {
                LOG.log(Level.INFO, "Exception notifying context listener", t);
            }
        }

        @Override
        public void run() {
            this.listener.cancelled(Context.this);
        }
    }

    public static class Key<T> {
        private final String name;
        private final T defaultValue;

        Key(String name) {
            this(name, null);
        }

        Key(String name, T defaultValue) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.defaultValue = defaultValue;
        }

        public T get() {
            return this.get(Context.current());
        }

        public T get(Context context) {
            Object value = context.lookup(this);
            return (T)(value == null ? this.defaultValue : value);
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface CancellationListener {
        public void cancelled(Context var1);
    }

    public static final class CancellableContext
    extends Context {
        private boolean cancelled;
        private Throwable cancellationCause;
        private final Context uncancellableSurrogate;
        private ScheduledFuture<?> pendingDeadline;

        private static Object[][] deriveDeadline(Context parent, Deadline deadline) {
            Object[][] objectArray;
            Deadline parentDeadline = (Deadline)DEADLINE_KEY.get(parent);
            if (parentDeadline == null || deadline.isBefore(parentDeadline)) {
                Object[][] objectArray2 = new Object[1][];
                objectArray = objectArray2;
                objectArray2[0] = new Object[]{DEADLINE_KEY, deadline};
            } else {
                objectArray = EMPTY_ENTRIES;
            }
            return objectArray;
        }

        private CancellableContext(Context parent) {
            super(parent, EMPTY_ENTRIES, true);
            this.uncancellableSurrogate = new Context((Context)this, EMPTY_ENTRIES);
        }

        private CancellableContext(Context parent, Deadline deadline, ScheduledExecutorService scheduler) {
            super(parent, CancellableContext.deriveDeadline(parent, deadline), true);
            if (DEADLINE_KEY.get(this) == deadline) {
                final TimeoutException cause = new TimeoutException("context timed out");
                if (!deadline.isExpired()) {
                    this.pendingDeadline = deadline.runOnExpiration(new Runnable(){

                        @Override
                        public void run() {
                            CancellableContext.this.cancel(cause);
                        }
                    }, scheduler);
                } else {
                    this.cancel(cause);
                }
            }
            this.uncancellableSurrogate = new Context((Context)this, EMPTY_ENTRIES);
        }

        @Override
        public Context attach() {
            return this.uncancellableSurrogate.attach();
        }

        @Override
        public void detach(Context toAttach) {
            this.uncancellableSurrogate.detach(toAttach);
        }

        @Override
        public boolean isCurrent() {
            return this.uncancellableSurrogate.isCurrent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(@Nullable Throwable cause) {
            boolean triggeredCancel = false;
            CancellableContext cancellableContext = this;
            synchronized (cancellableContext) {
                if (!this.cancelled) {
                    this.cancelled = true;
                    if (this.pendingDeadline != null) {
                        this.pendingDeadline.cancel(false);
                        this.pendingDeadline = null;
                    }
                    this.cancellationCause = cause;
                    triggeredCancel = true;
                }
            }
            if (triggeredCancel) {
                this.notifyAndClearListeners();
            }
            return triggeredCancel;
        }

        public void detachAndCancel(Context toAttach, @Nullable Throwable cause) {
            try {
                this.detach(toAttach);
            }
            finally {
                this.cancel(cause);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            CancellableContext cancellableContext = this;
            synchronized (cancellableContext) {
                if (this.cancelled) {
                    return true;
                }
            }
            if (super.isCancelled()) {
                this.cancel(super.cancellationCause());
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Throwable cancellationCause() {
            if (this.isCancelled()) {
                return this.cancellationCause;
            }
            return null;
        }
    }
}

