/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.qps;

import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.benchmarks.Utils;
import io.grpc.benchmarks.proto.BenchmarkServiceGrpc;
import io.grpc.benchmarks.proto.Messages;
import io.grpc.benchmarks.qps.ClientConfiguration;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;

public class AsyncClient {
    private final ClientConfiguration config;

    public AsyncClient(ClientConfiguration config) {
        this.config = config;
    }

    public void run() throws Exception {
        if (this.config == null) {
            return;
        }
        Messages.SimpleRequest req = this.newRequest();
        ArrayList<ManagedChannel> channels = new ArrayList<ManagedChannel>(this.config.channels);
        for (int i = 0; i < this.config.channels; ++i) {
            channels.add(this.config.newChannel());
        }
        this.warmup(req, channels);
        long startTime = System.nanoTime();
        long endTime = startTime + TimeUnit.SECONDS.toNanos(this.config.duration);
        List<Histogram> histograms = this.doBenchmark(req, channels, endTime);
        long elapsedTime = System.nanoTime() - startTime;
        Histogram merged = AsyncClient.merge(histograms);
        this.printStats(merged, elapsedTime);
        if (this.config.histogramFile != null) {
            Utils.saveHistogram(merged, this.config.histogramFile);
        }
        AsyncClient.shutdown(channels);
    }

    private Messages.SimpleRequest newRequest() {
        ByteString body = ByteString.copyFrom((byte[])new byte[this.config.clientPayload]);
        Messages.Payload payload = Messages.Payload.newBuilder().setType(this.config.payloadType).setBody(body).build();
        return Messages.SimpleRequest.newBuilder().setResponseType(this.config.payloadType).setResponseSize(this.config.serverPayload).setPayload(payload).build();
    }

    private void warmup(Messages.SimpleRequest req, List<? extends Channel> channels) throws Exception {
        long endTime = System.nanoTime() + TimeUnit.SECONDS.toNanos(this.config.warmupDuration);
        this.doBenchmark(req, channels, endTime);
        System.gc();
    }

    private List<Histogram> doBenchmark(Messages.SimpleRequest req, List<? extends Channel> channels, long endTime) throws Exception {
        ArrayList<Future<Histogram>> futures = new ArrayList<Future<Histogram>>(this.config.outstandingRpcsPerChannel);
        for (int i = 0; i < this.config.channels; ++i) {
            for (int j = 0; j < this.config.outstandingRpcsPerChannel; ++j) {
                Channel channel = channels.get(i);
                futures.add(this.doRpcs(channel, req, endTime));
            }
        }
        ArrayList<Histogram> histograms = new ArrayList<Histogram>(futures.size());
        for (Future future : futures) {
            histograms.add((Histogram)future.get());
        }
        return histograms;
    }

    private Future<Histogram> doRpcs(Channel channel, Messages.SimpleRequest request, long endTime) {
        switch (this.config.rpcType) {
            case UNARY: {
                return this.doUnaryCalls(channel, request, endTime);
            }
            case STREAMING: {
                return AsyncClient.doStreamingCalls(channel, request, endTime);
            }
        }
        throw new IllegalStateException("unsupported rpc type");
    }

    private Future<Histogram> doUnaryCalls(Channel channel, final Messages.SimpleRequest request, final long endTime) {
        final BenchmarkServiceGrpc.BenchmarkServiceStub stub = BenchmarkServiceGrpc.newStub(channel);
        final Histogram histogram = new Histogram(60000000L, 2);
        final SettableFuture future = SettableFuture.create();
        stub.unaryCall(request, new StreamObserver<Messages.SimpleResponse>(){
            long lastCall = System.nanoTime();

            public void onNext(Messages.SimpleResponse value) {
            }

            public void onError(Throwable t) {
                future.setException((Throwable)new RuntimeException("Encountered an error in unaryCall", t));
            }

            public void onCompleted() {
                long now = System.nanoTime();
                histogram.recordValue((now - this.lastCall) / 1000L);
                this.lastCall = now;
                if (endTime - now > 0L) {
                    stub.unaryCall(request, this);
                } else {
                    future.set((Object)histogram);
                }
            }
        });
        return future;
    }

    private static Future<Histogram> doStreamingCalls(Channel channel, Messages.SimpleRequest request, long endTime) {
        BenchmarkServiceGrpc.BenchmarkServiceStub stub = BenchmarkServiceGrpc.newStub(channel);
        Histogram histogram = new Histogram(60000000L, 2);
        SettableFuture future = SettableFuture.create();
        ThisIsAHackStreamObserver responseObserver = new ThisIsAHackStreamObserver(request, histogram, (SettableFuture<Histogram>)future, endTime);
        StreamObserver<Messages.SimpleRequest> requestObserver = stub.streamingCall(responseObserver);
        responseObserver.requestObserver = requestObserver;
        requestObserver.onNext((Object)request);
        return future;
    }

    private static Histogram merge(List<Histogram> histograms) {
        Histogram merged = new Histogram(60000000L, 2);
        for (Histogram histogram : histograms) {
            for (HistogramIterationValue value : histogram.allValues()) {
                long latency = value.getValueIteratedTo();
                long count = value.getCountAtValueIteratedTo();
                merged.recordValueWithCount(latency, count);
            }
        }
        return merged;
    }

    private void printStats(Histogram histogram, long elapsedTime) {
        long latency50 = histogram.getValueAtPercentile(50.0);
        long latency90 = histogram.getValueAtPercentile(90.0);
        long latency95 = histogram.getValueAtPercentile(95.0);
        long latency99 = histogram.getValueAtPercentile(99.0);
        long latency999 = histogram.getValueAtPercentile(99.9);
        long latencyMax = histogram.getValueAtPercentile(100.0);
        long queriesPerSecond = histogram.getTotalCount() * 1000000000L / elapsedTime;
        StringBuilder values = new StringBuilder();
        values.append("Channels:                       ").append(this.config.channels).append('\n').append("Outstanding RPCs per Channel:   ").append(this.config.outstandingRpcsPerChannel).append('\n').append("Server Payload Size:            ").append(this.config.serverPayload).append('\n').append("Client Payload Size:            ").append(this.config.clientPayload).append('\n').append("50%ile Latency (in micros):     ").append(latency50).append('\n').append("90%ile Latency (in micros):     ").append(latency90).append('\n').append("95%ile Latency (in micros):     ").append(latency95).append('\n').append("99%ile Latency (in micros):     ").append(latency99).append('\n').append("99.9%ile Latency (in micros):   ").append(latency999).append('\n').append("Maximum Latency (in micros):    ").append(latencyMax).append('\n').append("QPS:                            ").append(queriesPerSecond).append('\n');
        System.out.println(values);
    }

    private static void shutdown(List<ManagedChannel> channels) {
        for (ManagedChannel channel : channels) {
            channel.shutdown();
        }
    }

    public static void main(String ... args) throws Exception {
        ClientConfiguration config;
        ClientConfiguration.Builder configBuilder = ClientConfiguration.newBuilder(ClientConfiguration.ClientParam.ADDRESS, ClientConfiguration.ClientParam.CHANNELS, ClientConfiguration.ClientParam.OUTSTANDING_RPCS, ClientConfiguration.ClientParam.CLIENT_PAYLOAD, ClientConfiguration.ClientParam.SERVER_PAYLOAD, ClientConfiguration.ClientParam.TLS, ClientConfiguration.ClientParam.TESTCA, ClientConfiguration.ClientParam.TRANSPORT, ClientConfiguration.ClientParam.DURATION, ClientConfiguration.ClientParam.WARMUP_DURATION, ClientConfiguration.ClientParam.DIRECTEXECUTOR, ClientConfiguration.ClientParam.SAVE_HISTOGRAM, ClientConfiguration.ClientParam.STREAMING_RPCS, ClientConfiguration.ClientParam.FLOW_CONTROL_WINDOW);
        try {
            config = (ClientConfiguration)configBuilder.build(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            configBuilder.printUsage();
            return;
        }
        AsyncClient client = new AsyncClient(config);
        client.run();
    }

    private static class ThisIsAHackStreamObserver
    implements StreamObserver<Messages.SimpleResponse> {
        final Messages.SimpleRequest request;
        final Histogram histogram;
        final SettableFuture<Histogram> future;
        final long endTime;
        long lastCall = System.nanoTime();
        StreamObserver<Messages.SimpleRequest> requestObserver;

        ThisIsAHackStreamObserver(Messages.SimpleRequest request, Histogram histogram, SettableFuture<Histogram> future, long endTime) {
            this.request = request;
            this.histogram = histogram;
            this.future = future;
            this.endTime = endTime;
        }

        public void onNext(Messages.SimpleResponse value) {
            long now = System.nanoTime();
            this.histogram.recordValue((now - this.lastCall) / 1000L);
            this.lastCall = now;
            if (this.endTime - now > 0L) {
                this.requestObserver.onNext((Object)this.request);
            } else {
                this.requestObserver.onCompleted();
            }
        }

        public void onError(Throwable t) {
            this.future.setException((Throwable)new RuntimeException("Encountered an error in streamingCall", t));
        }

        public void onCompleted() {
            this.future.set((Object)this.histogram);
        }
    }
}

