/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.driver;

import com.google.common.util.concurrent.UncaughtExceptionHandlers;
import com.sun.management.OperatingSystemMXBean;
import io.grpc.BindableService;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.benchmarks.ByteBufOutputMarshaller;
import io.grpc.benchmarks.Utils;
import io.grpc.benchmarks.proto.BenchmarkServiceGrpc;
import io.grpc.benchmarks.proto.Control;
import io.grpc.benchmarks.proto.Stats;
import io.grpc.benchmarks.qps.AsyncServer;
import io.grpc.internal.testing.TestUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

final class LoadServer {
    private static final MethodDescriptor.Marshaller<ByteBuf> marshaller = new ByteBufOutputMarshaller();
    static final MethodDescriptor<ByteBuf, ByteBuf> GENERIC_UNARY_METHOD = BenchmarkServiceGrpc.getUnaryCallMethod().toBuilder(marshaller, marshaller).build();
    static final MethodDescriptor<ByteBuf, ByteBuf> GENERIC_STREAMING_PING_PONG_METHOD = BenchmarkServiceGrpc.getStreamingCallMethod().toBuilder(marshaller, marshaller).build();
    private static final Logger log = Logger.getLogger(LoadServer.class.getName());
    private final Server server;
    private final AsyncServer.BenchmarkServiceImpl benchmarkService;
    private final OperatingSystemMXBean osBean;
    private final int port;
    private ByteBuf genericResponse;
    private long lastStatTime;
    private long lastMarkCpuTime;

    LoadServer(Control.ServerConfig config) throws Exception {
        log.log(Level.INFO, "Server Config \n" + config.toString());
        this.port = config.getPort() == 0 ? Utils.pickUnusedPort() : config.getPort();
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)this.port);
        int asyncThreads = config.getAsyncServerThreads() == 0 ? Runtime.getRuntime().availableProcessors() : config.getAsyncServerThreads();
        switch (config.getServerType()) {
            case ASYNC_SERVER: {
                serverBuilder.executor((Executor)this.getExecutor(asyncThreads));
                break;
            }
            case SYNC_SERVER: {
                serverBuilder.directExecutor();
                break;
            }
            case ASYNC_GENERIC_SERVER: {
                serverBuilder.executor((Executor)this.getExecutor(asyncThreads));
                PooledByteBufAllocator alloc = PooledByteBufAllocator.DEFAULT;
                this.genericResponse = alloc.buffer(config.getPayloadConfig().getBytebufParams().getRespSize());
                if (this.genericResponse.capacity() <= 0) break;
                this.genericResponse.writerIndex(this.genericResponse.capacity() - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (config.hasSecurityParams()) {
            File cert = TestUtils.loadCert((String)"server1.pem");
            File key = TestUtils.loadCert((String)"server1.key");
            serverBuilder.useTransportSecurity(cert, key);
        }
        this.benchmarkService = new AsyncServer.BenchmarkServiceImpl();
        if (config.getServerType() == Control.ServerType.ASYNC_GENERIC_SERVER) {
            serverBuilder.addService(ServerServiceDefinition.builder((ServiceDescriptor)new ServiceDescriptor("grpc.testing.BenchmarkService", new MethodDescriptor[]{GENERIC_STREAMING_PING_PONG_METHOD})).addMethod(GENERIC_STREAMING_PING_PONG_METHOD, (ServerCallHandler)new GenericServiceCallHandler()).build());
        } else {
            serverBuilder.addService((BindableService)this.benchmarkService);
        }
        this.server = serverBuilder.build();
        List<OperatingSystemMXBean> beans = ManagementFactory.getPlatformMXBeans(OperatingSystemMXBean.class);
        this.osBean = !beans.isEmpty() ? beans.get(0) : null;
    }

    ExecutorService getExecutor(int asyncThreads) {
        return new ForkJoinPool(asyncThreads, new ForkJoinPool.ForkJoinWorkerThreadFactory(){
            final AtomicInteger num = new AtomicInteger();

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                thread.setDaemon(true);
                thread.setName("server-worker--" + this.num.getAndIncrement());
                return thread;
            }
        }, UncaughtExceptionHandlers.systemExit(), true);
    }

    int getPort() {
        return this.port;
    }

    int getCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    void start() throws Exception {
        this.server.start();
        this.lastStatTime = System.nanoTime();
        if (this.osBean != null) {
            this.lastMarkCpuTime = this.osBean.getProcessCpuTime();
        }
    }

    Stats.ServerStats getStats() {
        Stats.ServerStats.Builder builder = Stats.ServerStats.newBuilder();
        long now = System.nanoTime();
        double elapsed = ((double)now - (double)this.lastStatTime) / 1.0E9;
        this.lastStatTime = now;
        builder.setTimeElapsed(elapsed);
        if (this.osBean != null) {
            long nowCpu = this.osBean.getProcessCpuTime();
            builder.setTimeUser(((double)nowCpu - (double)this.lastMarkCpuTime) / 1.0E9);
            this.lastMarkCpuTime = nowCpu;
        }
        return builder.build();
    }

    void shutdownNow() {
        this.benchmarkService.shutdown();
        this.server.shutdownNow();
    }

    private class GenericServiceCallHandler
    implements ServerCallHandler<ByteBuf, ByteBuf> {
        private GenericServiceCallHandler() {
        }

        public ServerCall.Listener<ByteBuf> startCall(final ServerCall<ByteBuf, ByteBuf> call, Metadata headers) {
            call.sendHeaders(new Metadata());
            call.request(1);
            return new ServerCall.Listener<ByteBuf>(){

                public void onMessage(ByteBuf message) {
                    message.release();
                    call.request(1);
                    call.sendMessage((Object)LoadServer.this.genericResponse.slice());
                }

                public void onHalfClose() {
                    call.close(Status.OK, new Metadata());
                }

                public void onCancel() {
                }

                public void onComplete() {
                }
            };
        }
    }
}

