/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.resource.internal;

import io.gravitee.plugin.core.api.AbstractSimplePluginHandler;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.resource.ResourcePlugin;
import io.gravitee.plugin.resource.internal.ResourceConfigurationClassFinder;
import io.gravitee.plugin.resource.internal.ResourcePluginImpl;
import java.io.IOException;
import java.net.URLClassLoader;
import org.springframework.beans.factory.annotation.Autowired;

public class ResourcePluginHandler
extends AbstractSimplePluginHandler<ResourcePlugin> {
    @Autowired
    private ConfigurablePluginManager<ResourcePlugin> resourcePluginManager;

    public boolean canHandle(Plugin plugin) {
        return "resource".equalsIgnoreCase(plugin.type());
    }

    protected String type() {
        return "resources";
    }

    protected ResourcePlugin create(Plugin plugin, Class<?> pluginClass) {
        ResourcePluginImpl resourcePlugin = new ResourcePluginImpl(plugin, pluginClass);
        resourcePlugin.setConfiguration(new ResourceConfigurationClassFinder().lookupFirst(pluginClass));
        return resourcePlugin;
    }

    protected void register(ResourcePlugin plugin) {
        this.resourcePluginManager.register((Plugin)plugin);
        URLClassLoader classLoader = (URLClassLoader)plugin.resource().getClassLoader();
        try {
            classLoader.close();
        }
        catch (IOException e) {
            this.logger.error("Unexpected exception while trying to release the notifier classloader");
        }
    }

    protected ClassLoader getClassLoader(Plugin plugin) throws Exception {
        return new URLClassLoader(plugin.dependencies(), ((Object)((Object)this)).getClass().getClassLoader());
    }
}

