/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.policy.internal;

import com.google.common.base.Predicate;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.api.annotations.OnResponse;
import io.gravitee.policy.api.annotations.OnResponseContent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.reflections.ReflectionUtils;

public class PolicyMethodResolver {
    private static final Class<? extends Annotation>[] RESOLVABLE_ANNOTATIONS = new Class[]{OnRequest.class, OnResponse.class, OnRequestContent.class, OnResponseContent.class};

    public Map<Class<? extends Annotation>, Method> resolve(Class<?> policyClass) {
        HashMap<Class<? extends Annotation>, Method> methods = new HashMap<Class<? extends Annotation>, Method>();
        for (Class<? extends Annotation> annot : RESOLVABLE_ANNOTATIONS) {
            Set resolved = ReflectionUtils.getAllMethods(policyClass, (Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), ReflectionUtils.withAnnotation(annot)});
            if (resolved.isEmpty()) continue;
            methods.put(annot, (Method)resolved.iterator().next());
        }
        return methods;
    }
}

