/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.policy.internal;

import io.gravitee.plugin.core.api.AbstractSimplePluginHandler;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.policy.PolicyPlugin;
import io.gravitee.plugin.policy.internal.PolicyConfigurationClassFinder;
import io.gravitee.plugin.policy.internal.PolicyContextClassFinder;
import io.gravitee.plugin.policy.internal.PolicyPluginImpl;
import java.io.IOException;
import java.net.URLClassLoader;
import org.springframework.beans.factory.annotation.Autowired;

public class PolicyPluginHandler
extends AbstractSimplePluginHandler<PolicyPlugin> {
    @Autowired
    private ConfigurablePluginManager<PolicyPlugin> policyPluginManager;

    public boolean canHandle(Plugin plugin) {
        return "policy".equalsIgnoreCase(plugin.type());
    }

    protected String type() {
        return "policies";
    }

    protected PolicyPlugin create(Plugin plugin, Class<?> pluginClass) {
        PolicyPluginImpl policyPlugin = new PolicyPluginImpl(plugin, pluginClass);
        policyPlugin.setConfiguration(new PolicyConfigurationClassFinder().lookupFirst(pluginClass));
        policyPlugin.setContext(new PolicyContextClassFinder().lookupFirst(pluginClass, policyPlugin.policy().getClassLoader()));
        return policyPlugin;
    }

    protected void register(PolicyPlugin policyPlugin) {
        this.policyPluginManager.register((Plugin)policyPlugin);
        ClassLoader policyClassLoader = policyPlugin.policy().getClassLoader();
        if (policyClassLoader instanceof URLClassLoader) {
            URLClassLoader classLoader = (URLClassLoader)policyClassLoader;
            try {
                classLoader.close();
            }
            catch (IOException e) {
                this.logger.error("Unexpected exception while trying to release the policy classloader");
            }
        }
    }

    protected ClassLoader getClassLoader(Plugin plugin) {
        return new URLClassLoader(plugin.dependencies(), ((Object)((Object)this)).getClass().getClassLoader());
    }
}

