/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.utils;

import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Objects;

public class FileUtils {
    public static DirectoryStream<Path> newDirectoryStream(Path dir, String glob) throws IOException {
        Objects.requireNonNull(dir);
        Objects.requireNonNull(glob);
        FileSystem fs = dir.getFileSystem();
        PathMatcher matcher = fs.getPathMatcher("glob:" + glob);
        DirectoryStream.Filter<Path> filter = entry -> matcher.matches(entry.getFileName());
        return fs.provider().newDirectoryStream(dir, filter);
    }

    public static FileSystem createZipFileSystem(String zipFilename, boolean create) throws IOException {
        Path path = Paths.get(zipFilename, new String[0]);
        URI uri = URI.create("jar:file:" + path.toUri().getPath());
        HashMap<String, String> env = new HashMap<String, String>();
        if (create) {
            env.put("create", "true");
        }
        return FileSystems.newFileSystem(uri, env);
    }

    public static void unzip(String zipFilename, Path destDirname) throws IOException {
        final Path destDir = destDirname;
        if (Files.notExists(destDir, new LinkOption[0])) {
            Files.createDirectories(destDir, new FileAttribute[0]);
        }
        try (FileSystem zipFileSystem = FileUtils.createZipFileSystem(zipFilename, false);){
            Path root = zipFileSystem.getPath("/", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path destFile = Paths.get(destDir.toString(), file.toString());
                    Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path dirToCreate = Paths.get(destDir.toString(), dir.toString());
                    if (Files.notExists(dirToCreate, new LinkOption[0])) {
                        Files.createDirectory(dirToCreate, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void delete(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
            Files.deleteIfExists(directory);
        }
    }

    private FileUtils() {
    }
}

