/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.spring;

import io.gravitee.common.event.EventManager;
import io.gravitee.plugin.core.api.PluginClassLoaderFactory;
import io.gravitee.plugin.core.api.PluginConfigurationResolver;
import io.gravitee.plugin.core.api.PluginContextFactory;
import io.gravitee.plugin.core.api.PluginHandler;
import io.gravitee.plugin.core.api.PluginRegistry;
import io.gravitee.plugin.core.internal.CachedPluginClassLoaderFactory;
import io.gravitee.plugin.core.internal.PluginContextFactoryImpl;
import io.gravitee.plugin.core.internal.PluginEventListener;
import io.gravitee.plugin.core.internal.PluginRegistryConfiguration;
import io.gravitee.plugin.core.internal.PluginRegistryImpl;
import io.gravitee.plugin.core.internal.ReflectionBasedPluginConfigurationResolver;
import io.gravitee.plugin.core.spring.PluginHandlerBeanFactoryPostProcessor;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class PluginConfiguration {
    public static final int PARALLELISM = Runtime.getRuntime().availableProcessors() * 2;

    @Bean
    public PluginRegistryConfiguration pluginRegistryConfiguration() {
        return new PluginRegistryConfiguration();
    }

    @Bean
    public PluginRegistry pluginRegistry(PluginRegistryConfiguration pluginRegistryConfiguration, Environment environement, @Qualifier(value="corePluginExecutor") ExecutorService executorService, EventManager eventManager) {
        return new PluginRegistryImpl(pluginRegistryConfiguration, environement, executorService, eventManager);
    }

    @Bean(name={"pluginClassLoaderFactory"})
    public PluginClassLoaderFactory classLoaderFactory() {
        return new CachedPluginClassLoaderFactory();
    }

    @Bean
    public PluginContextFactory pluginContextFactory() {
        return new PluginContextFactoryImpl();
    }

    @Bean
    public PluginEventListener pluginEventListener(Collection<PluginHandler> pluginHandlers, EventManager eventManager, Environment environment) {
        return new PluginEventListener(pluginHandlers, eventManager, environment);
    }

    @Bean
    public PluginConfigurationResolver pluginConfigurationResolver() {
        return new ReflectionBasedPluginConfigurationResolver();
    }

    @Bean
    public static PluginHandlerBeanFactoryPostProcessor pluginHandlerBeanFactoryPostProcessor() {
        return new PluginHandlerBeanFactoryPostProcessor();
    }

    @Bean(value={"corePluginExecutor"})
    public ThreadPoolExecutor syncExecutor() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(PARALLELISM, PARALLELISM, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private int counter = 0;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "gio.core-plugin-" + this.counter++);
            }
        });
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }
}

