/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.internal;

import io.gravitee.plugin.core.api.PluginManifestValidator;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesBasedPluginManifestValidator
implements PluginManifestValidator {
    protected final Logger LOGGER = LoggerFactory.getLogger(PropertiesBasedPluginManifestValidator.class);
    private final Properties properties;
    private static final String[] DESCRIPTOR_PROPERTIES = new String[]{"id", "description", "class", "name", "version", "type"};

    public PropertiesBasedPluginManifestValidator(Properties properties) {
        this.properties = properties;
    }

    @Override
    public boolean validate() {
        for (String key : DESCRIPTOR_PROPERTIES) {
            if (this.validate(key)) continue;
            this.LOGGER.error("The property {} is not valid", (Object)key);
            return false;
        }
        return true;
    }

    private boolean validate(String key) {
        String value = this.properties.getProperty(key);
        return value != null && !value.isEmpty();
    }
}

