/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.internal;

import io.gravitee.common.event.EventManager;
import io.gravitee.common.service.AbstractService;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginEvent;
import io.gravitee.plugin.core.api.PluginManifest;
import io.gravitee.plugin.core.api.PluginManifestFactory;
import io.gravitee.plugin.core.api.PluginRegistry;
import io.gravitee.plugin.core.internal.PluginImpl;
import io.gravitee.plugin.core.internal.PluginRegistryConfiguration;
import io.gravitee.plugin.core.internal.PropertiesBasedPluginManifestValidator;
import io.gravitee.plugin.core.utils.FileUtils;
import io.gravitee.plugin.core.utils.GlobMatchingFileVisitor;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class PluginRegistryImpl
extends AbstractService<PluginRegistry>
implements PluginRegistry {
    private static final Logger log = LoggerFactory.getLogger(PluginRegistryImpl.class);
    public static final String PROPERTY_STRING_FORMAT = "%s.%s.enabled";
    private static final String JAR_EXTENSION = ".jar";
    private static final String JAR_GLOB = "*.jar";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String ZIP_GLOB = "*.zip";
    private static final String PLUGIN_MANIFEST_FILE = "plugin.properties";
    private static final Map<String, String> PLUGIN_TYPE_PROPERTY_ALIASES = new HashMap<String, String>();
    private final PluginRegistryConfiguration configuration;
    private final Environment environment;
    private final ExecutorService executor;
    private final EventManager eventManager;
    private boolean init = false;
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final Map<String, Map<String, Plugin>> pluginByType = new ConcurrentHashMap<String, Map<String, Plugin>>();
    private String[] workspacesPath;

    public void setWorkspacesPath(String workspacePath) {
        this.workspacesPath = new String[]{workspacePath};
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.init) {
            log.info("Initializing plugin registry.");
            this.init();
            log.info("Plugins have been loaded and installed.");
        } else {
            log.warn("Plugin registry has already been initialized.");
        }
    }

    public void init() throws Exception {
        Object[] pluginsPath = this.configuration.getPluginsPath();
        if ((pluginsPath == null || pluginsPath.length == 0) && this.workspacesPath == null) {
            log.error("No plugin registry configured.");
            throw new IllegalArgumentException("No plugin registry configured.");
        }
        if (this.workspacesPath != null) {
            pluginsPath = this.workspacesPath;
        }
        this.plugins.addAll((Collection)Flowable.fromArray((Object[])pluginsPath).doOnSubscribe(s -> {
            this.init = true;
        }).flatMap(this::loadPluginsFromPath).sorted((p1, p2) -> Math.negateExact(Long.valueOf(p1.getArchiveTimestamp()).compareTo(p2.getArchiveTimestamp()))).distinct().doOnNext(plugin -> this.eventManager.publishEvent((Enum)PluginEvent.DEPLOYED, plugin)).cast(Plugin.class).toList().doOnSuccess(PluginRegistryImpl::printPlugins).doOnSuccess(allPlugins -> allPlugins.forEach(plugin -> this.pluginByType.computeIfAbsent(plugin.type(), k -> new ConcurrentHashMap()).put(plugin.id(), plugin))).blockingGet());
        this.eventManager.publishEvent((Enum)PluginEvent.ENDED, null);
    }

    private Flowable<PluginImpl> loadPluginsFromPath(String pluginPathAsString) throws IOException {
        File pluginDir = new File(pluginPathAsString);
        if (!pluginDir.isDirectory()) {
            return Flowable.error((Throwable)new IllegalArgumentException("Invalid registry directory. Not a directory: " + pluginDir.getAbsolutePath()));
        }
        Path pluginPath = pluginDir.toPath();
        log.info("Loading plugins from {}", (Object)pluginDir);
        DirectoryStream<Path> stream = FileUtils.newDirectoryStream(pluginPath, ZIP_GLOB);
        return Flowable.fromIterable(stream).subscribeOn(Schedulers.from((Executor)this.executor)).map(path -> this.loadPlugin(pluginDir, (Path)path)).filter(PluginImpl::valid).doFinally(stream::close);
    }

    private static void printPlugins(List<Plugin> plugins) {
        plugins.stream().map(Plugin::type).distinct().forEach(type -> PluginRegistryImpl.printPluginByType(plugins, type));
    }

    private static void printPluginByType(List<Plugin> plugins, String pluginType) {
        log.info("List of available {}: ", (Object)pluginType.toLowerCase());
        plugins.stream().filter(plugin -> pluginType.equalsIgnoreCase(plugin.type())).forEach(plugin -> log.info("\t> {} [{}] has been loaded", (Object)plugin.id(), (Object)plugin.manifest().version()));
    }

    private PluginImpl loadPlugin(File registryDir, Path pluginArchivePath) {
        log.debug("Loading plugin archive {}", (Object)pluginArchivePath);
        PluginImpl plugin = new PluginImpl(PluginManifestFactory.create(new Properties()));
        try {
            String sPluginFile = pluginArchivePath.toFile().getName();
            sPluginFile = sPluginFile.substring(0, sPluginFile.lastIndexOf(ZIP_EXTENSION));
            Path workDir = FileSystems.getDefault().getPath(registryDir.getAbsolutePath(), ".work", sPluginFile);
            if (StringUtils.hasText((String)this.configuration.getPluginWorkDir()) && !(workDir = FileSystems.getDefault().getPath(this.configuration.getPluginWorkDir(), sPluginFile)).toFile().getParentFile().exists()) {
                workDir.toFile().getParentFile().mkdirs();
            }
            FileUtils.delete(workDir);
            FileUtils.unzip(pluginArchivePath.toString(), workDir);
            PluginManifest manifest = this.readPluginManifest(workDir);
            if (manifest != null && this.isEnabled(manifest)) {
                URL[] pluginDependencies = this.extractPluginDependencies(workDir);
                URL[] extDependencies = this.extractPluginExtensionDependencies(manifest, registryDir.toPath());
                URL[] dependencies = Arrays.copyOf(pluginDependencies, pluginDependencies.length + extDependencies.length);
                System.arraycopy(extDependencies, 0, dependencies, pluginDependencies.length, extDependencies.length);
                plugin = new PluginImpl(manifest);
                plugin.setArchiveTimestamp(PluginRegistryImpl.getFileTimestamp(pluginArchivePath));
                plugin.setPath(workDir);
                plugin.setDependencies(dependencies);
            }
        }
        catch (IOException ioe) {
            log.error("An unexpected error occurs while loading plugin archive {}", (Object)pluginArchivePath, (Object)ioe);
        }
        return plugin;
    }

    static long getFileTimestamp(Path pluginArchivePath) throws IOException {
        return Files.getLastModifiedTime(pluginArchivePath, new LinkOption[0]).toInstant().toEpochMilli();
    }

    private boolean isEnabled(PluginManifest pluginManifest) {
        String propertyFromAlias = String.format(PROPERTY_STRING_FORMAT, PLUGIN_TYPE_PROPERTY_ALIASES.get(pluginManifest.type()), pluginManifest.id());
        boolean enabled = PLUGIN_TYPE_PROPERTY_ALIASES.containsKey(pluginManifest.type()) && this.environment.containsProperty(propertyFromAlias) ? ((Boolean)this.environment.getProperty(propertyFromAlias, Boolean.class, (Object)true)).booleanValue() : ((Boolean)this.environment.getProperty(String.format(PROPERTY_STRING_FORMAT, pluginManifest.type(), pluginManifest.id()), Boolean.class, (Object)true)).booleanValue();
        log.debug("Plugin {} is loaded in registry: {}", (Object)pluginManifest.id(), (Object)enabled);
        return enabled;
    }

    private URL[] extractPluginDependencies(Path pluginDirPath) {
        try {
            GlobMatchingFileVisitor visitor = new GlobMatchingFileVisitor(JAR_GLOB);
            Files.walkFileTree(pluginDirPath, visitor);
            List<Path> pluginDependencies = visitor.getMatchedPaths();
            return this.pathsToURLArray(pluginDependencies);
        }
        catch (IOException ioe) {
            log.error("Unexpected error while looking for plugin dependencies", (Throwable)ioe);
            return new URL[0];
        }
    }

    private URL[] extractPluginExtensionDependencies(PluginManifest manifest, Path registryPath) {
        Path extPath = Paths.get(registryPath.toString(), "ext", manifest.id());
        if (extPath.toFile().exists()) {
            return this.extractPluginDependencies(extPath);
        }
        return new URL[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PluginManifest readPluginManifest(Path pluginPath) {
        try (DirectoryStream<Path> stream = FileUtils.newDirectoryStream(pluginPath, JAR_GLOB);){
            Iterator<Path> iterator = stream.iterator();
            if (!iterator.hasNext()) {
                log.debug("Unable to find a jar in the root directory: {}", (Object)pluginPath);
                PluginManifest pluginManifest = null;
                return pluginManifest;
            }
            Path pluginJarPath = iterator.next();
            log.debug("Found a jar in the root directory, looking for a plugin manifest in {}", (Object)pluginJarPath);
            Properties pluginManifestProperties = this.loadPluginManifest(pluginJarPath.toString());
            if (pluginManifestProperties.isEmpty()) {
                log.error("No plugin.properties found from {}", (Object)pluginJarPath);
                PluginManifest pluginManifest = null;
                return pluginManifest;
            }
            log.debug("A plugin manifest has been loaded from: {}", (Object)pluginJarPath);
            PropertiesBasedPluginManifestValidator validator = new PropertiesBasedPluginManifestValidator(pluginManifestProperties);
            if (!validator.validate()) {
                log.error("Plugin manifest not valid, skipping plugin registration.");
                PluginManifest pluginManifest = null;
                return pluginManifest;
            }
            PluginManifest pluginManifest = PluginManifestFactory.create(pluginManifestProperties);
            return pluginManifest;
        }
        catch (IOException ioe) {
            log.error("Unexpected error while trying to load plugin manifest", (Throwable)ioe);
            throw new IllegalStateException("Unexpected error while trying to load plugin manifest", ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadPluginManifest(String pluginPath) {
        try (FileSystem zipFileSystem = FileUtils.createZipFileSystem(pluginPath, false);){
            Path root = zipFileSystem.getPath("/", new String[0]);
            PluginManifestVisitor visitor = new PluginManifestVisitor();
            Files.walkFileTree(root, visitor);
            Path pluginManifestPath = visitor.getPluginManifest();
            if (pluginManifestPath == null) return new Properties();
            Properties properties2 = new Properties();
            try (InputStream is = Files.newInputStream(pluginManifestPath, new OpenOption[0]);){
                properties2.load(is);
            }
            Properties properties = properties2;
            return properties;
        }
        catch (IOException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
        }
        return new Properties();
    }

    private URL[] pathsToURLArray(List<Path> paths) {
        URL[] urls = new URL[paths.size()];
        int idx = 0;
        for (Path path : paths) {
            try {
                urls[idx++] = path.toUri().toURL();
            }
            catch (IOException iOException) {}
        }
        return urls;
    }

    @Override
    public Collection<Plugin> plugins() {
        return this.plugins;
    }

    @Override
    public Collection<Plugin> plugins(String type) {
        Map<String, Plugin> plugins = this.pluginByType.get(type);
        return plugins != null ? plugins.values() : Collections.emptySet();
    }

    @Override
    public Plugin get(String type, String id) {
        Map<String, Plugin> plugins = this.pluginByType.get(type);
        return plugins != null ? plugins.get(id) : null;
    }

    public PluginRegistryImpl(PluginRegistryConfiguration configuration, Environment environment, ExecutorService executor, EventManager eventManager) {
        this.configuration = configuration;
        this.environment = environment;
        this.executor = executor;
        this.eventManager = eventManager;
    }

    static {
        PLUGIN_TYPE_PROPERTY_ALIASES.put("service", "services");
        PLUGIN_TYPE_PROPERTY_ALIASES.put("policy", "policies");
        PLUGIN_TYPE_PROPERTY_ALIASES.put("alert", "alerts");
        PLUGIN_TYPE_PROPERTY_ALIASES.put("fetcher", "fetchers");
        PLUGIN_TYPE_PROPERTY_ALIASES.put("connector", "connectors");
        PLUGIN_TYPE_PROPERTY_ALIASES.put("notifier", "notifiers");
        PLUGIN_TYPE_PROPERTY_ALIASES.put("service_discovery", "service-discoveries");
    }

    static class PluginManifestVisitor
    extends SimpleFileVisitor<Path> {
        private Path pluginManifest = null;

        PluginManifestVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.getFileName().toString().equals(PluginRegistryImpl.PLUGIN_MANIFEST_FILE)) {
                this.pluginManifest = file;
                return FileVisitResult.TERMINATE;
            }
            return super.visitFile(file, attrs);
        }

        public Path getPluginManifest() {
            return this.pluginManifest;
        }
    }
}

