/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.internal;

import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.core.api.PluginClassLoaderFactory;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoaderFactoryImpl<T extends Plugin>
implements PluginClassLoaderFactory<T> {
    protected final Logger LOGGER = LoggerFactory.getLogger(PluginClassLoaderFactoryImpl.class);

    @Override
    public PluginClassLoader getOrCreateClassLoader(T plugin, ClassLoader parent) {
        try {
            PluginClassLoader cl = new PluginClassLoader(URLClassLoader.newInstance(plugin.dependencies(), parent));
            this.LOGGER.debug("Created plugin classLoader for {} with classpath {}", (Object)plugin.id(), (Object)plugin.dependencies());
            return cl;
        }
        catch (Throwable t) {
            this.LOGGER.error("Unexpected error while creating plugin classloader", t);
            return null;
        }
    }
}

