/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.internal;

import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.core.internal.PluginClassLoaderFactoryImpl;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedPluginClassLoaderFactory<T extends Plugin>
extends PluginClassLoaderFactoryImpl<T> {
    private final Logger LOGGER = LoggerFactory.getLogger(CachedPluginClassLoaderFactory.class);
    private final Map<String, PluginClassLoader> pluginClassLoaderCache = new HashMap<String, PluginClassLoader>();

    @Override
    public PluginClassLoader getOrCreateClassLoader(T plugin, ClassLoader parent) {
        try {
            PluginClassLoader cl = this.pluginClassLoaderCache.get(plugin.id());
            if (null == cl) {
                cl = super.getOrCreateClassLoader(plugin, parent);
                this.pluginClassLoaderCache.put(plugin.id(), cl);
            }
            this.LOGGER.debug("Created plugin ClassLoader for {} with classpath {}", (Object)plugin.id(), (Object)plugin.dependencies());
            return cl;
        }
        catch (Throwable t) {
            this.LOGGER.error("Unexpected error while creating plugin classloader", t);
            return null;
        }
    }
}

