/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.internal;

import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoaderFactory;
import io.gravitee.plugin.core.api.PluginConfigurationResolver;
import io.gravitee.plugin.core.api.PluginContextConfigurer;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class AnnotationBasedPluginContextConfigurer
implements PluginContextConfigurer {
    private final Logger LOGGER = LoggerFactory.getLogger(AnnotationBasedPluginContextConfigurer.class);
    @Autowired
    private PluginConfigurationResolver pluginConfigurationResolver;
    @Autowired
    private PluginClassLoaderFactory pluginClassLoaderFactory;
    @Autowired
    private ApplicationContext containerContext;
    protected GenericApplicationContext pluginContext;
    private final Plugin plugin;

    public AnnotationBasedPluginContextConfigurer(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Plugin plugin() {
        return this.plugin;
    }

    @Override
    public ClassLoader classLoader() {
        return this.pluginClassLoaderFactory.getOrCreateClassLoader(this.plugin);
    }

    public ConfigurableEnvironment environment() {
        return (ConfigurableEnvironment)this.containerContext.getEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableApplicationContext applicationContext() {
        if (this.pluginContext == null) {
            this.LOGGER.debug("Initializing a new plugin context for {}", (Object)this.plugin.id());
            ClassLoader pluginClassLoader = this.classLoader();
            ClassLoader containerClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(pluginClassLoader);
                AnnotationConfigApplicationContext configApplicationContext = new AnnotationConfigApplicationContext();
                configApplicationContext.setClassLoader(pluginClassLoader);
                configApplicationContext.setEnvironment(this.environment());
                configApplicationContext.setParent(this.containerContext);
                Set<Class<?>> configurations = this.configurations();
                if (configurations != null && !configurations.isEmpty()) {
                    Object[] configurationsArray = configurations.toArray(new Class[0]);
                    this.LOGGER.debug("Registering following @Configuration classes for {}: {}", (Object)this.plugin.id(), (Object)Arrays.toString(configurationsArray));
                    configApplicationContext.register((Class[])configurationsArray);
                }
                this.pluginContext = configApplicationContext;
            }
            finally {
                Thread.currentThread().setContextClassLoader(containerClassLoader);
            }
        }
        return this.pluginContext;
    }

    @Override
    public Set<Class<?>> configurations() {
        return this.pluginConfigurationResolver.resolve(this.plugin);
    }

    @Override
    public void registerBeans() {
        if (!this.plugin.type().equalsIgnoreCase("policy")) {
            this.pluginContext.registerBeanDefinition(this.plugin.clazz(), (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition((String)this.plugin.clazz()).getBeanDefinition());
        }
    }

    @Override
    public void registerBeanFactoryPostProcessor() {
        PropertySourcesPlaceholderConfigurer configurer = new PropertySourcesPlaceholderConfigurer();
        configurer.setIgnoreUnresolvablePlaceholders(true);
        configurer.setEnvironment((Environment)this.pluginContext.getEnvironment());
        this.pluginContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
    }
}

