/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.api;

import io.gravitee.plugin.core.api.AbstractPluginHandler;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginContextFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class AbstractSpringPluginHandler<T>
extends AbstractPluginHandler {
    @Autowired
    private PluginContextFactory pluginContextFactory;

    @Override
    protected void handle(Plugin plugin, Class<?> pluginClass) {
        if (plugin.deployed()) {
            try {
                ApplicationContext context = this.pluginContextFactory.create(plugin);
                Object pluginInst = context.getBean(pluginClass);
                this.register(pluginInst);
            }
            catch (Exception ex) {
                this.logger.error("Unexpected error while creating {}", (Object)plugin.id(), (Object)ex);
                this.pluginContextFactory.remove(plugin);
            }
        }
    }

    protected abstract void register(T var1);
}

