/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.api;

import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractPluginManager<T extends Plugin>
implements PluginManager<T> {
    private final Map<String, T> plugins = new HashMap<String, T>();

    @Override
    public void register(T plugin) {
        this.plugins.putIfAbsent(plugin.id(), plugin);
    }

    @Override
    public Collection<T> findAll() {
        return this.plugins.values().stream().filter(Plugin::deployed).collect(Collectors.toList());
    }

    @Override
    public Collection<T> findAll(boolean includeNotDeployed) {
        if (includeNotDeployed) {
            return this.plugins.values();
        }
        return this.findAll();
    }

    @Override
    public T get(String pluginId) {
        Plugin plugin = (Plugin)this.plugins.get(pluginId);
        if (plugin != null && !plugin.deployed()) {
            return null;
        }
        return (T)plugin;
    }

    @Override
    public T get(String pluginId, boolean includeNotDeployed) {
        if (includeNotDeployed) {
            return (T)((Plugin)this.plugins.get(pluginId));
        }
        return this.get(pluginId);
    }
}

