/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.api;

import io.gravitee.plugin.core.api.AbstractPluginManager;
import io.gravitee.plugin.core.api.ConfigurablePlugin;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.PluginMoreInformation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurablePluginManager<T extends ConfigurablePlugin>
extends AbstractPluginManager<T>
implements ConfigurablePluginManager<T> {
    private final Logger logger = LoggerFactory.getLogger(AbstractConfigurablePluginManager.class);
    private static final String SCHEMAS_DIRECTORY = "schemas";
    private static final String DOCS_DIRECTORY = "docs";

    @Override
    public String getSchema(String pluginId) throws IOException {
        return this.getSchema(pluginId, false);
    }

    @Override
    public String getSchema(String pluginId, boolean includeNotDeployed) throws IOException {
        return this.getFirstFile(pluginId, SCHEMAS_DIRECTORY, includeNotDeployed);
    }

    @Override
    public String getSchema(String pluginId, String subFolder) throws IOException {
        return this.getSchema(pluginId, subFolder, false);
    }

    @Override
    public String getSchema(String pluginId, String subFolder, boolean includeNotDeployed) throws IOException {
        return this.getFirstFile(pluginId, String.format("%s/%s", SCHEMAS_DIRECTORY, subFolder), includeNotDeployed);
    }

    @Override
    public String getIcon(String pluginId) throws IOException {
        return this.getIcon(pluginId, false);
    }

    @Override
    public String getIcon(String pluginId, boolean includeNotDeployed) throws IOException {
        ConfigurablePlugin plugin = (ConfigurablePlugin)this.get(pluginId, includeNotDeployed);
        if (plugin != null) {
            Map<String, String> properties = plugin.manifest().properties();
            return this.getFileFromPropertyAsBase64(plugin, properties, "icon");
        }
        return null;
    }

    private String getFileFromPropertyAsBase64(T plugin, Map<String, String> properties, String property) throws IOException {
        if (properties != null && properties.containsKey(property)) {
            try {
                Path file = Paths.get(plugin.path().toString(), properties.get(property));
                String mimeType = Files.probeContentType(file);
                return "data:" + mimeType + ";base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(file));
            }
            catch (NoSuchFileException ex) {
                this.logger.warn("File not found {}", (Object)plugin.path().toString());
            }
        }
        return null;
    }

    @Override
    public String getDocumentation(String pluginId) throws IOException {
        return this.getFirstFile(pluginId, DOCS_DIRECTORY, false);
    }

    @Override
    public String getDocumentation(String pluginId, boolean includeNotDeployed) throws IOException {
        return this.getFirstFile(pluginId, DOCS_DIRECTORY, includeNotDeployed);
    }

    @Override
    public String getCategory(String pluginId) throws IOException {
        return this.getCategory(pluginId, false);
    }

    @Override
    public String getCategory(String pluginId, boolean includeNotDeployed) throws IOException {
        Map<String, String> properties;
        ConfigurablePlugin plugin = (ConfigurablePlugin)this.get(pluginId, includeNotDeployed);
        if (plugin != null && (properties = plugin.manifest().properties()) != null) {
            return properties.get("category");
        }
        return null;
    }

    private String getFirstFile(String pluginId, String directory, boolean includeNotDeployed) throws IOException {
        ConfigurablePlugin plugin = (ConfigurablePlugin)this.get(pluginId, includeNotDeployed);
        if (plugin != null) {
            Path workspaceDir = plugin.path();
            File dir = new File(workspaceDir.toString(), directory);
            File[] files = dir.listFiles(File::isFile);
            if (files != null && files.length > 0) {
                return new String(Files.readAllBytes(files[0].toPath()));
            }
            return null;
        }
        return null;
    }

    @Override
    public PluginMoreInformation getMoreInformation(String pluginId) throws IOException {
        return this.getMoreInformation(pluginId, false);
    }

    @Override
    public PluginMoreInformation getMoreInformation(String pluginId, boolean includeNotDeployed) throws IOException {
        ConfigurablePlugin plugin = (ConfigurablePlugin)this.get(pluginId, includeNotDeployed);
        if (plugin != null) {
            Map<String, String> properties = plugin.manifest().properties();
            PluginMoreInformation pluginMoreInformation = new PluginMoreInformation();
            if (properties != null) {
                pluginMoreInformation.setDescription(properties.get("moreInfo.description"));
                pluginMoreInformation.setDocumentationUrl(properties.get("moreInfo.documentationUrl"));
                pluginMoreInformation.setSchemaImg(this.getFileFromPropertyAsBase64(plugin, properties, "moreInfo.schemaImg"));
            }
            return pluginMoreInformation;
        }
        return null;
    }
}

