/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.utils;

import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class GlobMatchingFileVisitor
extends SimpleFileVisitor<Path> {
    private final PathMatcher matcher;
    private List<Path> matchedPaths = new ArrayList<Path>();

    public GlobMatchingFileVisitor(String pattern) {
        this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attribs) {
        Path name = file.getFileName();
        if (this.matcher.matches(name)) {
            this.matchedPaths.add(file);
        }
        return FileVisitResult.CONTINUE;
    }

    public List<Path> getMatchedPaths() {
        return this.matchedPaths;
    }
}

