/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.internal;

import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginContextConfigurer;
import io.gravitee.plugin.core.api.PluginContextFactory;
import io.gravitee.plugin.core.internal.AnnotationBasedPluginContextConfigurer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class PluginContextFactoryImpl
implements PluginContextFactory,
ApplicationContextAware {
    protected final Logger LOGGER = LoggerFactory.getLogger(PluginContextFactoryImpl.class);
    private final Map<Plugin, ConfigurableApplicationContext> pluginContexts = new HashMap<Plugin, ConfigurableApplicationContext>();
    private ApplicationContext containerContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationContext create(PluginContextConfigurer pluginContextConfigurer) {
        this.containerContext.getAutowireCapableBeanFactory().autowireBean((Object)pluginContextConfigurer);
        Plugin plugin = pluginContextConfigurer.plugin();
        this.LOGGER.debug("Create context for plugin: {}", (Object)plugin.id());
        ConfigurableApplicationContext pluginContext = pluginContextConfigurer.applicationContext();
        pluginContextConfigurer.registerBeanFactoryPostProcessor();
        pluginContextConfigurer.registerBeans();
        ClassLoader pluginClassLoader = pluginContextConfigurer.classLoader();
        ClassLoader containerClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            pluginContext.refresh();
        }
        catch (Exception ex) {
            this.LOGGER.error("Unable to refresh plugin context", (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(containerClassLoader);
        }
        this.pluginContexts.putIfAbsent(plugin, pluginContext);
        return pluginContext;
    }

    @Override
    public ApplicationContext create(Plugin plugin) {
        return this.create(new AnnotationBasedPluginContextConfigurer(plugin));
    }

    @Override
    public void remove(Plugin plugin) {
        ConfigurableApplicationContext ctx = this.pluginContexts.remove(plugin);
        if (ctx != null) {
            ctx.close();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.containerContext = applicationContext;
    }
}

