/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.api;

import io.gravitee.plugin.core.api.PluginDependency;
import io.gravitee.plugin.core.api.PluginManifest;
import io.gravitee.plugin.core.internal.PluginDependencyImpl;
import io.gravitee.plugin.core.internal.PluginManifestProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PluginManifestFactory {
    public static PluginManifest create(Properties properties) {
        final String id = properties.getProperty("id");
        final String description = properties.getProperty("description");
        final String clazz = properties.getProperty("class");
        final String name = properties.getProperty("name");
        final String version = properties.getProperty("version");
        final String type = properties.getProperty("type");
        final String category = properties.getProperty("category");
        final int priority = Integer.parseInt(properties.getProperty("priority", "1000"));
        final List dependencies = Stream.of(properties.getProperty("dependencies", "").split(",")).filter(s -> !"".equals(s)).map(dependencyStr -> {
            String[] split = dependencyStr.split(":");
            if (split.length == 1) {
                return new PluginDependencyImpl(split[0], "*");
            }
            return new PluginDependencyImpl(split[0], split[1]);
        }).collect(Collectors.toList());
        final HashMap propertiesMap = new HashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(o, o2) -> {
            String key = o.toString();
            if (!PluginManifestProperties.MANIFEST_PROPERTIES.contains(key)) {
                propertiesMap.put(o.toString(), o2.toString());
            }
        }));
        return new PluginManifest(){

            @Override
            public String id() {
                return id;
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public String description() {
                return description;
            }

            @Override
            public String category() {
                return category;
            }

            @Override
            public String version() {
                return version;
            }

            @Override
            public String plugin() {
                return clazz;
            }

            @Override
            public String type() {
                return type;
            }

            @Override
            public int priority() {
                return priority;
            }

            @Override
            public List<PluginDependency> dependencies() {
                return dependencies;
            }

            @Override
            public Map<String, String> properties() {
                return propertiesMap;
            }
        };
    }
}

