/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.api;

import io.gravitee.plugin.api.PluginDeploymentContextFactory;
import io.gravitee.plugin.api.PluginDeploymentLifecycle;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.core.api.PluginHandler;
import java.io.IOException;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public abstract class AbstractPluginHandler
implements PluginHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Environment environment;
    @Autowired
    private PluginDeploymentContextFactory pluginDeploymentContextFactory;

    @Override
    public void handle(Plugin plugin) {
        block10: {
            block11: {
                if (!this.isEnabled(plugin)) break block11;
                this.logger.info("Install plugin: {} [{}]", (Object)plugin.id(), (Object)plugin.clazz());
                ClassLoader classloader = null;
                try {
                    classloader = this.getClassLoader(plugin);
                    Class<?> pluginClass = classloader.loadClass(plugin.clazz());
                    io.gravitee.plugin.api.annotations.Plugin ann = pluginClass.getAnnotation(io.gravitee.plugin.api.annotations.Plugin.class);
                    if (ann != null) {
                        Class deploymentClass = ann.deployment();
                        PluginDeploymentLifecycle pluginDeploymentLifecycle = (PluginDeploymentLifecycle)deploymentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (pluginDeploymentLifecycle.isDeployable(this.pluginDeploymentContextFactory.create())) {
                            this.handle(plugin, pluginClass);
                        } else {
                            this.logger.warn("Plugin {} can't be deployed", (Object)plugin.id());
                        }
                        break block10;
                    }
                    this.handle(plugin, pluginClass);
                }
                catch (Throwable t) {
                    this.logger.error("An error occurs while installing plugin: {} [{}]", new Object[]{plugin.id(), plugin.clazz(), t});
                    if (classloader instanceof URLClassLoader) {
                        try {
                            ((URLClassLoader)classloader).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!(classloader instanceof PluginClassLoader)) break block10;
                    try {
                        ((PluginClassLoader)classloader).close();
                        break block10;
                    }
                    catch (IOException iOException) {}
                }
                break block10;
            }
            this.logger.info("Installation skipped for: {} [{}]", (Object)plugin.id(), (Object)plugin.clazz());
        }
    }

    private boolean isEnabled(Plugin plugin) {
        boolean enabled = (Boolean)this.environment.getProperty(this.type() + '.' + plugin.id() + ".enabled", Boolean.class, (Object)true);
        this.logger.debug("Plugin {} is enabled: {}", (Object)plugin.id(), (Object)enabled);
        return enabled;
    }

    protected abstract String type();

    protected abstract ClassLoader getClassLoader(Plugin var1) throws Exception;

    protected abstract void handle(Plugin var1, Class<?> var2);
}

