/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.api;

import io.gravitee.plugin.core.api.AbstractPluginManager;
import io.gravitee.plugin.core.api.ConfigurablePlugin;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Map;

public abstract class AbstractConfigurablePluginManager<T extends ConfigurablePlugin>
extends AbstractPluginManager<T>
implements ConfigurablePluginManager<T> {
    private static final String SCHEMAS_DIRECTORY = "schemas";
    private static final String DOCS_DIRECTORY = "docs";

    @Override
    public String getSchema(String pluginId) throws IOException {
        return this.getFirstFile(pluginId, SCHEMAS_DIRECTORY);
    }

    @Override
    public String getIcon(String pluginId) throws IOException {
        String icon;
        ConfigurablePlugin plugin = (ConfigurablePlugin)this.get(pluginId);
        Map<String, String> properties = plugin.manifest().properties();
        if (properties != null && (icon = properties.get("icon")) != null) {
            Path iconFile = Paths.get(plugin.path().toString(), icon);
            String mimeType = Files.probeContentType(iconFile);
            return "data:" + mimeType + ";base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(iconFile));
        }
        return null;
    }

    @Override
    public String getDocumentation(String pluginId) throws IOException {
        return this.getFirstFile(pluginId, DOCS_DIRECTORY);
    }

    @Override
    public String getCategory(String pluginId) throws IOException {
        ConfigurablePlugin plugin = (ConfigurablePlugin)this.get(pluginId);
        Map<String, String> properties = plugin.manifest().properties();
        if (properties != null) {
            return properties.get("category");
        }
        return null;
    }

    private String getFirstFile(String pluginId, String directory) throws IOException {
        File dir;
        Path workspaceDir;
        File[] matches;
        ConfigurablePlugin plugin = (ConfigurablePlugin)this.get(pluginId);
        if (plugin != null && (matches = (workspaceDir = plugin.path()).toFile().listFiles(pathname -> pathname.isDirectory() && pathname.getName().equals(directory))).length == 1 && (dir = matches[0]).listFiles().length > 0) {
            return new String(Files.readAllBytes(dir.listFiles()[0].toPath()));
        }
        return null;
    }
}

