/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.connector.internal;

import io.gravitee.connector.api.ConnectorFactory;
import io.gravitee.plugin.connector.ConnectorClassLoaderFactory;
import io.gravitee.plugin.connector.ConnectorPlugin;
import io.gravitee.plugin.connector.ConnectorPluginManager;
import io.gravitee.plugin.core.api.AbstractConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorPluginManagerImpl
extends AbstractConfigurablePluginManager<ConnectorPlugin>
implements ConnectorPluginManager {
    private final Logger logger = LoggerFactory.getLogger(ConnectorPluginManagerImpl.class);
    private final ConnectorClassLoaderFactory classLoaderFactory;
    private final Map<String, ConnectorFactory<?>> factories = new HashMap();
    private final Map<String, ConnectorFactory<?>> factoriesByType = new HashMap();

    public ConnectorPluginManagerImpl(ConnectorClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
    }

    public void register(ConnectorPlugin plugin) {
        super.register((Plugin)plugin);
        PluginClassLoader pluginClassLoader = this.classLoaderFactory.getOrCreateClassLoader(plugin);
        try {
            Class connectorFactoryClass = pluginClassLoader.loadClass(plugin.clazz());
            ConnectorFactory factory = (ConnectorFactory)connectorFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.factories.put(plugin.id(), factory);
            Collection types = factory.supportedTypes();
            if (types != null) {
                for (String type : types) {
                    this.factoriesByType.put(type.toLowerCase(), factory);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while loading connector plugin: {}", (Object)plugin.clazz(), (Object)ex);
        }
    }

    @Override
    public ConnectorFactory<?> getConnectorByType(String type) {
        return this.factoriesByType.get(type.toLowerCase());
    }

    @Override
    public ConnectorFactory<?> getConnector(String pluginId) {
        return this.factories.get(pluginId);
    }
}

