/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.alert.internal;

import io.gravitee.alert.api.trigger.TriggerProvider;
import io.gravitee.common.service.AbstractService;
import io.gravitee.plugin.alert.AlertTriggerProviderManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertTriggerProviderManagerImpl
extends AbstractService
implements AlertTriggerProviderManager {
    private final Logger logger = LoggerFactory.getLogger(AlertTriggerProviderManagerImpl.class);
    private final Collection<TriggerProvider> triggerProviders = new ArrayList<TriggerProvider>();
    private final List<TriggerProvider.Listener> listeners = new ArrayList<TriggerProvider.Listener>();

    @Override
    public void register(TriggerProvider triggerProvider) {
        this.triggerProviders.add(triggerProvider);
    }

    @Override
    public Collection<TriggerProvider> findAll() {
        return this.triggerProviders;
    }

    @Override
    public void addListener(TriggerProvider.Listener listener) {
        this.listeners.add(listener);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.triggerProviders.isEmpty()) {
            for (TriggerProvider provider : this.triggerProviders) {
                try {
                    this.listeners.forEach(arg_0 -> ((TriggerProvider)provider).addListener(arg_0));
                    provider.start();
                }
                catch (Exception ex) {
                    this.logger.error("Unexpected error while starting a trigger provider", (Throwable)ex);
                }
            }
        } else {
            this.logger.info("\tThere is no trigger provider to start");
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        for (TriggerProvider provider : this.triggerProviders) {
            try {
                provider.stop();
            }
            catch (Exception ex) {
                this.logger.error("Unexpected error while stopping trigger provider: {}", (Object)provider, (Object)ex);
            }
        }
    }

    protected String name() {
        return "Alert Engine - Trigger provider manager";
    }
}

