/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.alert.internal;

import io.gravitee.alert.api.event.EventProducer;
import io.gravitee.common.service.AbstractService;
import io.gravitee.plugin.alert.AlertEventProducerManager;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertEventProducerManagerImpl
extends AbstractService
implements AlertEventProducerManager {
    private final Logger logger = LoggerFactory.getLogger(AlertEventProducerManagerImpl.class);
    private final Collection<EventProducer> eventProducers = new ArrayList<EventProducer>();

    @Override
    public void register(EventProducer eventProducer) {
        this.eventProducers.add(eventProducer);
    }

    @Override
    public Collection<EventProducer> findAll() {
        return this.eventProducers;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.eventProducers.isEmpty()) {
            for (EventProducer producer : this.eventProducers) {
                try {
                    producer.start();
                }
                catch (Exception ex) {
                    this.logger.error("Unexpected error while starting an event producer", (Throwable)ex);
                }
            }
        } else {
            this.logger.info("\tThere is no event producer to start");
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        for (EventProducer producer : this.eventProducers) {
            try {
                producer.stop();
            }
            catch (Exception ex) {
                this.logger.error("Unexpected error while stopping event producer: {}", (Object)producer, (Object)ex);
            }
        }
    }

    protected String name() {
        return "Alert Engine - Event producer";
    }
}

