/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.alert.internal;

import io.gravitee.alert.api.event.EventProducer;
import io.gravitee.alert.api.trigger.TriggerProvider;
import io.gravitee.plugin.alert.AlertEventProducerManager;
import io.gravitee.plugin.alert.AlertTriggerProviderManager;
import io.gravitee.plugin.core.api.AbstractSpringPluginHandler;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoaderFactory;
import io.gravitee.plugin.core.api.PluginContextFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class AlertPluginHandler
extends AbstractSpringPluginHandler<Void> {
    @Autowired
    private PluginContextFactory pluginContextFactory;
    @Autowired
    private PluginClassLoaderFactory pluginClassLoaderFactory;
    @Autowired
    private AlertEventProducerManager eventProducerManager;
    @Autowired
    private AlertTriggerProviderManager triggerProviderManager;

    public boolean canHandle(Plugin plugin) {
        return "alert".equalsIgnoreCase(plugin.type());
    }

    protected void handle(Plugin plugin, Class pluginClass) {
        try {
            ApplicationContext context = this.pluginContextFactory.create(plugin);
            try {
                this.eventProducerManager.register((EventProducer)context.getBean(EventProducer.class));
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
            try {
                this.triggerProviderManager.register((TriggerProvider)context.getBean(TriggerProvider.class));
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while creating {}", (Object)plugin.id(), (Object)ex);
            this.pluginContextFactory.remove(plugin);
        }
    }

    protected String type() {
        return "alerts";
    }

    protected ClassLoader getClassLoader(Plugin plugin) throws Exception {
        return this.pluginClassLoaderFactory.getOrCreateClassLoader(plugin, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected void register(Void plugin) {
    }
}

